<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseServiceReportVolume StructType
 * @subpackage Structs
 */
class HouseServiceReportVolume extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The periodicity
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $periodicity;
    /**
     * The unit_of_measurement
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $unit_of_measurement;
    /**
     * The cost_per_unit
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $cost_per_unit;
    /**
     * Constructor method for HouseServiceReportVolume
     * @uses HouseServiceReportVolume::setId()
     * @uses HouseServiceReportVolume::setName()
     * @uses HouseServiceReportVolume::setPeriodicity()
     * @uses HouseServiceReportVolume::setUnit_of_measurement()
     * @uses HouseServiceReportVolume::setCost_per_unit()
     * @param int $id
     * @param string $name
     * @param string $periodicity
     * @param string $unit_of_measurement
     * @param float $cost_per_unit
     */
    public function __construct($id = null, $name = null, $periodicity = null, $unit_of_measurement = null, $cost_per_unit = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setPeriodicity($periodicity)
            ->setUnit_of_measurement($unit_of_measurement)
            ->setCost_per_unit($cost_per_unit);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseServiceReportVolume
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\HouseServiceReportVolume
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get periodicity value
     * @return string|null
     */
    public function getPeriodicity()
    {
        return $this->periodicity;
    }
    /**
     * Set periodicity value
     * @uses \EnumType\HouseReportServicesVolumesPeriodicityEnum::valueIsValid()
     * @uses \EnumType\HouseReportServicesVolumesPeriodicityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicity
     * @return \StructType\HouseServiceReportVolume
     */
    public function setPeriodicity($periodicity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseReportServicesVolumesPeriodicityEnum::valueIsValid($periodicity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseReportServicesVolumesPeriodicityEnum', is_array($periodicity) ? implode(', ', $periodicity) : var_export($periodicity, true), implode(', ', \EnumType\HouseReportServicesVolumesPeriodicityEnum::getValidValues())), __LINE__);
        }
        $this->periodicity = $periodicity;
        return $this;
    }
    /**
     * Get unit_of_measurement value
     * @return string|null
     */
    public function getUnit_of_measurement()
    {
        return $this->unit_of_measurement;
    }
    /**
     * Set unit_of_measurement value
     * @uses \EnumType\UnitOfMeasureEnum::valueIsValid()
     * @uses \EnumType\UnitOfMeasureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit_of_measurement
     * @return \StructType\HouseServiceReportVolume
     */
    public function setUnit_of_measurement($unit_of_measurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasureEnum::valueIsValid($unit_of_measurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UnitOfMeasureEnum', is_array($unit_of_measurement) ? implode(', ', $unit_of_measurement) : var_export($unit_of_measurement, true), implode(', ', \EnumType\UnitOfMeasureEnum::getValidValues())), __LINE__);
        }
        $this->unit_of_measurement = $unit_of_measurement;
        return $this;
    }
    /**
     * Get cost_per_unit value
     * @return float|null
     */
    public function getCost_per_unit()
    {
        return $this->cost_per_unit;
    }
    /**
     * Set cost_per_unit value
     * @param float $cost_per_unit
     * @return \StructType\HouseServiceReportVolume
     */
    public function setCost_per_unit($cost_per_unit = null)
    {
        // validation for constraint: float
        if (!is_null($cost_per_unit) && !(is_float($cost_per_unit) || is_numeric($cost_per_unit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost_per_unit, true), gettype($cost_per_unit)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($cost_per_unit) && mb_strlen(mb_substr($cost_per_unit, mb_strpos($cost_per_unit, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($cost_per_unit, true), mb_strlen(mb_substr($cost_per_unit, mb_strpos($cost_per_unit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($cost_per_unit) && mb_strlen(preg_replace('/(\D)/', '', $cost_per_unit)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($cost_per_unit, true), mb_strlen(preg_replace('/(\D)/', '', $cost_per_unit))), __LINE__);
        }
        $this->cost_per_unit = $cost_per_unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseServiceReportVolume
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
