<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseServiceCost StructType
 * @subpackage Structs
 */
class HouseServiceCost extends AbstractStructBase
{
    /**
     * The year
     * @var int
     */
    public $year;
    /**
     * The plan_cost_per_unit
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $plan_cost_per_unit;
    /**
     * Constructor method for HouseServiceCost
     * @uses HouseServiceCost::setYear()
     * @uses HouseServiceCost::setPlan_cost_per_unit()
     * @param int $year
     * @param float $plan_cost_per_unit
     */
    public function __construct($year = null, $plan_cost_per_unit = null)
    {
        $this
            ->setYear($year)
            ->setPlan_cost_per_unit($plan_cost_per_unit);
    }
    /**
     * Get year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param int $year
     * @return \StructType\HouseServiceCost
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get plan_cost_per_unit value
     * @return float|null
     */
    public function getPlan_cost_per_unit()
    {
        return $this->plan_cost_per_unit;
    }
    /**
     * Set plan_cost_per_unit value
     * @param float $plan_cost_per_unit
     * @return \StructType\HouseServiceCost
     */
    public function setPlan_cost_per_unit($plan_cost_per_unit = null)
    {
        // validation for constraint: float
        if (!is_null($plan_cost_per_unit) && !(is_float($plan_cost_per_unit) || is_numeric($plan_cost_per_unit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($plan_cost_per_unit, true), gettype($plan_cost_per_unit)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($plan_cost_per_unit) && mb_strlen(mb_substr($plan_cost_per_unit, mb_strpos($plan_cost_per_unit, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($plan_cost_per_unit, true), mb_strlen(mb_substr($plan_cost_per_unit, mb_strpos($plan_cost_per_unit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($plan_cost_per_unit) && mb_strlen(preg_replace('/(\D)/', '', $plan_cost_per_unit)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($plan_cost_per_unit, true), mb_strlen(preg_replace('/(\D)/', '', $plan_cost_per_unit))), __LINE__);
        }
        $this->plan_cost_per_unit = $plan_cost_per_unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseServiceCost
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
