<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseReportQualityOfWorkClaims StructType
 * @subpackage Structs
 */
class HouseReportQualityOfWorkClaims extends AbstractStructBase
{
    /**
     * The claims_received_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $claims_received_count;
    /**
     * The claims_satisfied_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $claims_satisfied_count;
    /**
     * The claims_denied_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $claims_denied_count;
    /**
     * The produced_recalculation_amount
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $produced_recalculation_amount;
    /**
     * Constructor method for HouseReportQualityOfWorkClaims
     * @uses HouseReportQualityOfWorkClaims::setClaims_received_count()
     * @uses HouseReportQualityOfWorkClaims::setClaims_satisfied_count()
     * @uses HouseReportQualityOfWorkClaims::setClaims_denied_count()
     * @uses HouseReportQualityOfWorkClaims::setProduced_recalculation_amount()
     * @param int $claims_received_count
     * @param int $claims_satisfied_count
     * @param int $claims_denied_count
     * @param float $produced_recalculation_amount
     */
    public function __construct($claims_received_count = null, $claims_satisfied_count = null, $claims_denied_count = null, $produced_recalculation_amount = null)
    {
        $this
            ->setClaims_received_count($claims_received_count)
            ->setClaims_satisfied_count($claims_satisfied_count)
            ->setClaims_denied_count($claims_denied_count)
            ->setProduced_recalculation_amount($produced_recalculation_amount);
    }
    /**
     * Get claims_received_count value
     * @return int|null
     */
    public function getClaims_received_count()
    {
        return $this->claims_received_count;
    }
    /**
     * Set claims_received_count value
     * @param int $claims_received_count
     * @return \StructType\HouseReportQualityOfWorkClaims
     */
    public function setClaims_received_count($claims_received_count = null)
    {
        // validation for constraint: int
        if (!is_null($claims_received_count) && !(is_int($claims_received_count) || ctype_digit($claims_received_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($claims_received_count, true), gettype($claims_received_count)), __LINE__);
        }
        $this->claims_received_count = $claims_received_count;
        return $this;
    }
    /**
     * Get claims_satisfied_count value
     * @return int|null
     */
    public function getClaims_satisfied_count()
    {
        return $this->claims_satisfied_count;
    }
    /**
     * Set claims_satisfied_count value
     * @param int $claims_satisfied_count
     * @return \StructType\HouseReportQualityOfWorkClaims
     */
    public function setClaims_satisfied_count($claims_satisfied_count = null)
    {
        // validation for constraint: int
        if (!is_null($claims_satisfied_count) && !(is_int($claims_satisfied_count) || ctype_digit($claims_satisfied_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($claims_satisfied_count, true), gettype($claims_satisfied_count)), __LINE__);
        }
        $this->claims_satisfied_count = $claims_satisfied_count;
        return $this;
    }
    /**
     * Get claims_denied_count value
     * @return int|null
     */
    public function getClaims_denied_count()
    {
        return $this->claims_denied_count;
    }
    /**
     * Set claims_denied_count value
     * @param int $claims_denied_count
     * @return \StructType\HouseReportQualityOfWorkClaims
     */
    public function setClaims_denied_count($claims_denied_count = null)
    {
        // validation for constraint: int
        if (!is_null($claims_denied_count) && !(is_int($claims_denied_count) || ctype_digit($claims_denied_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($claims_denied_count, true), gettype($claims_denied_count)), __LINE__);
        }
        $this->claims_denied_count = $claims_denied_count;
        return $this;
    }
    /**
     * Get produced_recalculation_amount value
     * @return float|null
     */
    public function getProduced_recalculation_amount()
    {
        return $this->produced_recalculation_amount;
    }
    /**
     * Set produced_recalculation_amount value
     * @param float $produced_recalculation_amount
     * @return \StructType\HouseReportQualityOfWorkClaims
     */
    public function setProduced_recalculation_amount($produced_recalculation_amount = null)
    {
        // validation for constraint: float
        if (!is_null($produced_recalculation_amount) && !(is_float($produced_recalculation_amount) || is_numeric($produced_recalculation_amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($produced_recalculation_amount, true), gettype($produced_recalculation_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($produced_recalculation_amount) && mb_strlen(mb_substr($produced_recalculation_amount, mb_strpos($produced_recalculation_amount, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($produced_recalculation_amount, true), mb_strlen(mb_substr($produced_recalculation_amount, mb_strpos($produced_recalculation_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($produced_recalculation_amount) && mb_strlen(preg_replace('/(\D)/', '', $produced_recalculation_amount)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($produced_recalculation_amount, true), mb_strlen(preg_replace('/(\D)/', '', $produced_recalculation_amount))), __LINE__);
        }
        $this->produced_recalculation_amount = $produced_recalculation_amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseReportQualityOfWorkClaims
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
