<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseOverhaul StructType
 * @subpackage Structs
 */
class HouseOverhaul extends AbstractStructBase
{
    /**
     * The provider_inn
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $provider_inn;
    /**
     * The provider_name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $provider_name;
    /**
     * The common_meeting_protocol_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $common_meeting_protocol_date;
    /**
     * The common_meeting_protocol_number
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $common_meeting_protocol_number;
    /**
     * The payment_amount_for_1sm
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $payment_amount_for_1sm;
    /**
     * The additional_info
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $additional_info;
    /**
     * Constructor method for HouseOverhaul
     * @uses HouseOverhaul::setProvider_inn()
     * @uses HouseOverhaul::setProvider_name()
     * @uses HouseOverhaul::setCommon_meeting_protocol_date()
     * @uses HouseOverhaul::setCommon_meeting_protocol_number()
     * @uses HouseOverhaul::setPayment_amount_for_1sm()
     * @uses HouseOverhaul::setAdditional_info()
     * @param string $provider_inn
     * @param string $provider_name
     * @param string $common_meeting_protocol_date
     * @param string $common_meeting_protocol_number
     * @param float $payment_amount_for_1sm
     * @param string $additional_info
     */
    public function __construct($provider_inn = null, $provider_name = null, $common_meeting_protocol_date = null, $common_meeting_protocol_number = null, $payment_amount_for_1sm = null, $additional_info = null)
    {
        $this
            ->setProvider_inn($provider_inn)
            ->setProvider_name($provider_name)
            ->setCommon_meeting_protocol_date($common_meeting_protocol_date)
            ->setCommon_meeting_protocol_number($common_meeting_protocol_number)
            ->setPayment_amount_for_1sm($payment_amount_for_1sm)
            ->setAdditional_info($additional_info);
    }
    /**
     * Get provider_inn value
     * @return string|null
     */
    public function getProvider_inn()
    {
        return $this->provider_inn;
    }
    /**
     * Set provider_inn value
     * @param string $provider_inn
     * @return \StructType\HouseOverhaul
     */
    public function setProvider_inn($provider_inn = null)
    {
        // validation for constraint: string
        if (!is_null($provider_inn) && !is_string($provider_inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider_inn, true), gettype($provider_inn)), __LINE__);
        }
        $this->provider_inn = $provider_inn;
        return $this;
    }
    /**
     * Get provider_name value
     * @return string|null
     */
    public function getProvider_name()
    {
        return $this->provider_name;
    }
    /**
     * Set provider_name value
     * @param string $provider_name
     * @return \StructType\HouseOverhaul
     */
    public function setProvider_name($provider_name = null)
    {
        // validation for constraint: string
        if (!is_null($provider_name) && !is_string($provider_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider_name, true), gettype($provider_name)), __LINE__);
        }
        $this->provider_name = $provider_name;
        return $this;
    }
    /**
     * Get common_meeting_protocol_date value
     * @return string|null
     */
    public function getCommon_meeting_protocol_date()
    {
        return $this->common_meeting_protocol_date;
    }
    /**
     * Set common_meeting_protocol_date value
     * @param string $common_meeting_protocol_date
     * @return \StructType\HouseOverhaul
     */
    public function setCommon_meeting_protocol_date($common_meeting_protocol_date = null)
    {
        // validation for constraint: string
        if (!is_null($common_meeting_protocol_date) && !is_string($common_meeting_protocol_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($common_meeting_protocol_date, true), gettype($common_meeting_protocol_date)), __LINE__);
        }
        $this->common_meeting_protocol_date = $common_meeting_protocol_date;
        return $this;
    }
    /**
     * Get common_meeting_protocol_number value
     * @return string|null
     */
    public function getCommon_meeting_protocol_number()
    {
        return $this->common_meeting_protocol_number;
    }
    /**
     * Set common_meeting_protocol_number value
     * @param string $common_meeting_protocol_number
     * @return \StructType\HouseOverhaul
     */
    public function setCommon_meeting_protocol_number($common_meeting_protocol_number = null)
    {
        // validation for constraint: string
        if (!is_null($common_meeting_protocol_number) && !is_string($common_meeting_protocol_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($common_meeting_protocol_number, true), gettype($common_meeting_protocol_number)), __LINE__);
        }
        $this->common_meeting_protocol_number = $common_meeting_protocol_number;
        return $this;
    }
    /**
     * Get payment_amount_forsm value
     * @return payment_amount_forsm
     */
    public function getPayment_amount_for_1sm()
    {
        return $this->payment_amount_for_1sm;
    }
    /**
     * Set payment_amount_forsm value
     * @param payment_amount_forsm $payment_amount_forsm
     * @return \StructType\HouseOverhaul
     */
    public function setPayment_amount_for_1sm($payment_amount_for_1sm = null)
    {
        // validation for constraint: float
        if (!is_null($payment_amount_for_1sm) && !(is_float($payment_amount_for_1sm) || is_numeric($payment_amount_for_1sm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payment_amount_for_1sm, true), gettype($payment_amount_for_1sm)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($payment_amount_for_1sm) && mb_strlen(mb_substr($payment_amount_for_1sm, mb_strpos($payment_amount_for_1sm, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($payment_amount_for_1sm, true), mb_strlen(mb_substr($payment_amount_for_1sm, mb_strpos($payment_amount_for_1sm, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($payment_amount_for_1sm) && mb_strlen(preg_replace('/(\D)/', '', $payment_amount_for_1sm)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($payment_amount_for_1sm, true), mb_strlen(preg_replace('/(\D)/', '', $payment_amount_for_1sm))), __LINE__);
        }
        $this->payment_amount_for_1sm = $payment_amount_for_1sm;
        return $this;
    }
    /**
     * Get additional_info value
     * @return string|null
     */
    public function getAdditional_info()
    {
        return $this->additional_info;
    }
    /**
     * Set additional_info value
     * @param string $additional_info
     * @return \StructType\HouseOverhaul
     */
    public function setAdditional_info($additional_info = null)
    {
        // validation for constraint: string
        if (!is_null($additional_info) && !is_string($additional_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_info, true), gettype($additional_info)), __LINE__);
        }
        $this->additional_info = $additional_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseOverhaul
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
