<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseCommunalServiceVolumesReport StructType
 * @subpackage Structs
 */
class HouseCommunalServiceVolumesReport extends AbstractStructBase
{
    /**
     * The unit_of_measurement
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $unit_of_measurement;
    /**
     * The total_volume
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $total_volume;
    /**
     * The accrued_consumer
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $accrued_consumer;
    /**
     * The paid_by_consumers_amount
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $paid_by_consumers_amount;
    /**
     * The consumer_arrears
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $consumer_arrears;
    /**
     * The cash_to_provider_payment
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $cash_to_provider_payment;
    /**
     * The paid_to_supplier_amount
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $paid_to_supplier_amount;
    /**
     * The arrear_to_supplier_amount
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $arrear_to_supplier_amount;
    /**
     * The total_penalties
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $total_penalties;
    /**
     * Constructor method for HouseCommunalServiceVolumesReport
     * @uses HouseCommunalServiceVolumesReport::setUnit_of_measurement()
     * @uses HouseCommunalServiceVolumesReport::setTotal_volume()
     * @uses HouseCommunalServiceVolumesReport::setAccrued_consumer()
     * @uses HouseCommunalServiceVolumesReport::setPaid_by_consumers_amount()
     * @uses HouseCommunalServiceVolumesReport::setConsumer_arrears()
     * @uses HouseCommunalServiceVolumesReport::setCash_to_provider_payment()
     * @uses HouseCommunalServiceVolumesReport::setPaid_to_supplier_amount()
     * @uses HouseCommunalServiceVolumesReport::setArrear_to_supplier_amount()
     * @uses HouseCommunalServiceVolumesReport::setTotal_penalties()
     * @param string $unit_of_measurement
     * @param float $total_volume
     * @param float $accrued_consumer
     * @param float $paid_by_consumers_amount
     * @param float $consumer_arrears
     * @param float $cash_to_provider_payment
     * @param float $paid_to_supplier_amount
     * @param float $arrear_to_supplier_amount
     * @param float $total_penalties
     */
    public function __construct($unit_of_measurement = null, $total_volume = null, $accrued_consumer = null, $paid_by_consumers_amount = null, $consumer_arrears = null, $cash_to_provider_payment = null, $paid_to_supplier_amount = null, $arrear_to_supplier_amount = null, $total_penalties = null)
    {
        $this
            ->setUnit_of_measurement($unit_of_measurement)
            ->setTotal_volume($total_volume)
            ->setAccrued_consumer($accrued_consumer)
            ->setPaid_by_consumers_amount($paid_by_consumers_amount)
            ->setConsumer_arrears($consumer_arrears)
            ->setCash_to_provider_payment($cash_to_provider_payment)
            ->setPaid_to_supplier_amount($paid_to_supplier_amount)
            ->setArrear_to_supplier_amount($arrear_to_supplier_amount)
            ->setTotal_penalties($total_penalties);
    }
    /**
     * Get unit_of_measurement value
     * @return string|null
     */
    public function getUnit_of_measurement()
    {
        return $this->unit_of_measurement;
    }
    /**
     * Set unit_of_measurement value
     * @uses \EnumType\UnitOfMeasureEnum::valueIsValid()
     * @uses \EnumType\UnitOfMeasureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit_of_measurement
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setUnit_of_measurement($unit_of_measurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasureEnum::valueIsValid($unit_of_measurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UnitOfMeasureEnum', is_array($unit_of_measurement) ? implode(', ', $unit_of_measurement) : var_export($unit_of_measurement, true), implode(', ', \EnumType\UnitOfMeasureEnum::getValidValues())), __LINE__);
        }
        $this->unit_of_measurement = $unit_of_measurement;
        return $this;
    }
    /**
     * Get total_volume value
     * @return float|null
     */
    public function getTotal_volume()
    {
        return $this->total_volume;
    }
    /**
     * Set total_volume value
     * @param float $total_volume
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setTotal_volume($total_volume = null)
    {
        // validation for constraint: float
        if (!is_null($total_volume) && !(is_float($total_volume) || is_numeric($total_volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_volume, true), gettype($total_volume)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($total_volume) && mb_strlen(mb_substr($total_volume, mb_strpos($total_volume, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($total_volume, true), mb_strlen(mb_substr($total_volume, mb_strpos($total_volume, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($total_volume) && mb_strlen(preg_replace('/(\D)/', '', $total_volume)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($total_volume, true), mb_strlen(preg_replace('/(\D)/', '', $total_volume))), __LINE__);
        }
        $this->total_volume = $total_volume;
        return $this;
    }
    /**
     * Get accrued_consumer value
     * @return float|null
     */
    public function getAccrued_consumer()
    {
        return $this->accrued_consumer;
    }
    /**
     * Set accrued_consumer value
     * @param float $accrued_consumer
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setAccrued_consumer($accrued_consumer = null)
    {
        // validation for constraint: float
        if (!is_null($accrued_consumer) && !(is_float($accrued_consumer) || is_numeric($accrued_consumer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($accrued_consumer, true), gettype($accrued_consumer)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($accrued_consumer) && mb_strlen(mb_substr($accrued_consumer, mb_strpos($accrued_consumer, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($accrued_consumer, true), mb_strlen(mb_substr($accrued_consumer, mb_strpos($accrued_consumer, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($accrued_consumer) && mb_strlen(preg_replace('/(\D)/', '', $accrued_consumer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($accrued_consumer, true), mb_strlen(preg_replace('/(\D)/', '', $accrued_consumer))), __LINE__);
        }
        $this->accrued_consumer = $accrued_consumer;
        return $this;
    }
    /**
     * Get paid_by_consumers_amount value
     * @return float|null
     */
    public function getPaid_by_consumers_amount()
    {
        return $this->paid_by_consumers_amount;
    }
    /**
     * Set paid_by_consumers_amount value
     * @param float $paid_by_consumers_amount
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setPaid_by_consumers_amount($paid_by_consumers_amount = null)
    {
        // validation for constraint: float
        if (!is_null($paid_by_consumers_amount) && !(is_float($paid_by_consumers_amount) || is_numeric($paid_by_consumers_amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paid_by_consumers_amount, true), gettype($paid_by_consumers_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($paid_by_consumers_amount) && mb_strlen(mb_substr($paid_by_consumers_amount, mb_strpos($paid_by_consumers_amount, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($paid_by_consumers_amount, true), mb_strlen(mb_substr($paid_by_consumers_amount, mb_strpos($paid_by_consumers_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($paid_by_consumers_amount) && mb_strlen(preg_replace('/(\D)/', '', $paid_by_consumers_amount)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($paid_by_consumers_amount, true), mb_strlen(preg_replace('/(\D)/', '', $paid_by_consumers_amount))), __LINE__);
        }
        $this->paid_by_consumers_amount = $paid_by_consumers_amount;
        return $this;
    }
    /**
     * Get consumer_arrears value
     * @return float|null
     */
    public function getConsumer_arrears()
    {
        return $this->consumer_arrears;
    }
    /**
     * Set consumer_arrears value
     * @param float $consumer_arrears
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setConsumer_arrears($consumer_arrears = null)
    {
        // validation for constraint: float
        if (!is_null($consumer_arrears) && !(is_float($consumer_arrears) || is_numeric($consumer_arrears))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consumer_arrears, true), gettype($consumer_arrears)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($consumer_arrears) && mb_strlen(mb_substr($consumer_arrears, mb_strpos($consumer_arrears, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($consumer_arrears, true), mb_strlen(mb_substr($consumer_arrears, mb_strpos($consumer_arrears, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($consumer_arrears) && mb_strlen(preg_replace('/(\D)/', '', $consumer_arrears)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($consumer_arrears, true), mb_strlen(preg_replace('/(\D)/', '', $consumer_arrears))), __LINE__);
        }
        $this->consumer_arrears = $consumer_arrears;
        return $this;
    }
    /**
     * Get cash_to_provider_payment value
     * @return float|null
     */
    public function getCash_to_provider_payment()
    {
        return $this->cash_to_provider_payment;
    }
    /**
     * Set cash_to_provider_payment value
     * @param float $cash_to_provider_payment
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setCash_to_provider_payment($cash_to_provider_payment = null)
    {
        // validation for constraint: float
        if (!is_null($cash_to_provider_payment) && !(is_float($cash_to_provider_payment) || is_numeric($cash_to_provider_payment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_to_provider_payment, true), gettype($cash_to_provider_payment)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($cash_to_provider_payment) && mb_strlen(mb_substr($cash_to_provider_payment, mb_strpos($cash_to_provider_payment, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($cash_to_provider_payment, true), mb_strlen(mb_substr($cash_to_provider_payment, mb_strpos($cash_to_provider_payment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($cash_to_provider_payment) && mb_strlen(preg_replace('/(\D)/', '', $cash_to_provider_payment)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($cash_to_provider_payment, true), mb_strlen(preg_replace('/(\D)/', '', $cash_to_provider_payment))), __LINE__);
        }
        $this->cash_to_provider_payment = $cash_to_provider_payment;
        return $this;
    }
    /**
     * Get paid_to_supplier_amount value
     * @return float|null
     */
    public function getPaid_to_supplier_amount()
    {
        return $this->paid_to_supplier_amount;
    }
    /**
     * Set paid_to_supplier_amount value
     * @param float $paid_to_supplier_amount
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setPaid_to_supplier_amount($paid_to_supplier_amount = null)
    {
        // validation for constraint: float
        if (!is_null($paid_to_supplier_amount) && !(is_float($paid_to_supplier_amount) || is_numeric($paid_to_supplier_amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paid_to_supplier_amount, true), gettype($paid_to_supplier_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($paid_to_supplier_amount) && mb_strlen(mb_substr($paid_to_supplier_amount, mb_strpos($paid_to_supplier_amount, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($paid_to_supplier_amount, true), mb_strlen(mb_substr($paid_to_supplier_amount, mb_strpos($paid_to_supplier_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($paid_to_supplier_amount) && mb_strlen(preg_replace('/(\D)/', '', $paid_to_supplier_amount)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($paid_to_supplier_amount, true), mb_strlen(preg_replace('/(\D)/', '', $paid_to_supplier_amount))), __LINE__);
        }
        $this->paid_to_supplier_amount = $paid_to_supplier_amount;
        return $this;
    }
    /**
     * Get arrear_to_supplier_amount value
     * @return float|null
     */
    public function getArrear_to_supplier_amount()
    {
        return $this->arrear_to_supplier_amount;
    }
    /**
     * Set arrear_to_supplier_amount value
     * @param float $arrear_to_supplier_amount
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setArrear_to_supplier_amount($arrear_to_supplier_amount = null)
    {
        // validation for constraint: float
        if (!is_null($arrear_to_supplier_amount) && !(is_float($arrear_to_supplier_amount) || is_numeric($arrear_to_supplier_amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($arrear_to_supplier_amount, true), gettype($arrear_to_supplier_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($arrear_to_supplier_amount) && mb_strlen(mb_substr($arrear_to_supplier_amount, mb_strpos($arrear_to_supplier_amount, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($arrear_to_supplier_amount, true), mb_strlen(mb_substr($arrear_to_supplier_amount, mb_strpos($arrear_to_supplier_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($arrear_to_supplier_amount) && mb_strlen(preg_replace('/(\D)/', '', $arrear_to_supplier_amount)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($arrear_to_supplier_amount, true), mb_strlen(preg_replace('/(\D)/', '', $arrear_to_supplier_amount))), __LINE__);
        }
        $this->arrear_to_supplier_amount = $arrear_to_supplier_amount;
        return $this;
    }
    /**
     * Get total_penalties value
     * @return float|null
     */
    public function getTotal_penalties()
    {
        return $this->total_penalties;
    }
    /**
     * Set total_penalties value
     * @param float $total_penalties
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setTotal_penalties($total_penalties = null)
    {
        // validation for constraint: float
        if (!is_null($total_penalties) && !(is_float($total_penalties) || is_numeric($total_penalties))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_penalties, true), gettype($total_penalties)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($total_penalties) && mb_strlen(mb_substr($total_penalties, mb_strpos($total_penalties, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($total_penalties, true), mb_strlen(mb_substr($total_penalties, mb_strpos($total_penalties, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($total_penalties) && mb_strlen(preg_replace('/(\D)/', '', $total_penalties)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($total_penalties, true), mb_strlen(preg_replace('/(\D)/', '', $total_penalties))), __LINE__);
        }
        $this->total_penalties = $total_penalties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
