<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseAlarmFailure StructType
 * @subpackage Structs
 */
class HouseAlarmFailure extends AbstractStructBase
{
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reason;
    /**
     * The document_name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $document_name;
    /**
     * The document_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $document_date;
    /**
     * The document_number
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $document_number;
    /**
     * The files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $files;
    /**
     * Constructor method for HouseAlarmFailure
     * @uses HouseAlarmFailure::setReason()
     * @uses HouseAlarmFailure::setDocument_name()
     * @uses HouseAlarmFailure::setDocument_date()
     * @uses HouseAlarmFailure::setDocument_number()
     * @uses HouseAlarmFailure::setFiles()
     * @param string $reason
     * @param string $document_name
     * @param string $document_date
     * @param string $document_number
     * @param \ArrayType\ArrayOfInt $files
     */
    public function __construct($reason = null, $document_name = null, $document_date = null, $document_number = null, \ArrayType\ArrayOfInt $files = null)
    {
        $this
            ->setReason($reason)
            ->setDocument_name($document_name)
            ->setDocument_date($document_date)
            ->setDocument_number($document_number)
            ->setFiles($files);
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @uses \EnumType\AlarmFailureReasonEnum::valueIsValid()
     * @uses \EnumType\AlarmFailureReasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reason
     * @return \StructType\HouseAlarmFailure
     */
    public function setReason($reason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AlarmFailureReasonEnum::valueIsValid($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AlarmFailureReasonEnum', is_array($reason) ? implode(', ', $reason) : var_export($reason, true), implode(', ', \EnumType\AlarmFailureReasonEnum::getValidValues())), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get document_name value
     * @return string|null
     */
    public function getDocument_name()
    {
        return $this->document_name;
    }
    /**
     * Set document_name value
     * @param string $document_name
     * @return \StructType\HouseAlarmFailure
     */
    public function setDocument_name($document_name = null)
    {
        // validation for constraint: string
        if (!is_null($document_name) && !is_string($document_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_name, true), gettype($document_name)), __LINE__);
        }
        $this->document_name = $document_name;
        return $this;
    }
    /**
     * Get document_date value
     * @return string|null
     */
    public function getDocument_date()
    {
        return $this->document_date;
    }
    /**
     * Set document_date value
     * @param string $document_date
     * @return \StructType\HouseAlarmFailure
     */
    public function setDocument_date($document_date = null)
    {
        // validation for constraint: string
        if (!is_null($document_date) && !is_string($document_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_date, true), gettype($document_date)), __LINE__);
        }
        $this->document_date = $document_date;
        return $this;
    }
    /**
     * Get document_number value
     * @return string|null
     */
    public function getDocument_number()
    {
        return $this->document_number;
    }
    /**
     * Set document_number value
     * @param string $document_number
     * @return \StructType\HouseAlarmFailure
     */
    public function setDocument_number($document_number = null)
    {
        // validation for constraint: string
        if (!is_null($document_number) && !is_string($document_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_number, true), gettype($document_number)), __LINE__);
        }
        $this->document_number = $document_number;
        return $this;
    }
    /**
     * Get files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getFiles()
    {
        return $this->files;
    }
    /**
     * Set files value
     * @param \ArrayType\ArrayOfInt $files
     * @return \StructType\HouseAlarmFailure
     */
    public function setFiles(\ArrayType\ArrayOfInt $files = null)
    {
        $this->files = $files;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseAlarmFailure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
