<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FileInfo StructType
 * @subpackage Structs
 */
class FileInfo extends AbstractStructBase
{
    /**
     * The file_id
     * @var int
     */
    public $file_id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The extension
     * @var string
     */
    public $extension;
    /**
     * The size
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $size;
    /**
     * The create_date
     * @var string
     */
    public $create_date;
    /**
     * Constructor method for FileInfo
     * @uses FileInfo::setFile_id()
     * @uses FileInfo::setName()
     * @uses FileInfo::setExtension()
     * @uses FileInfo::setSize()
     * @uses FileInfo::setCreate_date()
     * @param int $file_id
     * @param string $name
     * @param string $extension
     * @param int $size
     * @param string $create_date
     */
    public function __construct($file_id = null, $name = null, $extension = null, $size = null, $create_date = null)
    {
        $this
            ->setFile_id($file_id)
            ->setName($name)
            ->setExtension($extension)
            ->setSize($size)
            ->setCreate_date($create_date);
    }
    /**
     * Get file_id value
     * @return int|null
     */
    public function getFile_id()
    {
        return $this->file_id;
    }
    /**
     * Set file_id value
     * @param int $file_id
     * @return \StructType\FileInfo
     */
    public function setFile_id($file_id = null)
    {
        // validation for constraint: int
        if (!is_null($file_id) && !(is_int($file_id) || ctype_digit($file_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($file_id, true), gettype($file_id)), __LINE__);
        }
        $this->file_id = $file_id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\FileInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return \StructType\FileInfo
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get size value
     * @return int|null
     */
    public function getSize()
    {
        return $this->size;
    }
    /**
     * Set size value
     * @param int $size
     * @return \StructType\FileInfo
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->size = $size;
        return $this;
    }
    /**
     * Get create_date value
     * @return string|null
     */
    public function getCreate_date()
    {
        return $this->create_date;
    }
    /**
     * Set create_date value
     * @param string $create_date
     * @return \StructType\FileInfo
     */
    public function setCreate_date($create_date = null)
    {
        // validation for constraint: string
        if (!is_null($create_date) && !is_string($create_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($create_date, true), gettype($create_date)), __LINE__);
        }
        $this->create_date = $create_date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FileInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
