<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Disturbance StructType
 * @subpackage Structs
 */
class Disturbance extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The date_of_responsibility
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date_of_responsibility;
    /**
     * The person_type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $person_type;
    /**
     * The person_fio
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $person_fio;
    /**
     * The person_position
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $person_position;
    /**
     * The subject_of_disturbance
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $subject_of_disturbance;
    /**
     * The supervisory_authority_name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $supervisory_authority_name;
    /**
     * The number_of_disturbance
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $number_of_disturbance;
    /**
     * The amount_of_penalty
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $amount_of_penalty;
    /**
     * The document_name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $document_name;
    /**
     * The document_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $document_date;
    /**
     * The document_number
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $document_number;
    /**
     * The document_file_id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $document_file_id;
    /**
     * The measures_to_eliminate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $measures_to_eliminate;
    /**
     * Constructor method for Disturbance
     * @uses Disturbance::setId()
     * @uses Disturbance::setDate_of_responsibility()
     * @uses Disturbance::setPerson_type()
     * @uses Disturbance::setPerson_fio()
     * @uses Disturbance::setPerson_position()
     * @uses Disturbance::setSubject_of_disturbance()
     * @uses Disturbance::setSupervisory_authority_name()
     * @uses Disturbance::setNumber_of_disturbance()
     * @uses Disturbance::setAmount_of_penalty()
     * @uses Disturbance::setDocument_name()
     * @uses Disturbance::setDocument_date()
     * @uses Disturbance::setDocument_number()
     * @uses Disturbance::setDocument_file_id()
     * @uses Disturbance::setMeasures_to_eliminate()
     * @param int $id
     * @param string $date_of_responsibility
     * @param string $person_type
     * @param string $person_fio
     * @param string $person_position
     * @param string $subject_of_disturbance
     * @param string $supervisory_authority_name
     * @param int $number_of_disturbance
     * @param float $amount_of_penalty
     * @param string $document_name
     * @param string $document_date
     * @param string $document_number
     * @param int $document_file_id
     * @param string $measures_to_eliminate
     */
    public function __construct($id = null, $date_of_responsibility = null, $person_type = null, $person_fio = null, $person_position = null, $subject_of_disturbance = null, $supervisory_authority_name = null, $number_of_disturbance = null, $amount_of_penalty = null, $document_name = null, $document_date = null, $document_number = null, $document_file_id = null, $measures_to_eliminate = null)
    {
        $this
            ->setId($id)
            ->setDate_of_responsibility($date_of_responsibility)
            ->setPerson_type($person_type)
            ->setPerson_fio($person_fio)
            ->setPerson_position($person_position)
            ->setSubject_of_disturbance($subject_of_disturbance)
            ->setSupervisory_authority_name($supervisory_authority_name)
            ->setNumber_of_disturbance($number_of_disturbance)
            ->setAmount_of_penalty($amount_of_penalty)
            ->setDocument_name($document_name)
            ->setDocument_date($document_date)
            ->setDocument_number($document_number)
            ->setDocument_file_id($document_file_id)
            ->setMeasures_to_eliminate($measures_to_eliminate);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Disturbance
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get date_of_responsibility value
     * @return string|null
     */
    public function getDate_of_responsibility()
    {
        return $this->date_of_responsibility;
    }
    /**
     * Set date_of_responsibility value
     * @param string $date_of_responsibility
     * @return \StructType\Disturbance
     */
    public function setDate_of_responsibility($date_of_responsibility = null)
    {
        // validation for constraint: string
        if (!is_null($date_of_responsibility) && !is_string($date_of_responsibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_of_responsibility, true), gettype($date_of_responsibility)), __LINE__);
        }
        $this->date_of_responsibility = $date_of_responsibility;
        return $this;
    }
    /**
     * Get person_type value
     * @return string|null
     */
    public function getPerson_type()
    {
        return $this->person_type;
    }
    /**
     * Set person_type value
     * @uses \EnumType\PersonType::valueIsValid()
     * @uses \EnumType\PersonType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $person_type
     * @return \StructType\Disturbance
     */
    public function setPerson_type($person_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersonType::valueIsValid($person_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PersonType', is_array($person_type) ? implode(', ', $person_type) : var_export($person_type, true), implode(', ', \EnumType\PersonType::getValidValues())), __LINE__);
        }
        $this->person_type = $person_type;
        return $this;
    }
    /**
     * Get person_fio value
     * @return string|null
     */
    public function getPerson_fio()
    {
        return $this->person_fio;
    }
    /**
     * Set person_fio value
     * @param string $person_fio
     * @return \StructType\Disturbance
     */
    public function setPerson_fio($person_fio = null)
    {
        // validation for constraint: string
        if (!is_null($person_fio) && !is_string($person_fio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person_fio, true), gettype($person_fio)), __LINE__);
        }
        $this->person_fio = $person_fio;
        return $this;
    }
    /**
     * Get person_position value
     * @return string|null
     */
    public function getPerson_position()
    {
        return $this->person_position;
    }
    /**
     * Set person_position value
     * @param string $person_position
     * @return \StructType\Disturbance
     */
    public function setPerson_position($person_position = null)
    {
        // validation for constraint: string
        if (!is_null($person_position) && !is_string($person_position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person_position, true), gettype($person_position)), __LINE__);
        }
        $this->person_position = $person_position;
        return $this;
    }
    /**
     * Get subject_of_disturbance value
     * @return string|null
     */
    public function getSubject_of_disturbance()
    {
        return $this->subject_of_disturbance;
    }
    /**
     * Set subject_of_disturbance value
     * @param string $subject_of_disturbance
     * @return \StructType\Disturbance
     */
    public function setSubject_of_disturbance($subject_of_disturbance = null)
    {
        // validation for constraint: string
        if (!is_null($subject_of_disturbance) && !is_string($subject_of_disturbance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject_of_disturbance, true), gettype($subject_of_disturbance)), __LINE__);
        }
        $this->subject_of_disturbance = $subject_of_disturbance;
        return $this;
    }
    /**
     * Get supervisory_authority_name value
     * @return string|null
     */
    public function getSupervisory_authority_name()
    {
        return $this->supervisory_authority_name;
    }
    /**
     * Set supervisory_authority_name value
     * @param string $supervisory_authority_name
     * @return \StructType\Disturbance
     */
    public function setSupervisory_authority_name($supervisory_authority_name = null)
    {
        // validation for constraint: string
        if (!is_null($supervisory_authority_name) && !is_string($supervisory_authority_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supervisory_authority_name, true), gettype($supervisory_authority_name)), __LINE__);
        }
        $this->supervisory_authority_name = $supervisory_authority_name;
        return $this;
    }
    /**
     * Get number_of_disturbance value
     * @return int|null
     */
    public function getNumber_of_disturbance()
    {
        return $this->number_of_disturbance;
    }
    /**
     * Set number_of_disturbance value
     * @param int $number_of_disturbance
     * @return \StructType\Disturbance
     */
    public function setNumber_of_disturbance($number_of_disturbance = null)
    {
        // validation for constraint: int
        if (!is_null($number_of_disturbance) && !(is_int($number_of_disturbance) || ctype_digit($number_of_disturbance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number_of_disturbance, true), gettype($number_of_disturbance)), __LINE__);
        }
        $this->number_of_disturbance = $number_of_disturbance;
        return $this;
    }
    /**
     * Get amount_of_penalty value
     * @return float|null
     */
    public function getAmount_of_penalty()
    {
        return $this->amount_of_penalty;
    }
    /**
     * Set amount_of_penalty value
     * @param float $amount_of_penalty
     * @return \StructType\Disturbance
     */
    public function setAmount_of_penalty($amount_of_penalty = null)
    {
        // validation for constraint: float
        if (!is_null($amount_of_penalty) && !(is_float($amount_of_penalty) || is_numeric($amount_of_penalty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount_of_penalty, true), gettype($amount_of_penalty)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($amount_of_penalty) && mb_strlen(mb_substr($amount_of_penalty, mb_strpos($amount_of_penalty, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($amount_of_penalty, true), mb_strlen(mb_substr($amount_of_penalty, mb_strpos($amount_of_penalty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($amount_of_penalty) && mb_strlen(preg_replace('/(\D)/', '', $amount_of_penalty)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($amount_of_penalty, true), mb_strlen(preg_replace('/(\D)/', '', $amount_of_penalty))), __LINE__);
        }
        $this->amount_of_penalty = $amount_of_penalty;
        return $this;
    }
    /**
     * Get document_name value
     * @return string|null
     */
    public function getDocument_name()
    {
        return $this->document_name;
    }
    /**
     * Set document_name value
     * @param string $document_name
     * @return \StructType\Disturbance
     */
    public function setDocument_name($document_name = null)
    {
        // validation for constraint: string
        if (!is_null($document_name) && !is_string($document_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_name, true), gettype($document_name)), __LINE__);
        }
        $this->document_name = $document_name;
        return $this;
    }
    /**
     * Get document_date value
     * @return string|null
     */
    public function getDocument_date()
    {
        return $this->document_date;
    }
    /**
     * Set document_date value
     * @param string $document_date
     * @return \StructType\Disturbance
     */
    public function setDocument_date($document_date = null)
    {
        // validation for constraint: string
        if (!is_null($document_date) && !is_string($document_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_date, true), gettype($document_date)), __LINE__);
        }
        $this->document_date = $document_date;
        return $this;
    }
    /**
     * Get document_number value
     * @return string|null
     */
    public function getDocument_number()
    {
        return $this->document_number;
    }
    /**
     * Set document_number value
     * @param string $document_number
     * @return \StructType\Disturbance
     */
    public function setDocument_number($document_number = null)
    {
        // validation for constraint: string
        if (!is_null($document_number) && !is_string($document_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_number, true), gettype($document_number)), __LINE__);
        }
        $this->document_number = $document_number;
        return $this;
    }
    /**
     * Get document_file_id value
     * @return int|null
     */
    public function getDocument_file_id()
    {
        return $this->document_file_id;
    }
    /**
     * Set document_file_id value
     * @param int $document_file_id
     * @return \StructType\Disturbance
     */
    public function setDocument_file_id($document_file_id = null)
    {
        // validation for constraint: int
        if (!is_null($document_file_id) && !(is_int($document_file_id) || ctype_digit($document_file_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($document_file_id, true), gettype($document_file_id)), __LINE__);
        }
        $this->document_file_id = $document_file_id;
        return $this;
    }
    /**
     * Get measures_to_eliminate value
     * @return string|null
     */
    public function getMeasures_to_eliminate()
    {
        return $this->measures_to_eliminate;
    }
    /**
     * Set measures_to_eliminate value
     * @param string $measures_to_eliminate
     * @return \StructType\Disturbance
     */
    public function setMeasures_to_eliminate($measures_to_eliminate = null)
    {
        // validation for constraint: string
        if (!is_null($measures_to_eliminate) && !is_string($measures_to_eliminate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measures_to_eliminate, true), gettype($measures_to_eliminate)), __LINE__);
        }
        $this->measures_to_eliminate = $measures_to_eliminate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Disturbance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
