<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtForMng StructType
 * @subpackage Structs
 */
class DebtForMng extends AbstractStructBase
{
    /**
     * The debt_for_mng
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $debt_for_mng;
    /**
     * The by_houses_25
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $by_houses_25;
    /**
     * The by_houses_26_50
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $by_houses_26_50;
    /**
     * The by_houses_51_75
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $by_houses_51_75;
    /**
     * The by_houses_76
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $by_houses_76;
    /**
     * The by_houses_alarm
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $by_houses_alarm;
    /**
     * Constructor method for DebtForMng
     * @uses DebtForMng::setDebt_for_mng()
     * @uses DebtForMng::setBy_houses_25()
     * @uses DebtForMng::setBy_houses_26_50()
     * @uses DebtForMng::setBy_houses_51_75()
     * @uses DebtForMng::setBy_houses_76()
     * @uses DebtForMng::setBy_houses_alarm()
     * @param float $debt_for_mng
     * @param float $by_houses_25
     * @param float $by_houses_26_50
     * @param float $by_houses_51_75
     * @param float $by_houses_76
     * @param float $by_houses_alarm
     */
    public function __construct($debt_for_mng = null, $by_houses_25 = null, $by_houses_26_50 = null, $by_houses_51_75 = null, $by_houses_76 = null, $by_houses_alarm = null)
    {
        $this
            ->setDebt_for_mng($debt_for_mng)
            ->setBy_houses_25($by_houses_25)
            ->setBy_houses_26_50($by_houses_26_50)
            ->setBy_houses_51_75($by_houses_51_75)
            ->setBy_houses_76($by_houses_76)
            ->setBy_houses_alarm($by_houses_alarm);
    }
    /**
     * Get debt_for_mng value
     * @return float|null
     */
    public function getDebt_for_mng()
    {
        return $this->debt_for_mng;
    }
    /**
     * Set debt_for_mng value
     * @param float $debt_for_mng
     * @return \StructType\DebtForMng
     */
    public function setDebt_for_mng($debt_for_mng = null)
    {
        // validation for constraint: float
        if (!is_null($debt_for_mng) && !(is_float($debt_for_mng) || is_numeric($debt_for_mng))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debt_for_mng, true), gettype($debt_for_mng)), __LINE__);
        }
        $this->debt_for_mng = $debt_for_mng;
        return $this;
    }
    /**
     * Get by_houses value
     * @return by_houses
     */
    public function getBy_houses_25()
    {
        return $this->by_houses_25;
    }
    /**
     * Set by_houses value
     * @param by_houses $by_houses
     * @return \StructType\DebtForMng
     */
    public function setBy_houses_25($by_houses_25 = null)
    {
        // validation for constraint: float
        if (!is_null($by_houses_25) && !(is_float($by_houses_25) || is_numeric($by_houses_25))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($by_houses_25, true), gettype($by_houses_25)), __LINE__);
        }
        $this->by_houses_25 = $by_houses_25;
        return $this;
    }
    /**
     * Get by_houses value
     * @return by_houses
     */
    public function getBy_houses_26_50()
    {
        return $this->by_houses_26_50;
    }
    /**
     * Set by_houses value
     * @param by_houses $by_houses
     * @return \StructType\DebtForMng
     */
    public function setBy_houses_26_50($by_houses_26_50 = null)
    {
        // validation for constraint: float
        if (!is_null($by_houses_26_50) && !(is_float($by_houses_26_50) || is_numeric($by_houses_26_50))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($by_houses_26_50, true), gettype($by_houses_26_50)), __LINE__);
        }
        $this->by_houses_26_50 = $by_houses_26_50;
        return $this;
    }
    /**
     * Get by_houses value
     * @return by_houses
     */
    public function getBy_houses_51_75()
    {
        return $this->by_houses_51_75;
    }
    /**
     * Set by_houses value
     * @param by_houses $by_houses
     * @return \StructType\DebtForMng
     */
    public function setBy_houses_51_75($by_houses_51_75 = null)
    {
        // validation for constraint: float
        if (!is_null($by_houses_51_75) && !(is_float($by_houses_51_75) || is_numeric($by_houses_51_75))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($by_houses_51_75, true), gettype($by_houses_51_75)), __LINE__);
        }
        $this->by_houses_51_75 = $by_houses_51_75;
        return $this;
    }
    /**
     * Get by_houses value
     * @return by_houses
     */
    public function getBy_houses_76()
    {
        return $this->by_houses_76;
    }
    /**
     * Set by_houses value
     * @param by_houses $by_houses
     * @return \StructType\DebtForMng
     */
    public function setBy_houses_76($by_houses_76 = null)
    {
        // validation for constraint: float
        if (!is_null($by_houses_76) && !(is_float($by_houses_76) || is_numeric($by_houses_76))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($by_houses_76, true), gettype($by_houses_76)), __LINE__);
        }
        $this->by_houses_76 = $by_houses_76;
        return $this;
    }
    /**
     * Get by_houses_alarm value
     * @return float|null
     */
    public function getBy_houses_alarm()
    {
        return $this->by_houses_alarm;
    }
    /**
     * Set by_houses_alarm value
     * @param float $by_houses_alarm
     * @return \StructType\DebtForMng
     */
    public function setBy_houses_alarm($by_houses_alarm = null)
    {
        // validation for constraint: float
        if (!is_null($by_houses_alarm) && !(is_float($by_houses_alarm) || is_numeric($by_houses_alarm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($by_houses_alarm, true), gettype($by_houses_alarm)), __LINE__);
        }
        $this->by_houses_alarm = $by_houses_alarm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DebtForMng
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
