<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyProfileData StructType
 * @subpackage Structs
 */
class CompanyProfileData extends AbstractStructBase
{
    /**
     * The work_time
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $work_time;
    /**
     * The additional_info
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $additional_info;
    /**
     * The date_assignment_ogrn
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date_assignment_ogrn;
    /**
     * The name_authority_assigning_ogrn
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $name_authority_assigning_ogrn;
    /**
     * The position
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $position;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $notes;
    /**
     * The participation_in_associations
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $participation_in_associations;
    /**
     * The srf_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $srf_count;
    /**
     * The mo_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $mo_count;
    /**
     * The offices_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $offices_count;
    /**
     * The staff_regular_total
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $staff_regular_total;
    /**
     * The staff_regular_administrative
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $staff_regular_administrative;
    /**
     * The staff_regular_engineers
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $staff_regular_engineers;
    /**
     * The staff_regular_labor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $staff_regular_labor;
    /**
     * The count_dismissed
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\CountDismissed
     */
    public $count_dismissed;
    /**
     * The accidents_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $accidents_count;
    /**
     * The prosecute_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $prosecute_count;
    /**
     * The prosecute_copies_of_documents
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $prosecute_copies_of_documents;
    /**
     * The prosecute_documents_copies_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $prosecute_documents_copies_files;
    /**
     * The tsg_management_members
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tsg_management_members;
    /**
     * The audit_commision_members
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $audit_commision_members;
    /**
     * The additional_info_freeform
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $additional_info_freeform;
    /**
     * The residents_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $residents_count;
    /**
     * The count_houses_under_mng_report_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\CountHousesUnderMngReportDate
     */
    public $count_houses_under_mng_report_date;
    /**
     * The count_houses_under_mng_start_period
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\CountHousesUnderMngStartPeriod
     */
    public $count_houses_under_mng_start_period;
    /**
     * The sum_sq_houses_under_mng_report_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\SumSqHousesUnderMngReportDate
     */
    public $sum_sq_houses_under_mng_report_date;
    /**
     * The sum_sq_houses_under_mng_start_period
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\SumSqHousesUnderMngStartPeriod
     */
    public $sum_sq_houses_under_mng_start_period;
    /**
     * The avg_time_service_mkd
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\AvgTimeServiceMkd
     */
    public $avg_time_service_mkd;
    /**
     * The income_of_mng
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\IncomeOfMng
     */
    public $income_of_mng;
    /**
     * The income_of_usage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\IncomeOfUsage
     */
    public $income_of_usage;
    /**
     * The income_of_ku
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\IncomeOfKu
     */
    public $income_of_ku;
    /**
     * The spending_of_mng
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\SpendingOfMng
     */
    public $spending_of_mng;
    /**
     * The claims_by_contracts_mng
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ClaimsByContractsMng
     */
    public $claims_by_contracts_mng;
    /**
     * The claims_by_rso
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ClaimsByRso
     */
    public $claims_by_rso;
    /**
     * The net_assets
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $net_assets;
    /**
     * The annual_financial_statements
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $annual_financial_statements;
    /**
     * The annual_financial_statements_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $annual_financial_statements_files;
    /**
     * The revenues_expenditures_estimates
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $revenues_expenditures_estimates;
    /**
     * The revenues_expenditures_estimates_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $revenues_expenditures_estimates_files;
    /**
     * The performance_report
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $performance_report;
    /**
     * The performance_report_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $performance_report_files;
    /**
     * The members_meetings_minutes
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $members_meetings_minutes;
    /**
     * The members_meetings_minutes_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $members_meetings_minutes_files;
    /**
     * The audit_commision_report
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $audit_commision_report;
    /**
     * The audit_commision_report_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $audit_commision_report_files;
    /**
     * The audit_report
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $audit_report;
    /**
     * The audit_report_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $audit_report_files;
    /**
     * The debt_for_mng
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\DebtForMng
     */
    public $debt_for_mng;
    /**
     * The debt_owners
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $debt_owners;
    /**
     * The debt_owners_for_ku
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\DebtOwnersForKu
     */
    public $debt_owners_for_ku;
    /**
     * The debt_uo_for_ku
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\DebtUoForKu
     */
    public $debt_uo_for_ku;
    /**
     * The debt_owners_communal
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $debt_owners_communal;
    /**
     * The charged_for_mng
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ChargedForMng
     */
    public $charged_for_mng;
    /**
     * The charged_for_resources
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ChargedForResources
     */
    public $charged_for_resources;
    /**
     * The spending_repair
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\SpendingRepair
     */
    public $spending_repair;
    /**
     * The spending_beauty
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\SpendingBeauty
     */
    public $spending_beauty;
    /**
     * The spending_repair_invests
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\SpendingRepairInvests
     */
    public $spending_repair_invests;
    /**
     * The payed_ku_by_statements
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\PayedKuByStatements
     */
    public $payed_ku_by_statements;
    /**
     * The payed_ku_by_needs
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\PayedKuByNeeds
     */
    public $payed_ku_by_needs;
    /**
     * The management_contract
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $management_contract;
    /**
     * The management_contract_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $management_contract_files;
    /**
     * The services_cost
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $services_cost;
    /**
     * The services_cost_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $services_cost_files;
    /**
     * The tariffs
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tariffs;
    /**
     * The tariffs_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $tariffs_files;
    /**
     * The additional_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $additional_files;
    /**
     * The okopf
     * @var string
     */
    public $okopf;
    /**
     * The firstname
     * @var string
     */
    public $firstname;
    /**
     * The surname
     * @var string
     */
    public $surname;
    /**
     * The middlename
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $middlename;
    /**
     * The ogrn
     * @var string
     */
    public $ogrn;
    /**
     * The legal_address
     * @var \StructType\FiasAddress
     */
    public $legal_address;
    /**
     * The actual_address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\FiasAddress
     */
    public $actual_address;
    /**
     * The post_address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\FiasAddress
     */
    public $post_address;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $phone;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The site
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $site;
    /**
     * The proportion_sf
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $proportion_sf;
    /**
     * The proportion_mo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $proportion_mo;
    /**
     * Constructor method for CompanyProfileData
     * @uses CompanyProfileData::setWork_time()
     * @uses CompanyProfileData::setAdditional_info()
     * @uses CompanyProfileData::setDate_assignment_ogrn()
     * @uses CompanyProfileData::setName_authority_assigning_ogrn()
     * @uses CompanyProfileData::setPosition()
     * @uses CompanyProfileData::setNotes()
     * @uses CompanyProfileData::setParticipation_in_associations()
     * @uses CompanyProfileData::setSrf_count()
     * @uses CompanyProfileData::setMo_count()
     * @uses CompanyProfileData::setOffices_count()
     * @uses CompanyProfileData::setStaff_regular_total()
     * @uses CompanyProfileData::setStaff_regular_administrative()
     * @uses CompanyProfileData::setStaff_regular_engineers()
     * @uses CompanyProfileData::setStaff_regular_labor()
     * @uses CompanyProfileData::setCount_dismissed()
     * @uses CompanyProfileData::setAccidents_count()
     * @uses CompanyProfileData::setProsecute_count()
     * @uses CompanyProfileData::setProsecute_copies_of_documents()
     * @uses CompanyProfileData::setProsecute_documents_copies_files()
     * @uses CompanyProfileData::setTsg_management_members()
     * @uses CompanyProfileData::setAudit_commision_members()
     * @uses CompanyProfileData::setAdditional_info_freeform()
     * @uses CompanyProfileData::setResidents_count()
     * @uses CompanyProfileData::setCount_houses_under_mng_report_date()
     * @uses CompanyProfileData::setCount_houses_under_mng_start_period()
     * @uses CompanyProfileData::setSum_sq_houses_under_mng_report_date()
     * @uses CompanyProfileData::setSum_sq_houses_under_mng_start_period()
     * @uses CompanyProfileData::setAvg_time_service_mkd()
     * @uses CompanyProfileData::setIncome_of_mng()
     * @uses CompanyProfileData::setIncome_of_usage()
     * @uses CompanyProfileData::setIncome_of_ku()
     * @uses CompanyProfileData::setSpending_of_mng()
     * @uses CompanyProfileData::setClaims_by_contracts_mng()
     * @uses CompanyProfileData::setClaims_by_rso()
     * @uses CompanyProfileData::setNet_assets()
     * @uses CompanyProfileData::setAnnual_financial_statements()
     * @uses CompanyProfileData::setAnnual_financial_statements_files()
     * @uses CompanyProfileData::setRevenues_expenditures_estimates()
     * @uses CompanyProfileData::setRevenues_expenditures_estimates_files()
     * @uses CompanyProfileData::setPerformance_report()
     * @uses CompanyProfileData::setPerformance_report_files()
     * @uses CompanyProfileData::setMembers_meetings_minutes()
     * @uses CompanyProfileData::setMembers_meetings_minutes_files()
     * @uses CompanyProfileData::setAudit_commision_report()
     * @uses CompanyProfileData::setAudit_commision_report_files()
     * @uses CompanyProfileData::setAudit_report()
     * @uses CompanyProfileData::setAudit_report_files()
     * @uses CompanyProfileData::setDebt_for_mng()
     * @uses CompanyProfileData::setDebt_owners()
     * @uses CompanyProfileData::setDebt_owners_for_ku()
     * @uses CompanyProfileData::setDebt_uo_for_ku()
     * @uses CompanyProfileData::setDebt_owners_communal()
     * @uses CompanyProfileData::setCharged_for_mng()
     * @uses CompanyProfileData::setCharged_for_resources()
     * @uses CompanyProfileData::setSpending_repair()
     * @uses CompanyProfileData::setSpending_beauty()
     * @uses CompanyProfileData::setSpending_repair_invests()
     * @uses CompanyProfileData::setPayed_ku_by_statements()
     * @uses CompanyProfileData::setPayed_ku_by_needs()
     * @uses CompanyProfileData::setManagement_contract()
     * @uses CompanyProfileData::setManagement_contract_files()
     * @uses CompanyProfileData::setServices_cost()
     * @uses CompanyProfileData::setServices_cost_files()
     * @uses CompanyProfileData::setTariffs()
     * @uses CompanyProfileData::setTariffs_files()
     * @uses CompanyProfileData::setAdditional_files()
     * @uses CompanyProfileData::setOkopf()
     * @uses CompanyProfileData::setFirstname()
     * @uses CompanyProfileData::setSurname()
     * @uses CompanyProfileData::setMiddlename()
     * @uses CompanyProfileData::setOgrn()
     * @uses CompanyProfileData::setLegal_address()
     * @uses CompanyProfileData::setActual_address()
     * @uses CompanyProfileData::setPost_address()
     * @uses CompanyProfileData::setPhone()
     * @uses CompanyProfileData::setEmail()
     * @uses CompanyProfileData::setSite()
     * @uses CompanyProfileData::setProportion_sf()
     * @uses CompanyProfileData::setProportion_mo()
     * @param string $work_time
     * @param string $additional_info
     * @param string $date_assignment_ogrn
     * @param string $name_authority_assigning_ogrn
     * @param string $position
     * @param string $notes
     * @param string $participation_in_associations
     * @param int $srf_count
     * @param int $mo_count
     * @param int $offices_count
     * @param int $staff_regular_total
     * @param int $staff_regular_administrative
     * @param int $staff_regular_engineers
     * @param int $staff_regular_labor
     * @param \StructType\CountDismissed $count_dismissed
     * @param int $accidents_count
     * @param int $prosecute_count
     * @param string $prosecute_copies_of_documents
     * @param \ArrayType\ArrayOfInt $prosecute_documents_copies_files
     * @param string $tsg_management_members
     * @param string $audit_commision_members
     * @param string $additional_info_freeform
     * @param int $residents_count
     * @param \StructType\CountHousesUnderMngReportDate $count_houses_under_mng_report_date
     * @param \StructType\CountHousesUnderMngStartPeriod $count_houses_under_mng_start_period
     * @param \StructType\SumSqHousesUnderMngReportDate $sum_sq_houses_under_mng_report_date
     * @param \StructType\SumSqHousesUnderMngStartPeriod $sum_sq_houses_under_mng_start_period
     * @param \StructType\AvgTimeServiceMkd $avg_time_service_mkd
     * @param \StructType\IncomeOfMng $income_of_mng
     * @param \StructType\IncomeOfUsage $income_of_usage
     * @param \StructType\IncomeOfKu $income_of_ku
     * @param \StructType\SpendingOfMng $spending_of_mng
     * @param \StructType\ClaimsByContractsMng $claims_by_contracts_mng
     * @param \StructType\ClaimsByRso $claims_by_rso
     * @param float $net_assets
     * @param string $annual_financial_statements
     * @param \ArrayType\ArrayOfInt $annual_financial_statements_files
     * @param string $revenues_expenditures_estimates
     * @param \ArrayType\ArrayOfInt $revenues_expenditures_estimates_files
     * @param string $performance_report
     * @param \ArrayType\ArrayOfInt $performance_report_files
     * @param string $members_meetings_minutes
     * @param \ArrayType\ArrayOfInt $members_meetings_minutes_files
     * @param string $audit_commision_report
     * @param \ArrayType\ArrayOfInt $audit_commision_report_files
     * @param string $audit_report
     * @param \ArrayType\ArrayOfInt $audit_report_files
     * @param \StructType\DebtForMng $debt_for_mng
     * @param float $debt_owners
     * @param \StructType\DebtOwnersForKu $debt_owners_for_ku
     * @param \StructType\DebtUoForKu $debt_uo_for_ku
     * @param float $debt_owners_communal
     * @param \StructType\ChargedForMng $charged_for_mng
     * @param \StructType\ChargedForResources $charged_for_resources
     * @param \StructType\SpendingRepair $spending_repair
     * @param \StructType\SpendingBeauty $spending_beauty
     * @param \StructType\SpendingRepairInvests $spending_repair_invests
     * @param \StructType\PayedKuByStatements $payed_ku_by_statements
     * @param \StructType\PayedKuByNeeds $payed_ku_by_needs
     * @param string $management_contract
     * @param \ArrayType\ArrayOfInt $management_contract_files
     * @param string $services_cost
     * @param \ArrayType\ArrayOfInt $services_cost_files
     * @param string $tariffs
     * @param \ArrayType\ArrayOfInt $tariffs_files
     * @param \ArrayType\ArrayOfInt $additional_files
     * @param string $okopf
     * @param string $firstname
     * @param string $surname
     * @param string $middlename
     * @param string $ogrn
     * @param \StructType\FiasAddress $legal_address
     * @param \StructType\FiasAddress $actual_address
     * @param \StructType\FiasAddress $post_address
     * @param string $phone
     * @param string $email
     * @param string $site
     * @param float $proportion_sf
     * @param float $proportion_mo
     */
    public function __construct($work_time = null, $additional_info = null, $date_assignment_ogrn = null, $name_authority_assigning_ogrn = null, $position = null, $notes = null, $participation_in_associations = null, $srf_count = null, $mo_count = null, $offices_count = null, $staff_regular_total = null, $staff_regular_administrative = null, $staff_regular_engineers = null, $staff_regular_labor = null, \StructType\CountDismissed $count_dismissed = null, $accidents_count = null, $prosecute_count = null, $prosecute_copies_of_documents = null, \ArrayType\ArrayOfInt $prosecute_documents_copies_files = null, $tsg_management_members = null, $audit_commision_members = null, $additional_info_freeform = null, $residents_count = null, \StructType\CountHousesUnderMngReportDate $count_houses_under_mng_report_date = null, \StructType\CountHousesUnderMngStartPeriod $count_houses_under_mng_start_period = null, \StructType\SumSqHousesUnderMngReportDate $sum_sq_houses_under_mng_report_date = null, \StructType\SumSqHousesUnderMngStartPeriod $sum_sq_houses_under_mng_start_period = null, \StructType\AvgTimeServiceMkd $avg_time_service_mkd = null, \StructType\IncomeOfMng $income_of_mng = null, \StructType\IncomeOfUsage $income_of_usage = null, \StructType\IncomeOfKu $income_of_ku = null, \StructType\SpendingOfMng $spending_of_mng = null, \StructType\ClaimsByContractsMng $claims_by_contracts_mng = null, \StructType\ClaimsByRso $claims_by_rso = null, $net_assets = null, $annual_financial_statements = null, \ArrayType\ArrayOfInt $annual_financial_statements_files = null, $revenues_expenditures_estimates = null, \ArrayType\ArrayOfInt $revenues_expenditures_estimates_files = null, $performance_report = null, \ArrayType\ArrayOfInt $performance_report_files = null, $members_meetings_minutes = null, \ArrayType\ArrayOfInt $members_meetings_minutes_files = null, $audit_commision_report = null, \ArrayType\ArrayOfInt $audit_commision_report_files = null, $audit_report = null, \ArrayType\ArrayOfInt $audit_report_files = null, \StructType\DebtForMng $debt_for_mng = null, $debt_owners = null, \StructType\DebtOwnersForKu $debt_owners_for_ku = null, \StructType\DebtUoForKu $debt_uo_for_ku = null, $debt_owners_communal = null, \StructType\ChargedForMng $charged_for_mng = null, \StructType\ChargedForResources $charged_for_resources = null, \StructType\SpendingRepair $spending_repair = null, \StructType\SpendingBeauty $spending_beauty = null, \StructType\SpendingRepairInvests $spending_repair_invests = null, \StructType\PayedKuByStatements $payed_ku_by_statements = null, \StructType\PayedKuByNeeds $payed_ku_by_needs = null, $management_contract = null, \ArrayType\ArrayOfInt $management_contract_files = null, $services_cost = null, \ArrayType\ArrayOfInt $services_cost_files = null, $tariffs = null, \ArrayType\ArrayOfInt $tariffs_files = null, \ArrayType\ArrayOfInt $additional_files = null, $okopf = null, $firstname = null, $surname = null, $middlename = null, $ogrn = null, \StructType\FiasAddress $legal_address = null, \StructType\FiasAddress $actual_address = null, \StructType\FiasAddress $post_address = null, $phone = null, $email = null, $site = null, $proportion_sf = null, $proportion_mo = null)
    {
        $this
            ->setWork_time($work_time)
            ->setAdditional_info($additional_info)
            ->setDate_assignment_ogrn($date_assignment_ogrn)
            ->setName_authority_assigning_ogrn($name_authority_assigning_ogrn)
            ->setPosition($position)
            ->setNotes($notes)
            ->setParticipation_in_associations($participation_in_associations)
            ->setSrf_count($srf_count)
            ->setMo_count($mo_count)
            ->setOffices_count($offices_count)
            ->setStaff_regular_total($staff_regular_total)
            ->setStaff_regular_administrative($staff_regular_administrative)
            ->setStaff_regular_engineers($staff_regular_engineers)
            ->setStaff_regular_labor($staff_regular_labor)
            ->setCount_dismissed($count_dismissed)
            ->setAccidents_count($accidents_count)
            ->setProsecute_count($prosecute_count)
            ->setProsecute_copies_of_documents($prosecute_copies_of_documents)
            ->setProsecute_documents_copies_files($prosecute_documents_copies_files)
            ->setTsg_management_members($tsg_management_members)
            ->setAudit_commision_members($audit_commision_members)
            ->setAdditional_info_freeform($additional_info_freeform)
            ->setResidents_count($residents_count)
            ->setCount_houses_under_mng_report_date($count_houses_under_mng_report_date)
            ->setCount_houses_under_mng_start_period($count_houses_under_mng_start_period)
            ->setSum_sq_houses_under_mng_report_date($sum_sq_houses_under_mng_report_date)
            ->setSum_sq_houses_under_mng_start_period($sum_sq_houses_under_mng_start_period)
            ->setAvg_time_service_mkd($avg_time_service_mkd)
            ->setIncome_of_mng($income_of_mng)
            ->setIncome_of_usage($income_of_usage)
            ->setIncome_of_ku($income_of_ku)
            ->setSpending_of_mng($spending_of_mng)
            ->setClaims_by_contracts_mng($claims_by_contracts_mng)
            ->setClaims_by_rso($claims_by_rso)
            ->setNet_assets($net_assets)
            ->setAnnual_financial_statements($annual_financial_statements)
            ->setAnnual_financial_statements_files($annual_financial_statements_files)
            ->setRevenues_expenditures_estimates($revenues_expenditures_estimates)
            ->setRevenues_expenditures_estimates_files($revenues_expenditures_estimates_files)
            ->setPerformance_report($performance_report)
            ->setPerformance_report_files($performance_report_files)
            ->setMembers_meetings_minutes($members_meetings_minutes)
            ->setMembers_meetings_minutes_files($members_meetings_minutes_files)
            ->setAudit_commision_report($audit_commision_report)
            ->setAudit_commision_report_files($audit_commision_report_files)
            ->setAudit_report($audit_report)
            ->setAudit_report_files($audit_report_files)
            ->setDebt_for_mng($debt_for_mng)
            ->setDebt_owners($debt_owners)
            ->setDebt_owners_for_ku($debt_owners_for_ku)
            ->setDebt_uo_for_ku($debt_uo_for_ku)
            ->setDebt_owners_communal($debt_owners_communal)
            ->setCharged_for_mng($charged_for_mng)
            ->setCharged_for_resources($charged_for_resources)
            ->setSpending_repair($spending_repair)
            ->setSpending_beauty($spending_beauty)
            ->setSpending_repair_invests($spending_repair_invests)
            ->setPayed_ku_by_statements($payed_ku_by_statements)
            ->setPayed_ku_by_needs($payed_ku_by_needs)
            ->setManagement_contract($management_contract)
            ->setManagement_contract_files($management_contract_files)
            ->setServices_cost($services_cost)
            ->setServices_cost_files($services_cost_files)
            ->setTariffs($tariffs)
            ->setTariffs_files($tariffs_files)
            ->setAdditional_files($additional_files)
            ->setOkopf($okopf)
            ->setFirstname($firstname)
            ->setSurname($surname)
            ->setMiddlename($middlename)
            ->setOgrn($ogrn)
            ->setLegal_address($legal_address)
            ->setActual_address($actual_address)
            ->setPost_address($post_address)
            ->setPhone($phone)
            ->setEmail($email)
            ->setSite($site)
            ->setProportion_sf($proportion_sf)
            ->setProportion_mo($proportion_mo);
    }
    /**
     * Get work_time value
     * @return string|null
     */
    public function getWork_time()
    {
        return $this->work_time;
    }
    /**
     * Set work_time value
     * @param string $work_time
     * @return \StructType\CompanyProfileData
     */
    public function setWork_time($work_time = null)
    {
        // validation for constraint: string
        if (!is_null($work_time) && !is_string($work_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($work_time, true), gettype($work_time)), __LINE__);
        }
        $this->work_time = $work_time;
        return $this;
    }
    /**
     * Get additional_info value
     * @return string|null
     */
    public function getAdditional_info()
    {
        return $this->additional_info;
    }
    /**
     * Set additional_info value
     * @param string $additional_info
     * @return \StructType\CompanyProfileData
     */
    public function setAdditional_info($additional_info = null)
    {
        // validation for constraint: string
        if (!is_null($additional_info) && !is_string($additional_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_info, true), gettype($additional_info)), __LINE__);
        }
        $this->additional_info = $additional_info;
        return $this;
    }
    /**
     * Get date_assignment_ogrn value
     * @return string|null
     */
    public function getDate_assignment_ogrn()
    {
        return $this->date_assignment_ogrn;
    }
    /**
     * Set date_assignment_ogrn value
     * @param string $date_assignment_ogrn
     * @return \StructType\CompanyProfileData
     */
    public function setDate_assignment_ogrn($date_assignment_ogrn = null)
    {
        // validation for constraint: string
        if (!is_null($date_assignment_ogrn) && !is_string($date_assignment_ogrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_assignment_ogrn, true), gettype($date_assignment_ogrn)), __LINE__);
        }
        $this->date_assignment_ogrn = $date_assignment_ogrn;
        return $this;
    }
    /**
     * Get name_authority_assigning_ogrn value
     * @return string|null
     */
    public function getName_authority_assigning_ogrn()
    {
        return $this->name_authority_assigning_ogrn;
    }
    /**
     * Set name_authority_assigning_ogrn value
     * @param string $name_authority_assigning_ogrn
     * @return \StructType\CompanyProfileData
     */
    public function setName_authority_assigning_ogrn($name_authority_assigning_ogrn = null)
    {
        // validation for constraint: string
        if (!is_null($name_authority_assigning_ogrn) && !is_string($name_authority_assigning_ogrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name_authority_assigning_ogrn, true), gettype($name_authority_assigning_ogrn)), __LINE__);
        }
        $this->name_authority_assigning_ogrn = $name_authority_assigning_ogrn;
        return $this;
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param string $position
     * @return \StructType\CompanyProfileData
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \StructType\CompanyProfileData
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get participation_in_associations value
     * @return string|null
     */
    public function getParticipation_in_associations()
    {
        return $this->participation_in_associations;
    }
    /**
     * Set participation_in_associations value
     * @param string $participation_in_associations
     * @return \StructType\CompanyProfileData
     */
    public function setParticipation_in_associations($participation_in_associations = null)
    {
        // validation for constraint: string
        if (!is_null($participation_in_associations) && !is_string($participation_in_associations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($participation_in_associations, true), gettype($participation_in_associations)), __LINE__);
        }
        $this->participation_in_associations = $participation_in_associations;
        return $this;
    }
    /**
     * Get srf_count value
     * @return int|null
     */
    public function getSrf_count()
    {
        return $this->srf_count;
    }
    /**
     * Set srf_count value
     * @param int $srf_count
     * @return \StructType\CompanyProfileData
     */
    public function setSrf_count($srf_count = null)
    {
        // validation for constraint: int
        if (!is_null($srf_count) && !(is_int($srf_count) || ctype_digit($srf_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($srf_count, true), gettype($srf_count)), __LINE__);
        }
        $this->srf_count = $srf_count;
        return $this;
    }
    /**
     * Get mo_count value
     * @return int|null
     */
    public function getMo_count()
    {
        return $this->mo_count;
    }
    /**
     * Set mo_count value
     * @param int $mo_count
     * @return \StructType\CompanyProfileData
     */
    public function setMo_count($mo_count = null)
    {
        // validation for constraint: int
        if (!is_null($mo_count) && !(is_int($mo_count) || ctype_digit($mo_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mo_count, true), gettype($mo_count)), __LINE__);
        }
        $this->mo_count = $mo_count;
        return $this;
    }
    /**
     * Get offices_count value
     * @return int|null
     */
    public function getOffices_count()
    {
        return $this->offices_count;
    }
    /**
     * Set offices_count value
     * @param int $offices_count
     * @return \StructType\CompanyProfileData
     */
    public function setOffices_count($offices_count = null)
    {
        // validation for constraint: int
        if (!is_null($offices_count) && !(is_int($offices_count) || ctype_digit($offices_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offices_count, true), gettype($offices_count)), __LINE__);
        }
        $this->offices_count = $offices_count;
        return $this;
    }
    /**
     * Get staff_regular_total value
     * @return int|null
     */
    public function getStaff_regular_total()
    {
        return $this->staff_regular_total;
    }
    /**
     * Set staff_regular_total value
     * @param int $staff_regular_total
     * @return \StructType\CompanyProfileData
     */
    public function setStaff_regular_total($staff_regular_total = null)
    {
        // validation for constraint: int
        if (!is_null($staff_regular_total) && !(is_int($staff_regular_total) || ctype_digit($staff_regular_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($staff_regular_total, true), gettype($staff_regular_total)), __LINE__);
        }
        $this->staff_regular_total = $staff_regular_total;
        return $this;
    }
    /**
     * Get staff_regular_administrative value
     * @return int|null
     */
    public function getStaff_regular_administrative()
    {
        return $this->staff_regular_administrative;
    }
    /**
     * Set staff_regular_administrative value
     * @param int $staff_regular_administrative
     * @return \StructType\CompanyProfileData
     */
    public function setStaff_regular_administrative($staff_regular_administrative = null)
    {
        // validation for constraint: int
        if (!is_null($staff_regular_administrative) && !(is_int($staff_regular_administrative) || ctype_digit($staff_regular_administrative))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($staff_regular_administrative, true), gettype($staff_regular_administrative)), __LINE__);
        }
        $this->staff_regular_administrative = $staff_regular_administrative;
        return $this;
    }
    /**
     * Get staff_regular_engineers value
     * @return int|null
     */
    public function getStaff_regular_engineers()
    {
        return $this->staff_regular_engineers;
    }
    /**
     * Set staff_regular_engineers value
     * @param int $staff_regular_engineers
     * @return \StructType\CompanyProfileData
     */
    public function setStaff_regular_engineers($staff_regular_engineers = null)
    {
        // validation for constraint: int
        if (!is_null($staff_regular_engineers) && !(is_int($staff_regular_engineers) || ctype_digit($staff_regular_engineers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($staff_regular_engineers, true), gettype($staff_regular_engineers)), __LINE__);
        }
        $this->staff_regular_engineers = $staff_regular_engineers;
        return $this;
    }
    /**
     * Get staff_regular_labor value
     * @return int|null
     */
    public function getStaff_regular_labor()
    {
        return $this->staff_regular_labor;
    }
    /**
     * Set staff_regular_labor value
     * @param int $staff_regular_labor
     * @return \StructType\CompanyProfileData
     */
    public function setStaff_regular_labor($staff_regular_labor = null)
    {
        // validation for constraint: int
        if (!is_null($staff_regular_labor) && !(is_int($staff_regular_labor) || ctype_digit($staff_regular_labor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($staff_regular_labor, true), gettype($staff_regular_labor)), __LINE__);
        }
        $this->staff_regular_labor = $staff_regular_labor;
        return $this;
    }
    /**
     * Get count_dismissed value
     * @return \StructType\CountDismissed|null
     */
    public function getCount_dismissed()
    {
        return $this->count_dismissed;
    }
    /**
     * Set count_dismissed value
     * @param \StructType\CountDismissed $count_dismissed
     * @return \StructType\CompanyProfileData
     */
    public function setCount_dismissed(\StructType\CountDismissed $count_dismissed = null)
    {
        $this->count_dismissed = $count_dismissed;
        return $this;
    }
    /**
     * Get accidents_count value
     * @return int|null
     */
    public function getAccidents_count()
    {
        return $this->accidents_count;
    }
    /**
     * Set accidents_count value
     * @param int $accidents_count
     * @return \StructType\CompanyProfileData
     */
    public function setAccidents_count($accidents_count = null)
    {
        // validation for constraint: int
        if (!is_null($accidents_count) && !(is_int($accidents_count) || ctype_digit($accidents_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accidents_count, true), gettype($accidents_count)), __LINE__);
        }
        $this->accidents_count = $accidents_count;
        return $this;
    }
    /**
     * Get prosecute_count value
     * @return int|null
     */
    public function getProsecute_count()
    {
        return $this->prosecute_count;
    }
    /**
     * Set prosecute_count value
     * @param int $prosecute_count
     * @return \StructType\CompanyProfileData
     */
    public function setProsecute_count($prosecute_count = null)
    {
        // validation for constraint: int
        if (!is_null($prosecute_count) && !(is_int($prosecute_count) || ctype_digit($prosecute_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prosecute_count, true), gettype($prosecute_count)), __LINE__);
        }
        $this->prosecute_count = $prosecute_count;
        return $this;
    }
    /**
     * Get prosecute_copies_of_documents value
     * @return string|null
     */
    public function getProsecute_copies_of_documents()
    {
        return $this->prosecute_copies_of_documents;
    }
    /**
     * Set prosecute_copies_of_documents value
     * @param string $prosecute_copies_of_documents
     * @return \StructType\CompanyProfileData
     */
    public function setProsecute_copies_of_documents($prosecute_copies_of_documents = null)
    {
        // validation for constraint: string
        if (!is_null($prosecute_copies_of_documents) && !is_string($prosecute_copies_of_documents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prosecute_copies_of_documents, true), gettype($prosecute_copies_of_documents)), __LINE__);
        }
        $this->prosecute_copies_of_documents = $prosecute_copies_of_documents;
        return $this;
    }
    /**
     * Get prosecute_documents_copies_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getProsecute_documents_copies_files()
    {
        return $this->prosecute_documents_copies_files;
    }
    /**
     * Set prosecute_documents_copies_files value
     * @param \ArrayType\ArrayOfInt $prosecute_documents_copies_files
     * @return \StructType\CompanyProfileData
     */
    public function setProsecute_documents_copies_files(\ArrayType\ArrayOfInt $prosecute_documents_copies_files = null)
    {
        $this->prosecute_documents_copies_files = $prosecute_documents_copies_files;
        return $this;
    }
    /**
     * Get tsg_management_members value
     * @return string|null
     */
    public function getTsg_management_members()
    {
        return $this->tsg_management_members;
    }
    /**
     * Set tsg_management_members value
     * @param string $tsg_management_members
     * @return \StructType\CompanyProfileData
     */
    public function setTsg_management_members($tsg_management_members = null)
    {
        // validation for constraint: string
        if (!is_null($tsg_management_members) && !is_string($tsg_management_members)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tsg_management_members, true), gettype($tsg_management_members)), __LINE__);
        }
        $this->tsg_management_members = $tsg_management_members;
        return $this;
    }
    /**
     * Get audit_commision_members value
     * @return string|null
     */
    public function getAudit_commision_members()
    {
        return $this->audit_commision_members;
    }
    /**
     * Set audit_commision_members value
     * @param string $audit_commision_members
     * @return \StructType\CompanyProfileData
     */
    public function setAudit_commision_members($audit_commision_members = null)
    {
        // validation for constraint: string
        if (!is_null($audit_commision_members) && !is_string($audit_commision_members)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($audit_commision_members, true), gettype($audit_commision_members)), __LINE__);
        }
        $this->audit_commision_members = $audit_commision_members;
        return $this;
    }
    /**
     * Get additional_info_freeform value
     * @return string|null
     */
    public function getAdditional_info_freeform()
    {
        return $this->additional_info_freeform;
    }
    /**
     * Set additional_info_freeform value
     * @param string $additional_info_freeform
     * @return \StructType\CompanyProfileData
     */
    public function setAdditional_info_freeform($additional_info_freeform = null)
    {
        // validation for constraint: string
        if (!is_null($additional_info_freeform) && !is_string($additional_info_freeform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_info_freeform, true), gettype($additional_info_freeform)), __LINE__);
        }
        $this->additional_info_freeform = $additional_info_freeform;
        return $this;
    }
    /**
     * Get residents_count value
     * @return int|null
     */
    public function getResidents_count()
    {
        return $this->residents_count;
    }
    /**
     * Set residents_count value
     * @param int $residents_count
     * @return \StructType\CompanyProfileData
     */
    public function setResidents_count($residents_count = null)
    {
        // validation for constraint: int
        if (!is_null($residents_count) && !(is_int($residents_count) || ctype_digit($residents_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($residents_count, true), gettype($residents_count)), __LINE__);
        }
        $this->residents_count = $residents_count;
        return $this;
    }
    /**
     * Get count_houses_under_mng_report_date value
     * @return \StructType\CountHousesUnderMngReportDate|null
     */
    public function getCount_houses_under_mng_report_date()
    {
        return $this->count_houses_under_mng_report_date;
    }
    /**
     * Set count_houses_under_mng_report_date value
     * @param \StructType\CountHousesUnderMngReportDate $count_houses_under_mng_report_date
     * @return \StructType\CompanyProfileData
     */
    public function setCount_houses_under_mng_report_date(\StructType\CountHousesUnderMngReportDate $count_houses_under_mng_report_date = null)
    {
        $this->count_houses_under_mng_report_date = $count_houses_under_mng_report_date;
        return $this;
    }
    /**
     * Get count_houses_under_mng_start_period value
     * @return \StructType\CountHousesUnderMngStartPeriod|null
     */
    public function getCount_houses_under_mng_start_period()
    {
        return $this->count_houses_under_mng_start_period;
    }
    /**
     * Set count_houses_under_mng_start_period value
     * @param \StructType\CountHousesUnderMngStartPeriod $count_houses_under_mng_start_period
     * @return \StructType\CompanyProfileData
     */
    public function setCount_houses_under_mng_start_period(\StructType\CountHousesUnderMngStartPeriod $count_houses_under_mng_start_period = null)
    {
        $this->count_houses_under_mng_start_period = $count_houses_under_mng_start_period;
        return $this;
    }
    /**
     * Get sum_sq_houses_under_mng_report_date value
     * @return \StructType\SumSqHousesUnderMngReportDate|null
     */
    public function getSum_sq_houses_under_mng_report_date()
    {
        return $this->sum_sq_houses_under_mng_report_date;
    }
    /**
     * Set sum_sq_houses_under_mng_report_date value
     * @param \StructType\SumSqHousesUnderMngReportDate $sum_sq_houses_under_mng_report_date
     * @return \StructType\CompanyProfileData
     */
    public function setSum_sq_houses_under_mng_report_date(\StructType\SumSqHousesUnderMngReportDate $sum_sq_houses_under_mng_report_date = null)
    {
        $this->sum_sq_houses_under_mng_report_date = $sum_sq_houses_under_mng_report_date;
        return $this;
    }
    /**
     * Get sum_sq_houses_under_mng_start_period value
     * @return \StructType\SumSqHousesUnderMngStartPeriod|null
     */
    public function getSum_sq_houses_under_mng_start_period()
    {
        return $this->sum_sq_houses_under_mng_start_period;
    }
    /**
     * Set sum_sq_houses_under_mng_start_period value
     * @param \StructType\SumSqHousesUnderMngStartPeriod $sum_sq_houses_under_mng_start_period
     * @return \StructType\CompanyProfileData
     */
    public function setSum_sq_houses_under_mng_start_period(\StructType\SumSqHousesUnderMngStartPeriod $sum_sq_houses_under_mng_start_period = null)
    {
        $this->sum_sq_houses_under_mng_start_period = $sum_sq_houses_under_mng_start_period;
        return $this;
    }
    /**
     * Get avg_time_service_mkd value
     * @return \StructType\AvgTimeServiceMkd|null
     */
    public function getAvg_time_service_mkd()
    {
        return $this->avg_time_service_mkd;
    }
    /**
     * Set avg_time_service_mkd value
     * @param \StructType\AvgTimeServiceMkd $avg_time_service_mkd
     * @return \StructType\CompanyProfileData
     */
    public function setAvg_time_service_mkd(\StructType\AvgTimeServiceMkd $avg_time_service_mkd = null)
    {
        $this->avg_time_service_mkd = $avg_time_service_mkd;
        return $this;
    }
    /**
     * Get income_of_mng value
     * @return \StructType\IncomeOfMng|null
     */
    public function getIncome_of_mng()
    {
        return $this->income_of_mng;
    }
    /**
     * Set income_of_mng value
     * @param \StructType\IncomeOfMng $income_of_mng
     * @return \StructType\CompanyProfileData
     */
    public function setIncome_of_mng(\StructType\IncomeOfMng $income_of_mng = null)
    {
        $this->income_of_mng = $income_of_mng;
        return $this;
    }
    /**
     * Get income_of_usage value
     * @return \StructType\IncomeOfUsage|null
     */
    public function getIncome_of_usage()
    {
        return $this->income_of_usage;
    }
    /**
     * Set income_of_usage value
     * @param \StructType\IncomeOfUsage $income_of_usage
     * @return \StructType\CompanyProfileData
     */
    public function setIncome_of_usage(\StructType\IncomeOfUsage $income_of_usage = null)
    {
        $this->income_of_usage = $income_of_usage;
        return $this;
    }
    /**
     * Get income_of_ku value
     * @return \StructType\IncomeOfKu|null
     */
    public function getIncome_of_ku()
    {
        return $this->income_of_ku;
    }
    /**
     * Set income_of_ku value
     * @param \StructType\IncomeOfKu $income_of_ku
     * @return \StructType\CompanyProfileData
     */
    public function setIncome_of_ku(\StructType\IncomeOfKu $income_of_ku = null)
    {
        $this->income_of_ku = $income_of_ku;
        return $this;
    }
    /**
     * Get spending_of_mng value
     * @return \StructType\SpendingOfMng|null
     */
    public function getSpending_of_mng()
    {
        return $this->spending_of_mng;
    }
    /**
     * Set spending_of_mng value
     * @param \StructType\SpendingOfMng $spending_of_mng
     * @return \StructType\CompanyProfileData
     */
    public function setSpending_of_mng(\StructType\SpendingOfMng $spending_of_mng = null)
    {
        $this->spending_of_mng = $spending_of_mng;
        return $this;
    }
    /**
     * Get claims_by_contracts_mng value
     * @return \StructType\ClaimsByContractsMng|null
     */
    public function getClaims_by_contracts_mng()
    {
        return $this->claims_by_contracts_mng;
    }
    /**
     * Set claims_by_contracts_mng value
     * @param \StructType\ClaimsByContractsMng $claims_by_contracts_mng
     * @return \StructType\CompanyProfileData
     */
    public function setClaims_by_contracts_mng(\StructType\ClaimsByContractsMng $claims_by_contracts_mng = null)
    {
        $this->claims_by_contracts_mng = $claims_by_contracts_mng;
        return $this;
    }
    /**
     * Get claims_by_rso value
     * @return \StructType\ClaimsByRso|null
     */
    public function getClaims_by_rso()
    {
        return $this->claims_by_rso;
    }
    /**
     * Set claims_by_rso value
     * @param \StructType\ClaimsByRso $claims_by_rso
     * @return \StructType\CompanyProfileData
     */
    public function setClaims_by_rso(\StructType\ClaimsByRso $claims_by_rso = null)
    {
        $this->claims_by_rso = $claims_by_rso;
        return $this;
    }
    /**
     * Get net_assets value
     * @return float|null
     */
    public function getNet_assets()
    {
        return $this->net_assets;
    }
    /**
     * Set net_assets value
     * @param float $net_assets
     * @return \StructType\CompanyProfileData
     */
    public function setNet_assets($net_assets = null)
    {
        // validation for constraint: float
        if (!is_null($net_assets) && !(is_float($net_assets) || is_numeric($net_assets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($net_assets, true), gettype($net_assets)), __LINE__);
        }
        $this->net_assets = $net_assets;
        return $this;
    }
    /**
     * Get annual_financial_statements value
     * @return string|null
     */
    public function getAnnual_financial_statements()
    {
        return $this->annual_financial_statements;
    }
    /**
     * Set annual_financial_statements value
     * @param string $annual_financial_statements
     * @return \StructType\CompanyProfileData
     */
    public function setAnnual_financial_statements($annual_financial_statements = null)
    {
        // validation for constraint: string
        if (!is_null($annual_financial_statements) && !is_string($annual_financial_statements)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($annual_financial_statements, true), gettype($annual_financial_statements)), __LINE__);
        }
        $this->annual_financial_statements = $annual_financial_statements;
        return $this;
    }
    /**
     * Get annual_financial_statements_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getAnnual_financial_statements_files()
    {
        return $this->annual_financial_statements_files;
    }
    /**
     * Set annual_financial_statements_files value
     * @param \ArrayType\ArrayOfInt $annual_financial_statements_files
     * @return \StructType\CompanyProfileData
     */
    public function setAnnual_financial_statements_files(\ArrayType\ArrayOfInt $annual_financial_statements_files = null)
    {
        $this->annual_financial_statements_files = $annual_financial_statements_files;
        return $this;
    }
    /**
     * Get revenues_expenditures_estimates value
     * @return string|null
     */
    public function getRevenues_expenditures_estimates()
    {
        return $this->revenues_expenditures_estimates;
    }
    /**
     * Set revenues_expenditures_estimates value
     * @param string $revenues_expenditures_estimates
     * @return \StructType\CompanyProfileData
     */
    public function setRevenues_expenditures_estimates($revenues_expenditures_estimates = null)
    {
        // validation for constraint: string
        if (!is_null($revenues_expenditures_estimates) && !is_string($revenues_expenditures_estimates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenues_expenditures_estimates, true), gettype($revenues_expenditures_estimates)), __LINE__);
        }
        $this->revenues_expenditures_estimates = $revenues_expenditures_estimates;
        return $this;
    }
    /**
     * Get revenues_expenditures_estimates_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getRevenues_expenditures_estimates_files()
    {
        return $this->revenues_expenditures_estimates_files;
    }
    /**
     * Set revenues_expenditures_estimates_files value
     * @param \ArrayType\ArrayOfInt $revenues_expenditures_estimates_files
     * @return \StructType\CompanyProfileData
     */
    public function setRevenues_expenditures_estimates_files(\ArrayType\ArrayOfInt $revenues_expenditures_estimates_files = null)
    {
        $this->revenues_expenditures_estimates_files = $revenues_expenditures_estimates_files;
        return $this;
    }
    /**
     * Get performance_report value
     * @return string|null
     */
    public function getPerformance_report()
    {
        return $this->performance_report;
    }
    /**
     * Set performance_report value
     * @param string $performance_report
     * @return \StructType\CompanyProfileData
     */
    public function setPerformance_report($performance_report = null)
    {
        // validation for constraint: string
        if (!is_null($performance_report) && !is_string($performance_report)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($performance_report, true), gettype($performance_report)), __LINE__);
        }
        $this->performance_report = $performance_report;
        return $this;
    }
    /**
     * Get performance_report_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getPerformance_report_files()
    {
        return $this->performance_report_files;
    }
    /**
     * Set performance_report_files value
     * @param \ArrayType\ArrayOfInt $performance_report_files
     * @return \StructType\CompanyProfileData
     */
    public function setPerformance_report_files(\ArrayType\ArrayOfInt $performance_report_files = null)
    {
        $this->performance_report_files = $performance_report_files;
        return $this;
    }
    /**
     * Get members_meetings_minutes value
     * @return string|null
     */
    public function getMembers_meetings_minutes()
    {
        return $this->members_meetings_minutes;
    }
    /**
     * Set members_meetings_minutes value
     * @param string $members_meetings_minutes
     * @return \StructType\CompanyProfileData
     */
    public function setMembers_meetings_minutes($members_meetings_minutes = null)
    {
        // validation for constraint: string
        if (!is_null($members_meetings_minutes) && !is_string($members_meetings_minutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($members_meetings_minutes, true), gettype($members_meetings_minutes)), __LINE__);
        }
        $this->members_meetings_minutes = $members_meetings_minutes;
        return $this;
    }
    /**
     * Get members_meetings_minutes_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getMembers_meetings_minutes_files()
    {
        return $this->members_meetings_minutes_files;
    }
    /**
     * Set members_meetings_minutes_files value
     * @param \ArrayType\ArrayOfInt $members_meetings_minutes_files
     * @return \StructType\CompanyProfileData
     */
    public function setMembers_meetings_minutes_files(\ArrayType\ArrayOfInt $members_meetings_minutes_files = null)
    {
        $this->members_meetings_minutes_files = $members_meetings_minutes_files;
        return $this;
    }
    /**
     * Get audit_commision_report value
     * @return string|null
     */
    public function getAudit_commision_report()
    {
        return $this->audit_commision_report;
    }
    /**
     * Set audit_commision_report value
     * @param string $audit_commision_report
     * @return \StructType\CompanyProfileData
     */
    public function setAudit_commision_report($audit_commision_report = null)
    {
        // validation for constraint: string
        if (!is_null($audit_commision_report) && !is_string($audit_commision_report)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($audit_commision_report, true), gettype($audit_commision_report)), __LINE__);
        }
        $this->audit_commision_report = $audit_commision_report;
        return $this;
    }
    /**
     * Get audit_commision_report_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getAudit_commision_report_files()
    {
        return $this->audit_commision_report_files;
    }
    /**
     * Set audit_commision_report_files value
     * @param \ArrayType\ArrayOfInt $audit_commision_report_files
     * @return \StructType\CompanyProfileData
     */
    public function setAudit_commision_report_files(\ArrayType\ArrayOfInt $audit_commision_report_files = null)
    {
        $this->audit_commision_report_files = $audit_commision_report_files;
        return $this;
    }
    /**
     * Get audit_report value
     * @return string|null
     */
    public function getAudit_report()
    {
        return $this->audit_report;
    }
    /**
     * Set audit_report value
     * @param string $audit_report
     * @return \StructType\CompanyProfileData
     */
    public function setAudit_report($audit_report = null)
    {
        // validation for constraint: string
        if (!is_null($audit_report) && !is_string($audit_report)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($audit_report, true), gettype($audit_report)), __LINE__);
        }
        $this->audit_report = $audit_report;
        return $this;
    }
    /**
     * Get audit_report_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getAudit_report_files()
    {
        return $this->audit_report_files;
    }
    /**
     * Set audit_report_files value
     * @param \ArrayType\ArrayOfInt $audit_report_files
     * @return \StructType\CompanyProfileData
     */
    public function setAudit_report_files(\ArrayType\ArrayOfInt $audit_report_files = null)
    {
        $this->audit_report_files = $audit_report_files;
        return $this;
    }
    /**
     * Get debt_for_mng value
     * @return \StructType\DebtForMng|null
     */
    public function getDebt_for_mng()
    {
        return $this->debt_for_mng;
    }
    /**
     * Set debt_for_mng value
     * @param \StructType\DebtForMng $debt_for_mng
     * @return \StructType\CompanyProfileData
     */
    public function setDebt_for_mng(\StructType\DebtForMng $debt_for_mng = null)
    {
        $this->debt_for_mng = $debt_for_mng;
        return $this;
    }
    /**
     * Get debt_owners value
     * @return float|null
     */
    public function getDebt_owners()
    {
        return $this->debt_owners;
    }
    /**
     * Set debt_owners value
     * @param float $debt_owners
     * @return \StructType\CompanyProfileData
     */
    public function setDebt_owners($debt_owners = null)
    {
        // validation for constraint: float
        if (!is_null($debt_owners) && !(is_float($debt_owners) || is_numeric($debt_owners))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debt_owners, true), gettype($debt_owners)), __LINE__);
        }
        $this->debt_owners = $debt_owners;
        return $this;
    }
    /**
     * Get debt_owners_for_ku value
     * @return \StructType\DebtOwnersForKu|null
     */
    public function getDebt_owners_for_ku()
    {
        return $this->debt_owners_for_ku;
    }
    /**
     * Set debt_owners_for_ku value
     * @param \StructType\DebtOwnersForKu $debt_owners_for_ku
     * @return \StructType\CompanyProfileData
     */
    public function setDebt_owners_for_ku(\StructType\DebtOwnersForKu $debt_owners_for_ku = null)
    {
        $this->debt_owners_for_ku = $debt_owners_for_ku;
        return $this;
    }
    /**
     * Get debt_uo_for_ku value
     * @return \StructType\DebtUoForKu|null
     */
    public function getDebt_uo_for_ku()
    {
        return $this->debt_uo_for_ku;
    }
    /**
     * Set debt_uo_for_ku value
     * @param \StructType\DebtUoForKu $debt_uo_for_ku
     * @return \StructType\CompanyProfileData
     */
    public function setDebt_uo_for_ku(\StructType\DebtUoForKu $debt_uo_for_ku = null)
    {
        $this->debt_uo_for_ku = $debt_uo_for_ku;
        return $this;
    }
    /**
     * Get debt_owners_communal value
     * @return float|null
     */
    public function getDebt_owners_communal()
    {
        return $this->debt_owners_communal;
    }
    /**
     * Set debt_owners_communal value
     * @param float $debt_owners_communal
     * @return \StructType\CompanyProfileData
     */
    public function setDebt_owners_communal($debt_owners_communal = null)
    {
        // validation for constraint: float
        if (!is_null($debt_owners_communal) && !(is_float($debt_owners_communal) || is_numeric($debt_owners_communal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debt_owners_communal, true), gettype($debt_owners_communal)), __LINE__);
        }
        $this->debt_owners_communal = $debt_owners_communal;
        return $this;
    }
    /**
     * Get charged_for_mng value
     * @return \StructType\ChargedForMng|null
     */
    public function getCharged_for_mng()
    {
        return $this->charged_for_mng;
    }
    /**
     * Set charged_for_mng value
     * @param \StructType\ChargedForMng $charged_for_mng
     * @return \StructType\CompanyProfileData
     */
    public function setCharged_for_mng(\StructType\ChargedForMng $charged_for_mng = null)
    {
        $this->charged_for_mng = $charged_for_mng;
        return $this;
    }
    /**
     * Get charged_for_resources value
     * @return \StructType\ChargedForResources|null
     */
    public function getCharged_for_resources()
    {
        return $this->charged_for_resources;
    }
    /**
     * Set charged_for_resources value
     * @param \StructType\ChargedForResources $charged_for_resources
     * @return \StructType\CompanyProfileData
     */
    public function setCharged_for_resources(\StructType\ChargedForResources $charged_for_resources = null)
    {
        $this->charged_for_resources = $charged_for_resources;
        return $this;
    }
    /**
     * Get spending_repair value
     * @return \StructType\SpendingRepair|null
     */
    public function getSpending_repair()
    {
        return $this->spending_repair;
    }
    /**
     * Set spending_repair value
     * @param \StructType\SpendingRepair $spending_repair
     * @return \StructType\CompanyProfileData
     */
    public function setSpending_repair(\StructType\SpendingRepair $spending_repair = null)
    {
        $this->spending_repair = $spending_repair;
        return $this;
    }
    /**
     * Get spending_beauty value
     * @return \StructType\SpendingBeauty|null
     */
    public function getSpending_beauty()
    {
        return $this->spending_beauty;
    }
    /**
     * Set spending_beauty value
     * @param \StructType\SpendingBeauty $spending_beauty
     * @return \StructType\CompanyProfileData
     */
    public function setSpending_beauty(\StructType\SpendingBeauty $spending_beauty = null)
    {
        $this->spending_beauty = $spending_beauty;
        return $this;
    }
    /**
     * Get spending_repair_invests value
     * @return \StructType\SpendingRepairInvests|null
     */
    public function getSpending_repair_invests()
    {
        return $this->spending_repair_invests;
    }
    /**
     * Set spending_repair_invests value
     * @param \StructType\SpendingRepairInvests $spending_repair_invests
     * @return \StructType\CompanyProfileData
     */
    public function setSpending_repair_invests(\StructType\SpendingRepairInvests $spending_repair_invests = null)
    {
        $this->spending_repair_invests = $spending_repair_invests;
        return $this;
    }
    /**
     * Get payed_ku_by_statements value
     * @return \StructType\PayedKuByStatements|null
     */
    public function getPayed_ku_by_statements()
    {
        return $this->payed_ku_by_statements;
    }
    /**
     * Set payed_ku_by_statements value
     * @param \StructType\PayedKuByStatements $payed_ku_by_statements
     * @return \StructType\CompanyProfileData
     */
    public function setPayed_ku_by_statements(\StructType\PayedKuByStatements $payed_ku_by_statements = null)
    {
        $this->payed_ku_by_statements = $payed_ku_by_statements;
        return $this;
    }
    /**
     * Get payed_ku_by_needs value
     * @return \StructType\PayedKuByNeeds|null
     */
    public function getPayed_ku_by_needs()
    {
        return $this->payed_ku_by_needs;
    }
    /**
     * Set payed_ku_by_needs value
     * @param \StructType\PayedKuByNeeds $payed_ku_by_needs
     * @return \StructType\CompanyProfileData
     */
    public function setPayed_ku_by_needs(\StructType\PayedKuByNeeds $payed_ku_by_needs = null)
    {
        $this->payed_ku_by_needs = $payed_ku_by_needs;
        return $this;
    }
    /**
     * Get management_contract value
     * @return string|null
     */
    public function getManagement_contract()
    {
        return $this->management_contract;
    }
    /**
     * Set management_contract value
     * @param string $management_contract
     * @return \StructType\CompanyProfileData
     */
    public function setManagement_contract($management_contract = null)
    {
        // validation for constraint: string
        if (!is_null($management_contract) && !is_string($management_contract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($management_contract, true), gettype($management_contract)), __LINE__);
        }
        $this->management_contract = $management_contract;
        return $this;
    }
    /**
     * Get management_contract_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getManagement_contract_files()
    {
        return $this->management_contract_files;
    }
    /**
     * Set management_contract_files value
     * @param \ArrayType\ArrayOfInt $management_contract_files
     * @return \StructType\CompanyProfileData
     */
    public function setManagement_contract_files(\ArrayType\ArrayOfInt $management_contract_files = null)
    {
        $this->management_contract_files = $management_contract_files;
        return $this;
    }
    /**
     * Get services_cost value
     * @return string|null
     */
    public function getServices_cost()
    {
        return $this->services_cost;
    }
    /**
     * Set services_cost value
     * @param string $services_cost
     * @return \StructType\CompanyProfileData
     */
    public function setServices_cost($services_cost = null)
    {
        // validation for constraint: string
        if (!is_null($services_cost) && !is_string($services_cost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($services_cost, true), gettype($services_cost)), __LINE__);
        }
        $this->services_cost = $services_cost;
        return $this;
    }
    /**
     * Get services_cost_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getServices_cost_files()
    {
        return $this->services_cost_files;
    }
    /**
     * Set services_cost_files value
     * @param \ArrayType\ArrayOfInt $services_cost_files
     * @return \StructType\CompanyProfileData
     */
    public function setServices_cost_files(\ArrayType\ArrayOfInt $services_cost_files = null)
    {
        $this->services_cost_files = $services_cost_files;
        return $this;
    }
    /**
     * Get tariffs value
     * @return string|null
     */
    public function getTariffs()
    {
        return $this->tariffs;
    }
    /**
     * Set tariffs value
     * @param string $tariffs
     * @return \StructType\CompanyProfileData
     */
    public function setTariffs($tariffs = null)
    {
        // validation for constraint: string
        if (!is_null($tariffs) && !is_string($tariffs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffs, true), gettype($tariffs)), __LINE__);
        }
        $this->tariffs = $tariffs;
        return $this;
    }
    /**
     * Get tariffs_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getTariffs_files()
    {
        return $this->tariffs_files;
    }
    /**
     * Set tariffs_files value
     * @param \ArrayType\ArrayOfInt $tariffs_files
     * @return \StructType\CompanyProfileData
     */
    public function setTariffs_files(\ArrayType\ArrayOfInt $tariffs_files = null)
    {
        $this->tariffs_files = $tariffs_files;
        return $this;
    }
    /**
     * Get additional_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getAdditional_files()
    {
        return $this->additional_files;
    }
    /**
     * Set additional_files value
     * @param \ArrayType\ArrayOfInt $additional_files
     * @return \StructType\CompanyProfileData
     */
    public function setAdditional_files(\ArrayType\ArrayOfInt $additional_files = null)
    {
        $this->additional_files = $additional_files;
        return $this;
    }
    /**
     * Get okopf value
     * @return string|null
     */
    public function getOkopf()
    {
        return $this->okopf;
    }
    /**
     * Set okopf value
     * @uses \EnumType\Okopf::valueIsValid()
     * @uses \EnumType\Okopf::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $okopf
     * @return \StructType\CompanyProfileData
     */
    public function setOkopf($okopf = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Okopf::valueIsValid($okopf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Okopf', is_array($okopf) ? implode(', ', $okopf) : var_export($okopf, true), implode(', ', \EnumType\Okopf::getValidValues())), __LINE__);
        }
        $this->okopf = $okopf;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\CompanyProfileData
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \StructType\CompanyProfileData
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get middlename value
     * @return string|null
     */
    public function getMiddlename()
    {
        return $this->middlename;
    }
    /**
     * Set middlename value
     * @param string $middlename
     * @return \StructType\CompanyProfileData
     */
    public function setMiddlename($middlename = null)
    {
        // validation for constraint: string
        if (!is_null($middlename) && !is_string($middlename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middlename, true), gettype($middlename)), __LINE__);
        }
        $this->middlename = $middlename;
        return $this;
    }
    /**
     * Get ogrn value
     * @return string|null
     */
    public function getOgrn()
    {
        return $this->ogrn;
    }
    /**
     * Set ogrn value
     * @param string $ogrn
     * @return \StructType\CompanyProfileData
     */
    public function setOgrn($ogrn = null)
    {
        // validation for constraint: string
        if (!is_null($ogrn) && !is_string($ogrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ogrn, true), gettype($ogrn)), __LINE__);
        }
        $this->ogrn = $ogrn;
        return $this;
    }
    /**
     * Get legal_address value
     * @return \StructType\FiasAddress|null
     */
    public function getLegal_address()
    {
        return $this->legal_address;
    }
    /**
     * Set legal_address value
     * @param \StructType\FiasAddress $legal_address
     * @return \StructType\CompanyProfileData
     */
    public function setLegal_address(\StructType\FiasAddress $legal_address = null)
    {
        $this->legal_address = $legal_address;
        return $this;
    }
    /**
     * Get actual_address value
     * @return \StructType\FiasAddress|null
     */
    public function getActual_address()
    {
        return $this->actual_address;
    }
    /**
     * Set actual_address value
     * @param \StructType\FiasAddress $actual_address
     * @return \StructType\CompanyProfileData
     */
    public function setActual_address(\StructType\FiasAddress $actual_address = null)
    {
        $this->actual_address = $actual_address;
        return $this;
    }
    /**
     * Get post_address value
     * @return \StructType\FiasAddress|null
     */
    public function getPost_address()
    {
        return $this->post_address;
    }
    /**
     * Set post_address value
     * @param \StructType\FiasAddress $post_address
     * @return \StructType\CompanyProfileData
     */
    public function setPost_address(\StructType\FiasAddress $post_address = null)
    {
        $this->post_address = $post_address;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\CompanyProfileData
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CompanyProfileData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get site value
     * @return string|null
     */
    public function getSite()
    {
        return $this->site;
    }
    /**
     * Set site value
     * @param string $site
     * @return \StructType\CompanyProfileData
     */
    public function setSite($site = null)
    {
        // validation for constraint: string
        if (!is_null($site) && !is_string($site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($site, true), gettype($site)), __LINE__);
        }
        $this->site = $site;
        return $this;
    }
    /**
     * Get proportion_sf value
     * @return float|null
     */
    public function getProportion_sf()
    {
        return $this->proportion_sf;
    }
    /**
     * Set proportion_sf value
     * @param float $proportion_sf
     * @return \StructType\CompanyProfileData
     */
    public function setProportion_sf($proportion_sf = null)
    {
        // validation for constraint: float
        if (!is_null($proportion_sf) && !(is_float($proportion_sf) || is_numeric($proportion_sf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proportion_sf, true), gettype($proportion_sf)), __LINE__);
        }
        $this->proportion_sf = $proportion_sf;
        return $this;
    }
    /**
     * Get proportion_mo value
     * @return float|null
     */
    public function getProportion_mo()
    {
        return $this->proportion_mo;
    }
    /**
     * Set proportion_mo value
     * @param float $proportion_mo
     * @return \StructType\CompanyProfileData
     */
    public function setProportion_mo($proportion_mo = null)
    {
        // validation for constraint: float
        if (!is_null($proportion_mo) && !(is_float($proportion_mo) || is_numeric($proportion_mo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proportion_mo, true), gettype($proportion_mo)), __LINE__);
        }
        $this->proportion_mo = $proportion_mo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyProfileData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
