<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonSpace StructType
 * @subpackage Structs
 */
class CommonSpace extends AbstractStructBase
{
    /**
     * The common_space_area
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $common_space_area;
    /**
     * The common_space_overhaul_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $common_space_overhaul_date;
    /**
     * Constructor method for CommonSpace
     * @uses CommonSpace::setCommon_space_area()
     * @uses CommonSpace::setCommon_space_overhaul_date()
     * @param float $common_space_area
     * @param string $common_space_overhaul_date
     */
    public function __construct($common_space_area = null, $common_space_overhaul_date = null)
    {
        $this
            ->setCommon_space_area($common_space_area)
            ->setCommon_space_overhaul_date($common_space_overhaul_date);
    }
    /**
     * Get common_space_area value
     * @return float|null
     */
    public function getCommon_space_area()
    {
        return $this->common_space_area;
    }
    /**
     * Set common_space_area value
     * @param float $common_space_area
     * @return \StructType\CommonSpace
     */
    public function setCommon_space_area($common_space_area = null)
    {
        // validation for constraint: float
        if (!is_null($common_space_area) && !(is_float($common_space_area) || is_numeric($common_space_area))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($common_space_area, true), gettype($common_space_area)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($common_space_area) && mb_strlen(mb_substr($common_space_area, mb_strpos($common_space_area, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($common_space_area, true), mb_strlen(mb_substr($common_space_area, mb_strpos($common_space_area, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($common_space_area) && mb_strlen(preg_replace('/(\D)/', '', $common_space_area)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($common_space_area, true), mb_strlen(preg_replace('/(\D)/', '', $common_space_area))), __LINE__);
        }
        $this->common_space_area = $common_space_area;
        return $this;
    }
    /**
     * Get common_space_overhaul_date value
     * @return string|null
     */
    public function getCommon_space_overhaul_date()
    {
        return $this->common_space_overhaul_date;
    }
    /**
     * Set common_space_overhaul_date value
     * @param string $common_space_overhaul_date
     * @return \StructType\CommonSpace
     */
    public function setCommon_space_overhaul_date($common_space_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($common_space_overhaul_date) && !is_string($common_space_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($common_space_overhaul_date, true), gettype($common_space_overhaul_date)), __LINE__);
        }
        $this->common_space_overhaul_date = $common_space_overhaul_date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommonSpace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
