<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetRequestList
     * Meta information extracted from the WSDL
     * - documentation: GetRequestList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRequestList $parameters
     * @return \StructType\GetRequestListResponse|bool
     */
    public function GetRequestList(\StructType\GetRequestList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRequestList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseInfo
     * Meta information extracted from the WSDL
     * - documentation: Метод получения идентификатор дома в системе с соответствующим адресом по ФИАС.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseInfo $parameters
     * @return \StructType\GetHouseInfoResponse|bool
     */
    public function GetHouseInfo(\StructType\GetHouseInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseProfile
     * Meta information extracted from the WSDL
     * - documentation: Метод возвращает данные текущей/архивной анкеты дома с соответствующим ID дома.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseProfile $parameters
     * @return \StructType\GetHouseProfileResponse|bool
     */
    public function GetHouseProfile(\StructType\GetHouseProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseProfile988
     * Meta information extracted from the WSDL
     * - documentation: Метод возвращает данные текущей/архивной анкеты дома с соответствующим ID дома.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseProfile988 $parameters
     * @return \StructType\GetHouseProfile988Response|bool
     */
    public function GetHouseProfile988(\StructType\GetHouseProfile988 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseProfile988($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseProfileSF
     * Meta information extracted from the WSDL
     * - documentation: Метод постранично возвращает данные текущих/архивных анкет дома для выбранного региона
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseProfileSF $parameters
     * @return \StructType\GetHouseProfileSFResponse|bool
     */
    public function GetHouseProfileSF(\StructType\GetHouseProfileSF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseProfileSF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseProfileSF988
     * Meta information extracted from the WSDL
     * - documentation: Метод постранично возвращает данные текущих/архивных анкет дома для выбранного региона
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseProfileSF988 $parameters
     * @return \StructType\GetHouseProfileSF988Response|bool
     */
    public function GetHouseProfileSF988(\StructType\GetHouseProfileSF988 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseProfileSF988($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseProfileSFActual
     * Meta information extracted from the WSDL
     * - documentation: Метод постранично возвращает данные текущих анкет дома для выбранного региона
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseProfileSFActual $parameters
     * @return \StructType\GetHouseProfileSFActualResponse|bool
     */
    public function GetHouseProfileSFActual(\StructType\GetHouseProfileSFActual $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseProfileSFActual($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseProfileActual
     * Meta information extracted from the WSDL
     * - documentation: Метод возвращает данные текущей анкеты дома, независимо от того, находится дом в управлении УО или нет.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseProfileActual $parameters
     * @return \StructType\GetHouseProfileActualResponse|bool
     */
    public function GetHouseProfileActual(\StructType\GetHouseProfileActual $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseProfileActual($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseListChanges
     * Meta information extracted from the WSDL
     * - documentation: Метод выбирает все дома у которых за период с "дата/время" по "время запроса" были произведены изменения в текущей анкете -
     * изменен любой из параметров, касающихся раскрытия информации.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseListChanges $parameters
     * @return \StructType\GetHouseListChangesResponse|bool
     */
    public function GetHouseListChanges(\StructType\GetHouseListChanges $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseListChanges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrganizationListChanges
     * Meta information extracted from the WSDL
     * - documentation: Метод выбирает все УО у которых за период с "дата/время" по "время запроса" были произведены изменения в текущей анкете или
     * добавлены(исключены) дома в управление.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrganizationListChanges $parameters
     * @return \StructType\GetOrganizationListChangesResponse|bool
     */
    public function GetOrganizationListChanges(\StructType\GetOrganizationListChanges $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrganizationListChanges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseList
     * Meta information extracted from the WSDL
     * - documentation: Метод получения списка домов, находящихся в управлении организации с соответсвующим ИНН
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseList $parameters
     * @return \StructType\GetHouseListResponse|bool
     */
    public function GetHouseList(\StructType\GetHouseList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetHouseListByPage
     * Meta information extracted from the WSDL
     * - documentation: Метод получения списка домов, находящихся в управлении организации с соответсвующим ИНН
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHouseListByPage $parameters
     * @return \StructType\GetHouseListByPageResponse|bool
     */
    public function GetHouseListByPage(\StructType\GetHouseListByPage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetHouseListByPage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyProfile
     * Meta information extracted from the WSDL
     * - documentation: Метод получения данных анкеты управляющей организации с соответствующим ИНН за указанный отчетный период.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyProfile $parameters
     * @return \StructType\GetCompanyProfileResponse|bool
     */
    public function GetCompanyProfile(\StructType\GetCompanyProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanyProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyProfile988
     * Meta information extracted from the WSDL
     * - documentation: Метод получения данных анкеты управляющей организации с соответствующим ИНН за указанный отчетный период.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyProfile988 $parameters
     * @return \StructType\GetCompanyProfile988Response|bool
     */
    public function GetCompanyProfile988(\StructType\GetCompanyProfile988 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanyProfile988($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyProfileSF
     * Meta information extracted from the WSDL
     * - documentation: Метод получения данных анкеты управляющей организации с соответствующим ИНН за указанный отчетный период.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyProfileSF $parameters
     * @return \StructType\GetCompanyProfileSFResponse|bool
     */
    public function GetCompanyProfileSF(\StructType\GetCompanyProfileSF $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanyProfileSF($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCompanyProfileSF988
     * Meta information extracted from the WSDL
     * - documentation: Метод получения данных анкеты управляющей организации с соответствующим ИНН за указанный отчетный период.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCompanyProfileSF988 $parameters
     * @return \StructType\GetCompanyProfileSF988Response|bool
     */
    public function GetCompanyProfileSF988(\StructType\GetCompanyProfileSF988 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCompanyProfileSF988($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReportingPeriodList
     * Meta information extracted from the WSDL
     * - documentation: GetReportingPeriodList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetReportingPeriodList $parameters
     * @return \StructType\GetReportingPeriodListResponse|bool
     */
    public function GetReportingPeriodList(\StructType\GetReportingPeriodList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReportingPeriodList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFileByID
     * Meta information extracted from the WSDL
     * - documentation: Метод получения файла с соответствующим ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFileByID $parameters
     * @return \StructType\GetFileByIDResponse|bool
     */
    public function GetFileByID(\StructType\GetFileByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFileByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCompanyProfile988Response|\StructType\GetCompanyProfileResponse|\StructType\GetCompanyProfileSF988Response|\StructType\GetCompanyProfileSFResponse|\StructType\GetFileByIDResponse|\StructType\GetHouseInfoResponse|\StructType\GetHouseListByPageResponse|\StructType\GetHouseListChangesResponse|\StructType\GetHouseListResponse|\StructType\GetHouseProfile988Response|\StructType\GetHouseProfileActualResponse|\StructType\GetHouseProfileResponse|\StructType\GetHouseProfileSF988Response|\StructType\GetHouseProfileSFActualResponse|\StructType\GetHouseProfileSFResponse|\StructType\GetOrganizationListChangesResponse|\StructType\GetReportingPeriodListResponse|\StructType\GetRequestListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
