<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseServiceReport StructType
 * @subpackage Structs
 */
class HouseServiceReport extends AbstractStructBase
{
    /**
     * The fact_cost_per_unit
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $fact_cost_per_unit;
    /**
     * The volumes
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseServiceReportVolume
     */
    public $volumes;
    /**
     * Constructor method for HouseServiceReport
     * @uses HouseServiceReport::setFact_cost_per_unit()
     * @uses HouseServiceReport::setVolumes()
     * @param float $fact_cost_per_unit
     * @param \ArrayType\ArrayOfHouseServiceReportVolume $volumes
     */
    public function __construct($fact_cost_per_unit = null, \ArrayType\ArrayOfHouseServiceReportVolume $volumes = null)
    {
        $this
            ->setFact_cost_per_unit($fact_cost_per_unit)
            ->setVolumes($volumes);
    }
    /**
     * Get fact_cost_per_unit value
     * @return float|null
     */
    public function getFact_cost_per_unit()
    {
        return $this->fact_cost_per_unit;
    }
    /**
     * Set fact_cost_per_unit value
     * @param float $fact_cost_per_unit
     * @return \StructType\HouseServiceReport
     */
    public function setFact_cost_per_unit($fact_cost_per_unit = null)
    {
        // validation for constraint: float
        if (!is_null($fact_cost_per_unit) && !(is_float($fact_cost_per_unit) || is_numeric($fact_cost_per_unit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fact_cost_per_unit, true), gettype($fact_cost_per_unit)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($fact_cost_per_unit) && mb_strlen(mb_substr($fact_cost_per_unit, mb_strpos($fact_cost_per_unit, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($fact_cost_per_unit, true), mb_strlen(mb_substr($fact_cost_per_unit, mb_strpos($fact_cost_per_unit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($fact_cost_per_unit) && mb_strlen(preg_replace('/(\D)/', '', $fact_cost_per_unit)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($fact_cost_per_unit, true), mb_strlen(preg_replace('/(\D)/', '', $fact_cost_per_unit))), __LINE__);
        }
        $this->fact_cost_per_unit = $fact_cost_per_unit;
        return $this;
    }
    /**
     * Get volumes value
     * @return \ArrayType\ArrayOfHouseServiceReportVolume|null
     */
    public function getVolumes()
    {
        return $this->volumes;
    }
    /**
     * Set volumes value
     * @param \ArrayType\ArrayOfHouseServiceReportVolume $volumes
     * @return \StructType\HouseServiceReport
     */
    public function setVolumes(\ArrayType\ArrayOfHouseServiceReportVolume $volumes = null)
    {
        $this->volumes = $volumes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseServiceReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
