<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseManagementContract StructType
 * @subpackage Structs
 */
class HouseManagementContract extends AbstractStructBase
{
    /**
     * The date_start
     * @var string
     */
    public $date_start;
    /**
     * The management_reason
     * @var string
     */
    public $management_reason;
    /**
     * The confirm_method_document_name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $confirm_method_document_name;
    /**
     * The confirm_method_document_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $confirm_method_document_date;
    /**
     * The confirm_method_document_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $confirm_method_document_number;
    /**
     * The management_contract_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $management_contract_date;
    /**
     * The management_contract_files
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $management_contract_files;
    /**
     * Constructor method for HouseManagementContract
     * @uses HouseManagementContract::setDate_start()
     * @uses HouseManagementContract::setManagement_reason()
     * @uses HouseManagementContract::setConfirm_method_document_name()
     * @uses HouseManagementContract::setConfirm_method_document_date()
     * @uses HouseManagementContract::setConfirm_method_document_number()
     * @uses HouseManagementContract::setManagement_contract_date()
     * @uses HouseManagementContract::setManagement_contract_files()
     * @param string $date_start
     * @param string $management_reason
     * @param string $confirm_method_document_name
     * @param string $confirm_method_document_date
     * @param string $confirm_method_document_number
     * @param string $management_contract_date
     * @param \ArrayType\ArrayOfInt $management_contract_files
     */
    public function __construct($date_start = null, $management_reason = null, $confirm_method_document_name = null, $confirm_method_document_date = null, $confirm_method_document_number = null, $management_contract_date = null, \ArrayType\ArrayOfInt $management_contract_files = null)
    {
        $this
            ->setDate_start($date_start)
            ->setManagement_reason($management_reason)
            ->setConfirm_method_document_name($confirm_method_document_name)
            ->setConfirm_method_document_date($confirm_method_document_date)
            ->setConfirm_method_document_number($confirm_method_document_number)
            ->setManagement_contract_date($management_contract_date)
            ->setManagement_contract_files($management_contract_files);
    }
    /**
     * Get date_start value
     * @return string|null
     */
    public function getDate_start()
    {
        return $this->date_start;
    }
    /**
     * Set date_start value
     * @param string $date_start
     * @return \StructType\HouseManagementContract
     */
    public function setDate_start($date_start = null)
    {
        // validation for constraint: string
        if (!is_null($date_start) && !is_string($date_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_start, true), gettype($date_start)), __LINE__);
        }
        $this->date_start = $date_start;
        return $this;
    }
    /**
     * Get management_reason value
     * @return string|null
     */
    public function getManagement_reason()
    {
        return $this->management_reason;
    }
    /**
     * Set management_reason value
     * @param string $management_reason
     * @return \StructType\HouseManagementContract
     */
    public function setManagement_reason($management_reason = null)
    {
        // validation for constraint: string
        if (!is_null($management_reason) && !is_string($management_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($management_reason, true), gettype($management_reason)), __LINE__);
        }
        $this->management_reason = $management_reason;
        return $this;
    }
    /**
     * Get confirm_method_document_name value
     * @return string|null
     */
    public function getConfirm_method_document_name()
    {
        return $this->confirm_method_document_name;
    }
    /**
     * Set confirm_method_document_name value
     * @param string $confirm_method_document_name
     * @return \StructType\HouseManagementContract
     */
    public function setConfirm_method_document_name($confirm_method_document_name = null)
    {
        // validation for constraint: string
        if (!is_null($confirm_method_document_name) && !is_string($confirm_method_document_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirm_method_document_name, true), gettype($confirm_method_document_name)), __LINE__);
        }
        $this->confirm_method_document_name = $confirm_method_document_name;
        return $this;
    }
    /**
     * Get confirm_method_document_date value
     * @return string|null
     */
    public function getConfirm_method_document_date()
    {
        return $this->confirm_method_document_date;
    }
    /**
     * Set confirm_method_document_date value
     * @param string $confirm_method_document_date
     * @return \StructType\HouseManagementContract
     */
    public function setConfirm_method_document_date($confirm_method_document_date = null)
    {
        // validation for constraint: string
        if (!is_null($confirm_method_document_date) && !is_string($confirm_method_document_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirm_method_document_date, true), gettype($confirm_method_document_date)), __LINE__);
        }
        $this->confirm_method_document_date = $confirm_method_document_date;
        return $this;
    }
    /**
     * Get confirm_method_document_number value
     * @return string|null
     */
    public function getConfirm_method_document_number()
    {
        return $this->confirm_method_document_number;
    }
    /**
     * Set confirm_method_document_number value
     * @param string $confirm_method_document_number
     * @return \StructType\HouseManagementContract
     */
    public function setConfirm_method_document_number($confirm_method_document_number = null)
    {
        // validation for constraint: string
        if (!is_null($confirm_method_document_number) && !is_string($confirm_method_document_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirm_method_document_number, true), gettype($confirm_method_document_number)), __LINE__);
        }
        $this->confirm_method_document_number = $confirm_method_document_number;
        return $this;
    }
    /**
     * Get management_contract_date value
     * @return string|null
     */
    public function getManagement_contract_date()
    {
        return $this->management_contract_date;
    }
    /**
     * Set management_contract_date value
     * @param string $management_contract_date
     * @return \StructType\HouseManagementContract
     */
    public function setManagement_contract_date($management_contract_date = null)
    {
        // validation for constraint: string
        if (!is_null($management_contract_date) && !is_string($management_contract_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($management_contract_date, true), gettype($management_contract_date)), __LINE__);
        }
        $this->management_contract_date = $management_contract_date;
        return $this;
    }
    /**
     * Get management_contract_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getManagement_contract_files()
    {
        return $this->management_contract_files;
    }
    /**
     * Set management_contract_files value
     * @param \ArrayType\ArrayOfInt $management_contract_files
     * @return \StructType\HouseManagementContract
     */
    public function setManagement_contract_files(\ArrayType\ArrayOfInt $management_contract_files = null)
    {
        $this->management_contract_files = $management_contract_files;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseManagementContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
