<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseCommunalServiceCost StructType
 * @subpackage Structs
 */
class HouseCommunalServiceCost extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The tariff_start_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tariff_start_date;
    /**
     * The unit_of_measurement
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $unit_of_measurement;
    /**
     * The tariff
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $tariff;
    /**
     * Constructor method for HouseCommunalServiceCost
     * @uses HouseCommunalServiceCost::setId()
     * @uses HouseCommunalServiceCost::setTariff_start_date()
     * @uses HouseCommunalServiceCost::setUnit_of_measurement()
     * @uses HouseCommunalServiceCost::setTariff()
     * @param int $id
     * @param string $tariff_start_date
     * @param string $unit_of_measurement
     * @param float $tariff
     */
    public function __construct($id = null, $tariff_start_date = null, $unit_of_measurement = null, $tariff = null)
    {
        $this
            ->setId($id)
            ->setTariff_start_date($tariff_start_date)
            ->setUnit_of_measurement($unit_of_measurement)
            ->setTariff($tariff);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseCommunalServiceCost
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get tariff_start_date value
     * @return string|null
     */
    public function getTariff_start_date()
    {
        return $this->tariff_start_date;
    }
    /**
     * Set tariff_start_date value
     * @param string $tariff_start_date
     * @return \StructType\HouseCommunalServiceCost
     */
    public function setTariff_start_date($tariff_start_date = null)
    {
        // validation for constraint: string
        if (!is_null($tariff_start_date) && !is_string($tariff_start_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariff_start_date, true), gettype($tariff_start_date)), __LINE__);
        }
        $this->tariff_start_date = $tariff_start_date;
        return $this;
    }
    /**
     * Get unit_of_measurement value
     * @return string|null
     */
    public function getUnit_of_measurement()
    {
        return $this->unit_of_measurement;
    }
    /**
     * Set unit_of_measurement value
     * @uses \EnumType\UnitOfMeasureEnum::valueIsValid()
     * @uses \EnumType\UnitOfMeasureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit_of_measurement
     * @return \StructType\HouseCommunalServiceCost
     */
    public function setUnit_of_measurement($unit_of_measurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasureEnum::valueIsValid($unit_of_measurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UnitOfMeasureEnum', is_array($unit_of_measurement) ? implode(', ', $unit_of_measurement) : var_export($unit_of_measurement, true), implode(', ', \EnumType\UnitOfMeasureEnum::getValidValues())), __LINE__);
        }
        $this->unit_of_measurement = $unit_of_measurement;
        return $this;
    }
    /**
     * Get tariff value
     * @return float|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param float $tariff
     * @return \StructType\HouseCommunalServiceCost
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: float
        if (!is_null($tariff) && !(is_float($tariff) || is_numeric($tariff))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tariff, true), gettype($tariff)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($tariff) && mb_strlen(mb_substr($tariff, mb_strpos($tariff, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($tariff, true), mb_strlen(mb_substr($tariff, mb_strpos($tariff, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($tariff) && mb_strlen(preg_replace('/(\D)/', '', $tariff)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($tariff, true), mb_strlen(preg_replace('/(\D)/', '', $tariff))), __LINE__);
        }
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseCommunalServiceCost
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
