<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseProfileSFResponse StructType
 * @subpackage Structs
 */
class GetHouseProfileSFResponse extends AbstractStructBase
{
    /**
     * The data
     * @var \ArrayType\ArrayOfGetHouseProfileResponse
     */
    public $data;
    /**
     * The page_number
     * @var int
     */
    public $page_number;
    /**
     * The page_count
     * @var int
     */
    public $page_count;
    /**
     * The GetHouseProfileSFResult
     * @var \StructType\GetHouseProfileSFResponse
     */
    public $GetHouseProfileSFResult;
    /**
     * Constructor method for GetHouseProfileSFResponse
     * @uses GetHouseProfileSFResponse::setData()
     * @uses GetHouseProfileSFResponse::setPage_number()
     * @uses GetHouseProfileSFResponse::setPage_count()
     * @uses GetHouseProfileSFResponse::setGetHouseProfileSFResult()
     * @param \ArrayType\ArrayOfGetHouseProfileResponse $data
     * @param int $page_number
     * @param int $page_count
     * @param \StructType\GetHouseProfileSFResponse $getHouseProfileSFResult
     */
    public function __construct(\ArrayType\ArrayOfGetHouseProfileResponse $data = null, $page_number = null, $page_count = null, \StructType\GetHouseProfileSFResponse $getHouseProfileSFResult = null)
    {
        $this
            ->setData($data)
            ->setPage_number($page_number)
            ->setPage_count($page_count)
            ->setGetHouseProfileSFResult($getHouseProfileSFResult);
    }
    /**
     * Get data value
     * @return \ArrayType\ArrayOfGetHouseProfileResponse|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \ArrayType\ArrayOfGetHouseProfileResponse $data
     * @return \StructType\GetHouseProfileSFResponse
     */
    public function setData(\ArrayType\ArrayOfGetHouseProfileResponse $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Get page_number value
     * @return int|null
     */
    public function getPage_number()
    {
        return $this->page_number;
    }
    /**
     * Set page_number value
     * @param int $page_number
     * @return \StructType\GetHouseProfileSFResponse
     */
    public function setPage_number($page_number = null)
    {
        // validation for constraint: int
        if (!is_null($page_number) && !(is_int($page_number) || ctype_digit($page_number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_number, true), gettype($page_number)), __LINE__);
        }
        $this->page_number = $page_number;
        return $this;
    }
    /**
     * Get page_count value
     * @return int|null
     */
    public function getPage_count()
    {
        return $this->page_count;
    }
    /**
     * Set page_count value
     * @param int $page_count
     * @return \StructType\GetHouseProfileSFResponse
     */
    public function setPage_count($page_count = null)
    {
        // validation for constraint: int
        if (!is_null($page_count) && !(is_int($page_count) || ctype_digit($page_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_count, true), gettype($page_count)), __LINE__);
        }
        $this->page_count = $page_count;
        return $this;
    }
    /**
     * Get GetHouseProfileSFResult value
     * @return \StructType\GetHouseProfileSFResponse|null
     */
    public function getGetHouseProfileSFResult()
    {
        return $this->GetHouseProfileSFResult;
    }
    /**
     * Set GetHouseProfileSFResult value
     * @param \StructType\GetHouseProfileSFResponse $getHouseProfileSFResult
     * @return \StructType\GetHouseProfileSFResponse
     */
    public function setGetHouseProfileSFResult(\StructType\GetHouseProfileSFResponse $getHouseProfileSFResult = null)
    {
        $this->GetHouseProfileSFResult = $getHouseProfileSFResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHouseProfileSFResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
