<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCompanyProfile988Response StructType
 * @subpackage Structs
 */
class GetCompanyProfile988Response extends AbstractStructBase
{
    /**
     * The inn
     * @var string
     */
    public $inn;
    /**
     * The name_full
     * @var string
     */
    public $name_full;
    /**
     * The name_short
     * @var string
     */
    public $name_short;
    /**
     * The last_update
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_update;
    /**
     * The company_profile_data
     * @var \StructType\CompanyProfileData988
     */
    public $company_profile_data;
    /**
     * The under_management_houses_count
     * @var int
     */
    public $under_management_houses_count;
    /**
     * The under_management_houses_square
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $under_management_houses_square;
    /**
     * The files_info
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFileInfo
     */
    public $files_info;
    /**
     * The GetCompanyProfile988Result
     * @var \StructType\GetCompanyProfile988Response
     */
    public $GetCompanyProfile988Result;
    /**
     * Constructor method for GetCompanyProfile988Response
     * @uses GetCompanyProfile988Response::setInn()
     * @uses GetCompanyProfile988Response::setName_full()
     * @uses GetCompanyProfile988Response::setName_short()
     * @uses GetCompanyProfile988Response::setLast_update()
     * @uses GetCompanyProfile988Response::setCompany_profile_data()
     * @uses GetCompanyProfile988Response::setUnder_management_houses_count()
     * @uses GetCompanyProfile988Response::setUnder_management_houses_square()
     * @uses GetCompanyProfile988Response::setFiles_info()
     * @uses GetCompanyProfile988Response::setGetCompanyProfile988Result()
     * @param string $inn
     * @param string $name_full
     * @param string $name_short
     * @param string $last_update
     * @param \StructType\CompanyProfileData988 $company_profile_data
     * @param int $under_management_houses_count
     * @param float $under_management_houses_square
     * @param \ArrayType\ArrayOfFileInfo $files_info
     * @param \StructType\GetCompanyProfile988Response $getCompanyProfile988Result
     */
    public function __construct($inn = null, $name_full = null, $name_short = null, $last_update = null, \StructType\CompanyProfileData988 $company_profile_data = null, $under_management_houses_count = null, $under_management_houses_square = null, \ArrayType\ArrayOfFileInfo $files_info = null, \StructType\GetCompanyProfile988Response $getCompanyProfile988Result = null)
    {
        $this
            ->setInn($inn)
            ->setName_full($name_full)
            ->setName_short($name_short)
            ->setLast_update($last_update)
            ->setCompany_profile_data($company_profile_data)
            ->setUnder_management_houses_count($under_management_houses_count)
            ->setUnder_management_houses_square($under_management_houses_square)
            ->setFiles_info($files_info)
            ->setGetCompanyProfile988Result($getCompanyProfile988Result);
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\GetCompanyProfile988Response
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get name_full value
     * @return string|null
     */
    public function getName_full()
    {
        return $this->name_full;
    }
    /**
     * Set name_full value
     * @param string $name_full
     * @return \StructType\GetCompanyProfile988Response
     */
    public function setName_full($name_full = null)
    {
        // validation for constraint: string
        if (!is_null($name_full) && !is_string($name_full)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name_full, true), gettype($name_full)), __LINE__);
        }
        $this->name_full = $name_full;
        return $this;
    }
    /**
     * Get name_short value
     * @return string|null
     */
    public function getName_short()
    {
        return $this->name_short;
    }
    /**
     * Set name_short value
     * @param string $name_short
     * @return \StructType\GetCompanyProfile988Response
     */
    public function setName_short($name_short = null)
    {
        // validation for constraint: string
        if (!is_null($name_short) && !is_string($name_short)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name_short, true), gettype($name_short)), __LINE__);
        }
        $this->name_short = $name_short;
        return $this;
    }
    /**
     * Get last_update value
     * @return string|null
     */
    public function getLast_update()
    {
        return $this->last_update;
    }
    /**
     * Set last_update value
     * @param string $last_update
     * @return \StructType\GetCompanyProfile988Response
     */
    public function setLast_update($last_update = null)
    {
        // validation for constraint: string
        if (!is_null($last_update) && !is_string($last_update)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_update, true), gettype($last_update)), __LINE__);
        }
        $this->last_update = $last_update;
        return $this;
    }
    /**
     * Get company_profile_data value
     * @return \StructType\CompanyProfileData988|null
     */
    public function getCompany_profile_data()
    {
        return $this->company_profile_data;
    }
    /**
     * Set company_profile_data value
     * @param \StructType\CompanyProfileData988 $company_profile_data
     * @return \StructType\GetCompanyProfile988Response
     */
    public function setCompany_profile_data(\StructType\CompanyProfileData988 $company_profile_data = null)
    {
        $this->company_profile_data = $company_profile_data;
        return $this;
    }
    /**
     * Get under_management_houses_count value
     * @return int|null
     */
    public function getUnder_management_houses_count()
    {
        return $this->under_management_houses_count;
    }
    /**
     * Set under_management_houses_count value
     * @param int $under_management_houses_count
     * @return \StructType\GetCompanyProfile988Response
     */
    public function setUnder_management_houses_count($under_management_houses_count = null)
    {
        // validation for constraint: int
        if (!is_null($under_management_houses_count) && !(is_int($under_management_houses_count) || ctype_digit($under_management_houses_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($under_management_houses_count, true), gettype($under_management_houses_count)), __LINE__);
        }
        $this->under_management_houses_count = $under_management_houses_count;
        return $this;
    }
    /**
     * Get under_management_houses_square value
     * @return float|null
     */
    public function getUnder_management_houses_square()
    {
        return $this->under_management_houses_square;
    }
    /**
     * Set under_management_houses_square value
     * @param float $under_management_houses_square
     * @return \StructType\GetCompanyProfile988Response
     */
    public function setUnder_management_houses_square($under_management_houses_square = null)
    {
        // validation for constraint: float
        if (!is_null($under_management_houses_square) && !(is_float($under_management_houses_square) || is_numeric($under_management_houses_square))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($under_management_houses_square, true), gettype($under_management_houses_square)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($under_management_houses_square) && mb_strlen(mb_substr($under_management_houses_square, mb_strpos($under_management_houses_square, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($under_management_houses_square, true), mb_strlen(mb_substr($under_management_houses_square, mb_strpos($under_management_houses_square, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($under_management_houses_square) && mb_strlen(preg_replace('/(\D)/', '', $under_management_houses_square)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($under_management_houses_square, true), mb_strlen(preg_replace('/(\D)/', '', $under_management_houses_square))), __LINE__);
        }
        $this->under_management_houses_square = $under_management_houses_square;
        return $this;
    }
    /**
     * Get files_info value
     * @return \ArrayType\ArrayOfFileInfo|null
     */
    public function getFiles_info()
    {
        return $this->files_info;
    }
    /**
     * Set files_info value
     * @param \ArrayType\ArrayOfFileInfo $files_info
     * @return \StructType\GetCompanyProfile988Response
     */
    public function setFiles_info(\ArrayType\ArrayOfFileInfo $files_info = null)
    {
        $this->files_info = $files_info;
        return $this;
    }
    /**
     * Get GetCompanyProfile988Result value
     * @return \StructType\GetCompanyProfile988Response|null
     */
    public function getGetCompanyProfile988Result()
    {
        return $this->GetCompanyProfile988Result;
    }
    /**
     * Set GetCompanyProfile988Result value
     * @param \StructType\GetCompanyProfile988Response $getCompanyProfile988Result
     * @return \StructType\GetCompanyProfile988Response
     */
    public function setGetCompanyProfile988Result(\StructType\GetCompanyProfile988Response $getCompanyProfile988Result = null)
    {
        $this->GetCompanyProfile988Result = $getCompanyProfile988Result;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCompanyProfile988Response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
