<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpendingRepairInvests StructType
 * @subpackage Structs
 */
class SpendingRepairInvests extends AbstractStructBase
{
    /**
     * The spending_repair_invests
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $spending_repair_invests;
    /**
     * The subsidy
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $subsidy;
    /**
     * The credits
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $credits;
    /**
     * The fin_lising
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $fin_lising;
    /**
     * The fin_service
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $fin_service;
    /**
     * The contributions_residents
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $contributions_residents;
    /**
     * The other_sources
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $other_sources;
    /**
     * Constructor method for SpendingRepairInvests
     * @uses SpendingRepairInvests::setSpending_repair_invests()
     * @uses SpendingRepairInvests::setSubsidy()
     * @uses SpendingRepairInvests::setCredits()
     * @uses SpendingRepairInvests::setFin_lising()
     * @uses SpendingRepairInvests::setFin_service()
     * @uses SpendingRepairInvests::setContributions_residents()
     * @uses SpendingRepairInvests::setOther_sources()
     * @param float $spending_repair_invests
     * @param float $subsidy
     * @param float $credits
     * @param float $fin_lising
     * @param float $fin_service
     * @param float $contributions_residents
     * @param float $other_sources
     */
    public function __construct($spending_repair_invests = null, $subsidy = null, $credits = null, $fin_lising = null, $fin_service = null, $contributions_residents = null, $other_sources = null)
    {
        $this
            ->setSpending_repair_invests($spending_repair_invests)
            ->setSubsidy($subsidy)
            ->setCredits($credits)
            ->setFin_lising($fin_lising)
            ->setFin_service($fin_service)
            ->setContributions_residents($contributions_residents)
            ->setOther_sources($other_sources);
    }
    /**
     * Get spending_repair_invests value
     * @return float|null
     */
    public function getSpending_repair_invests()
    {
        return $this->spending_repair_invests;
    }
    /**
     * Set spending_repair_invests value
     * @param float $spending_repair_invests
     * @return \StructType\SpendingRepairInvests
     */
    public function setSpending_repair_invests($spending_repair_invests = null)
    {
        // validation for constraint: float
        if (!is_null($spending_repair_invests) && !(is_float($spending_repair_invests) || is_numeric($spending_repair_invests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($spending_repair_invests, true), gettype($spending_repair_invests)), __LINE__);
        }
        $this->spending_repair_invests = $spending_repair_invests;
        return $this;
    }
    /**
     * Get subsidy value
     * @return float|null
     */
    public function getSubsidy()
    {
        return $this->subsidy;
    }
    /**
     * Set subsidy value
     * @param float $subsidy
     * @return \StructType\SpendingRepairInvests
     */
    public function setSubsidy($subsidy = null)
    {
        // validation for constraint: float
        if (!is_null($subsidy) && !(is_float($subsidy) || is_numeric($subsidy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subsidy, true), gettype($subsidy)), __LINE__);
        }
        $this->subsidy = $subsidy;
        return $this;
    }
    /**
     * Get credits value
     * @return float|null
     */
    public function getCredits()
    {
        return $this->credits;
    }
    /**
     * Set credits value
     * @param float $credits
     * @return \StructType\SpendingRepairInvests
     */
    public function setCredits($credits = null)
    {
        // validation for constraint: float
        if (!is_null($credits) && !(is_float($credits) || is_numeric($credits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credits, true), gettype($credits)), __LINE__);
        }
        $this->credits = $credits;
        return $this;
    }
    /**
     * Get fin_lising value
     * @return float|null
     */
    public function getFin_lising()
    {
        return $this->fin_lising;
    }
    /**
     * Set fin_lising value
     * @param float $fin_lising
     * @return \StructType\SpendingRepairInvests
     */
    public function setFin_lising($fin_lising = null)
    {
        // validation for constraint: float
        if (!is_null($fin_lising) && !(is_float($fin_lising) || is_numeric($fin_lising))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fin_lising, true), gettype($fin_lising)), __LINE__);
        }
        $this->fin_lising = $fin_lising;
        return $this;
    }
    /**
     * Get fin_service value
     * @return float|null
     */
    public function getFin_service()
    {
        return $this->fin_service;
    }
    /**
     * Set fin_service value
     * @param float $fin_service
     * @return \StructType\SpendingRepairInvests
     */
    public function setFin_service($fin_service = null)
    {
        // validation for constraint: float
        if (!is_null($fin_service) && !(is_float($fin_service) || is_numeric($fin_service))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fin_service, true), gettype($fin_service)), __LINE__);
        }
        $this->fin_service = $fin_service;
        return $this;
    }
    /**
     * Get contributions_residents value
     * @return float|null
     */
    public function getContributions_residents()
    {
        return $this->contributions_residents;
    }
    /**
     * Set contributions_residents value
     * @param float $contributions_residents
     * @return \StructType\SpendingRepairInvests
     */
    public function setContributions_residents($contributions_residents = null)
    {
        // validation for constraint: float
        if (!is_null($contributions_residents) && !(is_float($contributions_residents) || is_numeric($contributions_residents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contributions_residents, true), gettype($contributions_residents)), __LINE__);
        }
        $this->contributions_residents = $contributions_residents;
        return $this;
    }
    /**
     * Get other_sources value
     * @return float|null
     */
    public function getOther_sources()
    {
        return $this->other_sources;
    }
    /**
     * Set other_sources value
     * @param float $other_sources
     * @return \StructType\SpendingRepairInvests
     */
    public function setOther_sources($other_sources = null)
    {
        // validation for constraint: float
        if (!is_null($other_sources) && !(is_float($other_sources) || is_numeric($other_sources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($other_sources, true), gettype($other_sources)), __LINE__);
        }
        $this->other_sources = $other_sources;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpendingRepairInvests
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
