<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for License StructType
 * @subpackage Structs
 */
class License extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The license_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $license_number;
    /**
     * The license_receipt_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $license_receipt_date;
    /**
     * The license_issuing_authority
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $license_issuing_authority;
    /**
     * The license_document_file_id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $license_document_file_id;
    /**
     * Constructor method for License
     * @uses License::setId()
     * @uses License::setLicense_number()
     * @uses License::setLicense_receipt_date()
     * @uses License::setLicense_issuing_authority()
     * @uses License::setLicense_document_file_id()
     * @param int $id
     * @param string $license_number
     * @param string $license_receipt_date
     * @param string $license_issuing_authority
     * @param int $license_document_file_id
     */
    public function __construct($id = null, $license_number = null, $license_receipt_date = null, $license_issuing_authority = null, $license_document_file_id = null)
    {
        $this
            ->setId($id)
            ->setLicense_number($license_number)
            ->setLicense_receipt_date($license_receipt_date)
            ->setLicense_issuing_authority($license_issuing_authority)
            ->setLicense_document_file_id($license_document_file_id);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\License
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get license_number value
     * @return string|null
     */
    public function getLicense_number()
    {
        return $this->license_number;
    }
    /**
     * Set license_number value
     * @param string $license_number
     * @return \StructType\License
     */
    public function setLicense_number($license_number = null)
    {
        // validation for constraint: string
        if (!is_null($license_number) && !is_string($license_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($license_number, true), gettype($license_number)), __LINE__);
        }
        $this->license_number = $license_number;
        return $this;
    }
    /**
     * Get license_receipt_date value
     * @return string|null
     */
    public function getLicense_receipt_date()
    {
        return $this->license_receipt_date;
    }
    /**
     * Set license_receipt_date value
     * @param string $license_receipt_date
     * @return \StructType\License
     */
    public function setLicense_receipt_date($license_receipt_date = null)
    {
        // validation for constraint: string
        if (!is_null($license_receipt_date) && !is_string($license_receipt_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($license_receipt_date, true), gettype($license_receipt_date)), __LINE__);
        }
        $this->license_receipt_date = $license_receipt_date;
        return $this;
    }
    /**
     * Get license_issuing_authority value
     * @return string|null
     */
    public function getLicense_issuing_authority()
    {
        return $this->license_issuing_authority;
    }
    /**
     * Set license_issuing_authority value
     * @param string $license_issuing_authority
     * @return \StructType\License
     */
    public function setLicense_issuing_authority($license_issuing_authority = null)
    {
        // validation for constraint: string
        if (!is_null($license_issuing_authority) && !is_string($license_issuing_authority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($license_issuing_authority, true), gettype($license_issuing_authority)), __LINE__);
        }
        $this->license_issuing_authority = $license_issuing_authority;
        return $this;
    }
    /**
     * Get license_document_file_id value
     * @return int|null
     */
    public function getLicense_document_file_id()
    {
        return $this->license_document_file_id;
    }
    /**
     * Set license_document_file_id value
     * @param int $license_document_file_id
     * @return \StructType\License
     */
    public function setLicense_document_file_id($license_document_file_id = null)
    {
        // validation for constraint: int
        if (!is_null($license_document_file_id) && !(is_int($license_document_file_id) || ctype_digit($license_document_file_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($license_document_file_id, true), gettype($license_document_file_id)), __LINE__);
        }
        $this->license_document_file_id = $license_document_file_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\License
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
