<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseProfile StructType
 * @subpackage Structs
 */
class GetHouseProfile extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The reporting_period_id
     * @var int
     */
    public $reporting_period_id;
    /**
     * Constructor method for GetHouseProfile
     * @uses GetHouseProfile::setHouse_id()
     * @uses GetHouseProfile::setReporting_period_id()
     * @param int $house_id
     * @param int $reporting_period_id
     */
    public function __construct($house_id = null, $reporting_period_id = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setReporting_period_id($reporting_period_id);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\GetHouseProfile
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !(is_int($house_id) || ctype_digit($house_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($house_id, true), gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get reporting_period_id value
     * @return int|null
     */
    public function getReporting_period_id()
    {
        return $this->reporting_period_id;
    }
    /**
     * Set reporting_period_id value
     * @param int $reporting_period_id
     * @return \StructType\GetHouseProfile
     */
    public function setReporting_period_id($reporting_period_id = null)
    {
        // validation for constraint: int
        if (!is_null($reporting_period_id) && !(is_int($reporting_period_id) || ctype_digit($reporting_period_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reporting_period_id, true), gettype($reporting_period_id)), __LINE__);
        }
        $this->reporting_period_id = $reporting_period_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHouseProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
