<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestState StructType
 * @subpackage Structs
 */
class RequestState extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The inn
     * @var string
     */
    public $inn;
    /**
     * The create_date
     * @var string
     */
    public $create_date;
    /**
     * The update_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $update_date;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for RequestState
     * @uses RequestState::setId()
     * @uses RequestState::setInn()
     * @uses RequestState::setCreate_date()
     * @uses RequestState::setUpdate_date()
     * @uses RequestState::setStatus()
     * @param int $id
     * @param string $inn
     * @param string $create_date
     * @param string $update_date
     * @param string $status
     */
    public function __construct($id = null, $inn = null, $create_date = null, $update_date = null, $status = null)
    {
        $this
            ->setId($id)
            ->setInn($inn)
            ->setCreate_date($create_date)
            ->setUpdate_date($update_date)
            ->setStatus($status);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\RequestState
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\RequestState
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get create_date value
     * @return string|null
     */
    public function getCreate_date()
    {
        return $this->create_date;
    }
    /**
     * Set create_date value
     * @param string $create_date
     * @return \StructType\RequestState
     */
    public function setCreate_date($create_date = null)
    {
        // validation for constraint: string
        if (!is_null($create_date) && !is_string($create_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($create_date, true), gettype($create_date)), __LINE__);
        }
        $this->create_date = $create_date;
        return $this;
    }
    /**
     * Get update_date value
     * @return string|null
     */
    public function getUpdate_date()
    {
        return $this->update_date;
    }
    /**
     * Set update_date value
     * @param string $update_date
     * @return \StructType\RequestState
     */
    public function setUpdate_date($update_date = null)
    {
        // validation for constraint: string
        if (!is_null($update_date) && !is_string($update_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($update_date, true), gettype($update_date)), __LINE__);
        }
        $this->update_date = $update_date;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\RequestStatus::valueIsValid()
     * @uses \EnumType\RequestStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\RequestState
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RequestStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\RequestStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestState
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
