<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseProfileData988 StructType
 * @subpackage Structs
 */
class HouseProfileData988 extends AbstractStructBase
{
    /**
     * The area_total
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_total;
    /**
     * The area_residential
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_residential;
    /**
     * The area_non_residential
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_non_residential;
    /**
     * The area_common_property
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_common_property;
    /**
     * The is_alarm
     * @var bool
     */
    public $is_alarm;
    /**
     * The method_of_forming_overhaul_fund
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $method_of_forming_overhaul_fund;
    /**
     * The exploitation_start_year
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $exploitation_start_year;
    /**
     * The project_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $project_type;
    /**
     * The built_year
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $built_year;
    /**
     * The house_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $house_type;
    /**
     * The floor_count_min
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $floor_count_min;
    /**
     * The floor_count_max
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $floor_count_max;
    /**
     * The entrance_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $entrance_count;
    /**
     * The elevators_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $elevators_count;
    /**
     * The flats_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $flats_count;
    /**
     * The living_quarters_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $living_quarters_count;
    /**
     * The not_living_quarters_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $not_living_quarters_count;
    /**
     * The area_land
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_land;
    /**
     * The parking_square
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $parking_square;
    /**
     * The energy_efficiency
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $energy_efficiency;
    /**
     * The additional_info
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $additional_info;
    /**
     * The has_playground
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $has_playground;
    /**
     * The has_sportsground
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $has_sportsground;
    /**
     * The other_beautification
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $other_beautification;
    /**
     * The foundation_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $foundation_type;
    /**
     * The floor_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $floor_type;
    /**
     * The wall_material
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $wall_material;
    /**
     * The area_basement
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_basement;
    /**
     * The chute_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $chute_type;
    /**
     * The chute_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $chute_count;
    /**
     * The electrical_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $electrical_type;
    /**
     * The electrical_entries_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $electrical_entries_count;
    /**
     * The heating_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $heating_type;
    /**
     * The hot_water_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $hot_water_type;
    /**
     * The cold_water_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cold_water_type;
    /**
     * The sewerage_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sewerage_type;
    /**
     * The sewerage_cesspools_volume
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $sewerage_cesspools_volume;
    /**
     * The gas_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $gas_type;
    /**
     * The ventilation_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ventilation_type;
    /**
     * The firefighting_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $firefighting_type;
    /**
     * The drainage_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $drainage_type;
    /**
     * The cadastral_numbers
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseCadastralNumber
     */
    public $cadastral_numbers;
    /**
     * The facades
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseFacade
     */
    public $facades;
    /**
     * The roofs
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseRoof
     */
    public $roofs;
    /**
     * The additional_equipments
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseAdditionalEquipment
     */
    public $additional_equipments;
    /**
     * The metering_devices
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseMeteringDevice
     */
    public $metering_devices;
    /**
     * The lifts
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseLift
     */
    public $lifts;
    /**
     * The management_contract
     * @var \StructType\HouseManagementContract
     */
    public $management_contract;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseService
     */
    public $services;
    /**
     * The communal_services
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseCommunalService
     */
    public $communal_services;
    /**
     * The overhaul
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\HouseOverhaul
     */
    public $overhaul;
    /**
     * The common_meetings
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseCommonMeeting
     */
    public $common_meetings;
    /**
     * The common_properties
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseCommonProperty
     */
    public $common_properties;
    /**
     * The report
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\HouseReport
     */
    public $report;
    /**
     * The alarm_info
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\HouseAlarm
     */
    public $alarm_info;
    /**
     * Constructor method for HouseProfileData988
     * @uses HouseProfileData988::setArea_total()
     * @uses HouseProfileData988::setArea_residential()
     * @uses HouseProfileData988::setArea_non_residential()
     * @uses HouseProfileData988::setArea_common_property()
     * @uses HouseProfileData988::setIs_alarm()
     * @uses HouseProfileData988::setMethod_of_forming_overhaul_fund()
     * @uses HouseProfileData988::setExploitation_start_year()
     * @uses HouseProfileData988::setProject_type()
     * @uses HouseProfileData988::setBuilt_year()
     * @uses HouseProfileData988::setHouse_type()
     * @uses HouseProfileData988::setFloor_count_min()
     * @uses HouseProfileData988::setFloor_count_max()
     * @uses HouseProfileData988::setEntrance_count()
     * @uses HouseProfileData988::setElevators_count()
     * @uses HouseProfileData988::setFlats_count()
     * @uses HouseProfileData988::setLiving_quarters_count()
     * @uses HouseProfileData988::setNot_living_quarters_count()
     * @uses HouseProfileData988::setArea_land()
     * @uses HouseProfileData988::setParking_square()
     * @uses HouseProfileData988::setEnergy_efficiency()
     * @uses HouseProfileData988::setAdditional_info()
     * @uses HouseProfileData988::setHas_playground()
     * @uses HouseProfileData988::setHas_sportsground()
     * @uses HouseProfileData988::setOther_beautification()
     * @uses HouseProfileData988::setFoundation_type()
     * @uses HouseProfileData988::setFloor_type()
     * @uses HouseProfileData988::setWall_material()
     * @uses HouseProfileData988::setArea_basement()
     * @uses HouseProfileData988::setChute_type()
     * @uses HouseProfileData988::setChute_count()
     * @uses HouseProfileData988::setElectrical_type()
     * @uses HouseProfileData988::setElectrical_entries_count()
     * @uses HouseProfileData988::setHeating_type()
     * @uses HouseProfileData988::setHot_water_type()
     * @uses HouseProfileData988::setCold_water_type()
     * @uses HouseProfileData988::setSewerage_type()
     * @uses HouseProfileData988::setSewerage_cesspools_volume()
     * @uses HouseProfileData988::setGas_type()
     * @uses HouseProfileData988::setVentilation_type()
     * @uses HouseProfileData988::setFirefighting_type()
     * @uses HouseProfileData988::setDrainage_type()
     * @uses HouseProfileData988::setCadastral_numbers()
     * @uses HouseProfileData988::setFacades()
     * @uses HouseProfileData988::setRoofs()
     * @uses HouseProfileData988::setAdditional_equipments()
     * @uses HouseProfileData988::setMetering_devices()
     * @uses HouseProfileData988::setLifts()
     * @uses HouseProfileData988::setManagement_contract()
     * @uses HouseProfileData988::setServices()
     * @uses HouseProfileData988::setCommunal_services()
     * @uses HouseProfileData988::setOverhaul()
     * @uses HouseProfileData988::setCommon_meetings()
     * @uses HouseProfileData988::setCommon_properties()
     * @uses HouseProfileData988::setReport()
     * @uses HouseProfileData988::setAlarm_info()
     * @param float $area_total
     * @param float $area_residential
     * @param float $area_non_residential
     * @param float $area_common_property
     * @param bool $is_alarm
     * @param string $method_of_forming_overhaul_fund
     * @param int $exploitation_start_year
     * @param string $project_type
     * @param int $built_year
     * @param string $house_type
     * @param int $floor_count_min
     * @param int $floor_count_max
     * @param int $entrance_count
     * @param int $elevators_count
     * @param int $flats_count
     * @param int $living_quarters_count
     * @param int $not_living_quarters_count
     * @param float $area_land
     * @param float $parking_square
     * @param string $energy_efficiency
     * @param string $additional_info
     * @param bool $has_playground
     * @param bool $has_sportsground
     * @param string $other_beautification
     * @param string $foundation_type
     * @param string $floor_type
     * @param string $wall_material
     * @param float $area_basement
     * @param string $chute_type
     * @param int $chute_count
     * @param string $electrical_type
     * @param int $electrical_entries_count
     * @param string $heating_type
     * @param string $hot_water_type
     * @param string $cold_water_type
     * @param string $sewerage_type
     * @param float $sewerage_cesspools_volume
     * @param string $gas_type
     * @param string $ventilation_type
     * @param string $firefighting_type
     * @param string $drainage_type
     * @param \ArrayType\ArrayOfHouseCadastralNumber $cadastral_numbers
     * @param \ArrayType\ArrayOfHouseFacade $facades
     * @param \ArrayType\ArrayOfHouseRoof $roofs
     * @param \ArrayType\ArrayOfHouseAdditionalEquipment $additional_equipments
     * @param \ArrayType\ArrayOfHouseMeteringDevice $metering_devices
     * @param \ArrayType\ArrayOfHouseLift $lifts
     * @param \StructType\HouseManagementContract $management_contract
     * @param \ArrayType\ArrayOfHouseService $services
     * @param \ArrayType\ArrayOfHouseCommunalService $communal_services
     * @param \StructType\HouseOverhaul $overhaul
     * @param \ArrayType\ArrayOfHouseCommonMeeting $common_meetings
     * @param \ArrayType\ArrayOfHouseCommonProperty $common_properties
     * @param \StructType\HouseReport $report
     * @param \StructType\HouseAlarm $alarm_info
     */
    public function __construct($area_total = null, $area_residential = null, $area_non_residential = null, $area_common_property = null, $is_alarm = null, $method_of_forming_overhaul_fund = null, $exploitation_start_year = null, $project_type = null, $built_year = null, $house_type = null, $floor_count_min = null, $floor_count_max = null, $entrance_count = null, $elevators_count = null, $flats_count = null, $living_quarters_count = null, $not_living_quarters_count = null, $area_land = null, $parking_square = null, $energy_efficiency = null, $additional_info = null, $has_playground = null, $has_sportsground = null, $other_beautification = null, $foundation_type = null, $floor_type = null, $wall_material = null, $area_basement = null, $chute_type = null, $chute_count = null, $electrical_type = null, $electrical_entries_count = null, $heating_type = null, $hot_water_type = null, $cold_water_type = null, $sewerage_type = null, $sewerage_cesspools_volume = null, $gas_type = null, $ventilation_type = null, $firefighting_type = null, $drainage_type = null, \ArrayType\ArrayOfHouseCadastralNumber $cadastral_numbers = null, \ArrayType\ArrayOfHouseFacade $facades = null, \ArrayType\ArrayOfHouseRoof $roofs = null, \ArrayType\ArrayOfHouseAdditionalEquipment $additional_equipments = null, \ArrayType\ArrayOfHouseMeteringDevice $metering_devices = null, \ArrayType\ArrayOfHouseLift $lifts = null, \StructType\HouseManagementContract $management_contract = null, \ArrayType\ArrayOfHouseService $services = null, \ArrayType\ArrayOfHouseCommunalService $communal_services = null, \StructType\HouseOverhaul $overhaul = null, \ArrayType\ArrayOfHouseCommonMeeting $common_meetings = null, \ArrayType\ArrayOfHouseCommonProperty $common_properties = null, \StructType\HouseReport $report = null, \StructType\HouseAlarm $alarm_info = null)
    {
        $this
            ->setArea_total($area_total)
            ->setArea_residential($area_residential)
            ->setArea_non_residential($area_non_residential)
            ->setArea_common_property($area_common_property)
            ->setIs_alarm($is_alarm)
            ->setMethod_of_forming_overhaul_fund($method_of_forming_overhaul_fund)
            ->setExploitation_start_year($exploitation_start_year)
            ->setProject_type($project_type)
            ->setBuilt_year($built_year)
            ->setHouse_type($house_type)
            ->setFloor_count_min($floor_count_min)
            ->setFloor_count_max($floor_count_max)
            ->setEntrance_count($entrance_count)
            ->setElevators_count($elevators_count)
            ->setFlats_count($flats_count)
            ->setLiving_quarters_count($living_quarters_count)
            ->setNot_living_quarters_count($not_living_quarters_count)
            ->setArea_land($area_land)
            ->setParking_square($parking_square)
            ->setEnergy_efficiency($energy_efficiency)
            ->setAdditional_info($additional_info)
            ->setHas_playground($has_playground)
            ->setHas_sportsground($has_sportsground)
            ->setOther_beautification($other_beautification)
            ->setFoundation_type($foundation_type)
            ->setFloor_type($floor_type)
            ->setWall_material($wall_material)
            ->setArea_basement($area_basement)
            ->setChute_type($chute_type)
            ->setChute_count($chute_count)
            ->setElectrical_type($electrical_type)
            ->setElectrical_entries_count($electrical_entries_count)
            ->setHeating_type($heating_type)
            ->setHot_water_type($hot_water_type)
            ->setCold_water_type($cold_water_type)
            ->setSewerage_type($sewerage_type)
            ->setSewerage_cesspools_volume($sewerage_cesspools_volume)
            ->setGas_type($gas_type)
            ->setVentilation_type($ventilation_type)
            ->setFirefighting_type($firefighting_type)
            ->setDrainage_type($drainage_type)
            ->setCadastral_numbers($cadastral_numbers)
            ->setFacades($facades)
            ->setRoofs($roofs)
            ->setAdditional_equipments($additional_equipments)
            ->setMetering_devices($metering_devices)
            ->setLifts($lifts)
            ->setManagement_contract($management_contract)
            ->setServices($services)
            ->setCommunal_services($communal_services)
            ->setOverhaul($overhaul)
            ->setCommon_meetings($common_meetings)
            ->setCommon_properties($common_properties)
            ->setReport($report)
            ->setAlarm_info($alarm_info);
    }
    /**
     * Get area_total value
     * @return float|null
     */
    public function getArea_total()
    {
        return $this->area_total;
    }
    /**
     * Set area_total value
     * @param float $area_total
     * @return \StructType\HouseProfileData988
     */
    public function setArea_total($area_total = null)
    {
        // validation for constraint: float
        if (!is_null($area_total) && !(is_float($area_total) || is_numeric($area_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_total, true), gettype($area_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_total) && mb_strlen(mb_substr($area_total, mb_strpos($area_total, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_total, true), mb_strlen(mb_substr($area_total, mb_strpos($area_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_total) && mb_strlen(preg_replace('/(\D)/', '', $area_total)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_total, true), mb_strlen(preg_replace('/(\D)/', '', $area_total))), __LINE__);
        }
        $this->area_total = $area_total;
        return $this;
    }
    /**
     * Get area_residential value
     * @return float|null
     */
    public function getArea_residential()
    {
        return $this->area_residential;
    }
    /**
     * Set area_residential value
     * @param float $area_residential
     * @return \StructType\HouseProfileData988
     */
    public function setArea_residential($area_residential = null)
    {
        // validation for constraint: float
        if (!is_null($area_residential) && !(is_float($area_residential) || is_numeric($area_residential))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_residential, true), gettype($area_residential)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_residential) && mb_strlen(mb_substr($area_residential, mb_strpos($area_residential, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_residential, true), mb_strlen(mb_substr($area_residential, mb_strpos($area_residential, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_residential) && mb_strlen(preg_replace('/(\D)/', '', $area_residential)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_residential, true), mb_strlen(preg_replace('/(\D)/', '', $area_residential))), __LINE__);
        }
        $this->area_residential = $area_residential;
        return $this;
    }
    /**
     * Get area_non_residential value
     * @return float|null
     */
    public function getArea_non_residential()
    {
        return $this->area_non_residential;
    }
    /**
     * Set area_non_residential value
     * @param float $area_non_residential
     * @return \StructType\HouseProfileData988
     */
    public function setArea_non_residential($area_non_residential = null)
    {
        // validation for constraint: float
        if (!is_null($area_non_residential) && !(is_float($area_non_residential) || is_numeric($area_non_residential))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_non_residential, true), gettype($area_non_residential)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_non_residential) && mb_strlen(mb_substr($area_non_residential, mb_strpos($area_non_residential, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_non_residential, true), mb_strlen(mb_substr($area_non_residential, mb_strpos($area_non_residential, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_non_residential) && mb_strlen(preg_replace('/(\D)/', '', $area_non_residential)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_non_residential, true), mb_strlen(preg_replace('/(\D)/', '', $area_non_residential))), __LINE__);
        }
        $this->area_non_residential = $area_non_residential;
        return $this;
    }
    /**
     * Get area_common_property value
     * @return float|null
     */
    public function getArea_common_property()
    {
        return $this->area_common_property;
    }
    /**
     * Set area_common_property value
     * @param float $area_common_property
     * @return \StructType\HouseProfileData988
     */
    public function setArea_common_property($area_common_property = null)
    {
        // validation for constraint: float
        if (!is_null($area_common_property) && !(is_float($area_common_property) || is_numeric($area_common_property))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_common_property, true), gettype($area_common_property)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_common_property) && mb_strlen(mb_substr($area_common_property, mb_strpos($area_common_property, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_common_property, true), mb_strlen(mb_substr($area_common_property, mb_strpos($area_common_property, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_common_property) && mb_strlen(preg_replace('/(\D)/', '', $area_common_property)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_common_property, true), mb_strlen(preg_replace('/(\D)/', '', $area_common_property))), __LINE__);
        }
        $this->area_common_property = $area_common_property;
        return $this;
    }
    /**
     * Get is_alarm value
     * @return bool|null
     */
    public function getIs_alarm()
    {
        return $this->is_alarm;
    }
    /**
     * Set is_alarm value
     * @param bool $is_alarm
     * @return \StructType\HouseProfileData988
     */
    public function setIs_alarm($is_alarm = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_alarm) && !is_bool($is_alarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_alarm, true), gettype($is_alarm)), __LINE__);
        }
        $this->is_alarm = $is_alarm;
        return $this;
    }
    /**
     * Get method_of_forming_overhaul_fund value
     * @return string|null
     */
    public function getMethod_of_forming_overhaul_fund()
    {
        return $this->method_of_forming_overhaul_fund;
    }
    /**
     * Set method_of_forming_overhaul_fund value
     * @uses \EnumType\FormingOverhaulFundEnum::valueIsValid()
     * @uses \EnumType\FormingOverhaulFundEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $method_of_forming_overhaul_fund
     * @return \StructType\HouseProfileData988
     */
    public function setMethod_of_forming_overhaul_fund($method_of_forming_overhaul_fund = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormingOverhaulFundEnum::valueIsValid($method_of_forming_overhaul_fund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FormingOverhaulFundEnum', is_array($method_of_forming_overhaul_fund) ? implode(', ', $method_of_forming_overhaul_fund) : var_export($method_of_forming_overhaul_fund, true), implode(', ', \EnumType\FormingOverhaulFundEnum::getValidValues())), __LINE__);
        }
        $this->method_of_forming_overhaul_fund = $method_of_forming_overhaul_fund;
        return $this;
    }
    /**
     * Get exploitation_start_year value
     * @return int|null
     */
    public function getExploitation_start_year()
    {
        return $this->exploitation_start_year;
    }
    /**
     * Set exploitation_start_year value
     * @param int $exploitation_start_year
     * @return \StructType\HouseProfileData988
     */
    public function setExploitation_start_year($exploitation_start_year = null)
    {
        // validation for constraint: int
        if (!is_null($exploitation_start_year) && !(is_int($exploitation_start_year) || ctype_digit($exploitation_start_year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exploitation_start_year, true), gettype($exploitation_start_year)), __LINE__);
        }
        $this->exploitation_start_year = $exploitation_start_year;
        return $this;
    }
    /**
     * Get project_type value
     * @return string|null
     */
    public function getProject_type()
    {
        return $this->project_type;
    }
    /**
     * Set project_type value
     * @param string $project_type
     * @return \StructType\HouseProfileData988
     */
    public function setProject_type($project_type = null)
    {
        // validation for constraint: string
        if (!is_null($project_type) && !is_string($project_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_type, true), gettype($project_type)), __LINE__);
        }
        $this->project_type = $project_type;
        return $this;
    }
    /**
     * Get built_year value
     * @return int|null
     */
    public function getBuilt_year()
    {
        return $this->built_year;
    }
    /**
     * Set built_year value
     * @param int $built_year
     * @return \StructType\HouseProfileData988
     */
    public function setBuilt_year($built_year = null)
    {
        // validation for constraint: int
        if (!is_null($built_year) && !(is_int($built_year) || ctype_digit($built_year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($built_year, true), gettype($built_year)), __LINE__);
        }
        $this->built_year = $built_year;
        return $this;
    }
    /**
     * Get house_type value
     * @return string|null
     */
    public function getHouse_type()
    {
        return $this->house_type;
    }
    /**
     * Set house_type value
     * @uses \EnumType\HouseType988Enum::valueIsValid()
     * @uses \EnumType\HouseType988Enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $house_type
     * @return \StructType\HouseProfileData988
     */
    public function setHouse_type($house_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseType988Enum::valueIsValid($house_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseType988Enum', is_array($house_type) ? implode(', ', $house_type) : var_export($house_type, true), implode(', ', \EnumType\HouseType988Enum::getValidValues())), __LINE__);
        }
        $this->house_type = $house_type;
        return $this;
    }
    /**
     * Get floor_count_min value
     * @return int|null
     */
    public function getFloor_count_min()
    {
        return $this->floor_count_min;
    }
    /**
     * Set floor_count_min value
     * @param int $floor_count_min
     * @return \StructType\HouseProfileData988
     */
    public function setFloor_count_min($floor_count_min = null)
    {
        // validation for constraint: int
        if (!is_null($floor_count_min) && !(is_int($floor_count_min) || ctype_digit($floor_count_min))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($floor_count_min, true), gettype($floor_count_min)), __LINE__);
        }
        $this->floor_count_min = $floor_count_min;
        return $this;
    }
    /**
     * Get floor_count_max value
     * @return int|null
     */
    public function getFloor_count_max()
    {
        return $this->floor_count_max;
    }
    /**
     * Set floor_count_max value
     * @param int $floor_count_max
     * @return \StructType\HouseProfileData988
     */
    public function setFloor_count_max($floor_count_max = null)
    {
        // validation for constraint: int
        if (!is_null($floor_count_max) && !(is_int($floor_count_max) || ctype_digit($floor_count_max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($floor_count_max, true), gettype($floor_count_max)), __LINE__);
        }
        $this->floor_count_max = $floor_count_max;
        return $this;
    }
    /**
     * Get entrance_count value
     * @return int|null
     */
    public function getEntrance_count()
    {
        return $this->entrance_count;
    }
    /**
     * Set entrance_count value
     * @param int $entrance_count
     * @return \StructType\HouseProfileData988
     */
    public function setEntrance_count($entrance_count = null)
    {
        // validation for constraint: int
        if (!is_null($entrance_count) && !(is_int($entrance_count) || ctype_digit($entrance_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entrance_count, true), gettype($entrance_count)), __LINE__);
        }
        $this->entrance_count = $entrance_count;
        return $this;
    }
    /**
     * Get elevators_count value
     * @return int|null
     */
    public function getElevators_count()
    {
        return $this->elevators_count;
    }
    /**
     * Set elevators_count value
     * @param int $elevators_count
     * @return \StructType\HouseProfileData988
     */
    public function setElevators_count($elevators_count = null)
    {
        // validation for constraint: int
        if (!is_null($elevators_count) && !(is_int($elevators_count) || ctype_digit($elevators_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($elevators_count, true), gettype($elevators_count)), __LINE__);
        }
        $this->elevators_count = $elevators_count;
        return $this;
    }
    /**
     * Get flats_count value
     * @return int|null
     */
    public function getFlats_count()
    {
        return $this->flats_count;
    }
    /**
     * Set flats_count value
     * @param int $flats_count
     * @return \StructType\HouseProfileData988
     */
    public function setFlats_count($flats_count = null)
    {
        // validation for constraint: int
        if (!is_null($flats_count) && !(is_int($flats_count) || ctype_digit($flats_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flats_count, true), gettype($flats_count)), __LINE__);
        }
        $this->flats_count = $flats_count;
        return $this;
    }
    /**
     * Get living_quarters_count value
     * @return int|null
     */
    public function getLiving_quarters_count()
    {
        return $this->living_quarters_count;
    }
    /**
     * Set living_quarters_count value
     * @param int $living_quarters_count
     * @return \StructType\HouseProfileData988
     */
    public function setLiving_quarters_count($living_quarters_count = null)
    {
        // validation for constraint: int
        if (!is_null($living_quarters_count) && !(is_int($living_quarters_count) || ctype_digit($living_quarters_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($living_quarters_count, true), gettype($living_quarters_count)), __LINE__);
        }
        $this->living_quarters_count = $living_quarters_count;
        return $this;
    }
    /**
     * Get not_living_quarters_count value
     * @return int|null
     */
    public function getNot_living_quarters_count()
    {
        return $this->not_living_quarters_count;
    }
    /**
     * Set not_living_quarters_count value
     * @param int $not_living_quarters_count
     * @return \StructType\HouseProfileData988
     */
    public function setNot_living_quarters_count($not_living_quarters_count = null)
    {
        // validation for constraint: int
        if (!is_null($not_living_quarters_count) && !(is_int($not_living_quarters_count) || ctype_digit($not_living_quarters_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($not_living_quarters_count, true), gettype($not_living_quarters_count)), __LINE__);
        }
        $this->not_living_quarters_count = $not_living_quarters_count;
        return $this;
    }
    /**
     * Get area_land value
     * @return float|null
     */
    public function getArea_land()
    {
        return $this->area_land;
    }
    /**
     * Set area_land value
     * @param float $area_land
     * @return \StructType\HouseProfileData988
     */
    public function setArea_land($area_land = null)
    {
        // validation for constraint: float
        if (!is_null($area_land) && !(is_float($area_land) || is_numeric($area_land))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_land, true), gettype($area_land)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_land) && mb_strlen(mb_substr($area_land, mb_strpos($area_land, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_land, true), mb_strlen(mb_substr($area_land, mb_strpos($area_land, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_land) && mb_strlen(preg_replace('/(\D)/', '', $area_land)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_land, true), mb_strlen(preg_replace('/(\D)/', '', $area_land))), __LINE__);
        }
        $this->area_land = $area_land;
        return $this;
    }
    /**
     * Get parking_square value
     * @return float|null
     */
    public function getParking_square()
    {
        return $this->parking_square;
    }
    /**
     * Set parking_square value
     * @param float $parking_square
     * @return \StructType\HouseProfileData988
     */
    public function setParking_square($parking_square = null)
    {
        // validation for constraint: float
        if (!is_null($parking_square) && !(is_float($parking_square) || is_numeric($parking_square))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($parking_square, true), gettype($parking_square)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($parking_square) && mb_strlen(mb_substr($parking_square, mb_strpos($parking_square, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($parking_square, true), mb_strlen(mb_substr($parking_square, mb_strpos($parking_square, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($parking_square) && mb_strlen(preg_replace('/(\D)/', '', $parking_square)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($parking_square, true), mb_strlen(preg_replace('/(\D)/', '', $parking_square))), __LINE__);
        }
        $this->parking_square = $parking_square;
        return $this;
    }
    /**
     * Get energy_efficiency value
     * @return string|null
     */
    public function getEnergy_efficiency()
    {
        return $this->energy_efficiency;
    }
    /**
     * Set energy_efficiency value
     * @uses \EnumType\HouseEnergyEfficiencyClass988Enum::valueIsValid()
     * @uses \EnumType\HouseEnergyEfficiencyClass988Enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $energy_efficiency
     * @return \StructType\HouseProfileData988
     */
    public function setEnergy_efficiency($energy_efficiency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseEnergyEfficiencyClass988Enum::valueIsValid($energy_efficiency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseEnergyEfficiencyClass988Enum', is_array($energy_efficiency) ? implode(', ', $energy_efficiency) : var_export($energy_efficiency, true), implode(', ', \EnumType\HouseEnergyEfficiencyClass988Enum::getValidValues())), __LINE__);
        }
        $this->energy_efficiency = $energy_efficiency;
        return $this;
    }
    /**
     * Get additional_info value
     * @return string|null
     */
    public function getAdditional_info()
    {
        return $this->additional_info;
    }
    /**
     * Set additional_info value
     * @param string $additional_info
     * @return \StructType\HouseProfileData988
     */
    public function setAdditional_info($additional_info = null)
    {
        // validation for constraint: string
        if (!is_null($additional_info) && !is_string($additional_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_info, true), gettype($additional_info)), __LINE__);
        }
        $this->additional_info = $additional_info;
        return $this;
    }
    /**
     * Get has_playground value
     * @return bool|null
     */
    public function getHas_playground()
    {
        return $this->has_playground;
    }
    /**
     * Set has_playground value
     * @param bool $has_playground
     * @return \StructType\HouseProfileData988
     */
    public function setHas_playground($has_playground = null)
    {
        // validation for constraint: boolean
        if (!is_null($has_playground) && !is_bool($has_playground)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($has_playground, true), gettype($has_playground)), __LINE__);
        }
        $this->has_playground = $has_playground;
        return $this;
    }
    /**
     * Get has_sportsground value
     * @return bool|null
     */
    public function getHas_sportsground()
    {
        return $this->has_sportsground;
    }
    /**
     * Set has_sportsground value
     * @param bool $has_sportsground
     * @return \StructType\HouseProfileData988
     */
    public function setHas_sportsground($has_sportsground = null)
    {
        // validation for constraint: boolean
        if (!is_null($has_sportsground) && !is_bool($has_sportsground)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($has_sportsground, true), gettype($has_sportsground)), __LINE__);
        }
        $this->has_sportsground = $has_sportsground;
        return $this;
    }
    /**
     * Get other_beautification value
     * @return string|null
     */
    public function getOther_beautification()
    {
        return $this->other_beautification;
    }
    /**
     * Set other_beautification value
     * @param string $other_beautification
     * @return \StructType\HouseProfileData988
     */
    public function setOther_beautification($other_beautification = null)
    {
        // validation for constraint: string
        if (!is_null($other_beautification) && !is_string($other_beautification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($other_beautification, true), gettype($other_beautification)), __LINE__);
        }
        $this->other_beautification = $other_beautification;
        return $this;
    }
    /**
     * Get foundation_type value
     * @return string|null
     */
    public function getFoundation_type()
    {
        return $this->foundation_type;
    }
    /**
     * Set foundation_type value
     * @uses \EnumType\HouseFoundationTypeEnum::valueIsValid()
     * @uses \EnumType\HouseFoundationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $foundation_type
     * @return \StructType\HouseProfileData988
     */
    public function setFoundation_type($foundation_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseFoundationTypeEnum::valueIsValid($foundation_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseFoundationTypeEnum', is_array($foundation_type) ? implode(', ', $foundation_type) : var_export($foundation_type, true), implode(', ', \EnumType\HouseFoundationTypeEnum::getValidValues())), __LINE__);
        }
        $this->foundation_type = $foundation_type;
        return $this;
    }
    /**
     * Get floor_type value
     * @return string|null
     */
    public function getFloor_type()
    {
        return $this->floor_type;
    }
    /**
     * Set floor_type value
     * @uses \EnumType\HouseFloorType988Enum::valueIsValid()
     * @uses \EnumType\HouseFloorType988Enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $floor_type
     * @return \StructType\HouseProfileData988
     */
    public function setFloor_type($floor_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseFloorType988Enum::valueIsValid($floor_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseFloorType988Enum', is_array($floor_type) ? implode(', ', $floor_type) : var_export($floor_type, true), implode(', ', \EnumType\HouseFloorType988Enum::getValidValues())), __LINE__);
        }
        $this->floor_type = $floor_type;
        return $this;
    }
    /**
     * Get wall_material value
     * @return string|null
     */
    public function getWall_material()
    {
        return $this->wall_material;
    }
    /**
     * Set wall_material value
     * @uses \EnumType\HouseWallMaterial988Enum::valueIsValid()
     * @uses \EnumType\HouseWallMaterial988Enum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wall_material
     * @return \StructType\HouseProfileData988
     */
    public function setWall_material($wall_material = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseWallMaterial988Enum::valueIsValid($wall_material)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseWallMaterial988Enum', is_array($wall_material) ? implode(', ', $wall_material) : var_export($wall_material, true), implode(', ', \EnumType\HouseWallMaterial988Enum::getValidValues())), __LINE__);
        }
        $this->wall_material = $wall_material;
        return $this;
    }
    /**
     * Get area_basement value
     * @return float|null
     */
    public function getArea_basement()
    {
        return $this->area_basement;
    }
    /**
     * Set area_basement value
     * @param float $area_basement
     * @return \StructType\HouseProfileData988
     */
    public function setArea_basement($area_basement = null)
    {
        // validation for constraint: float
        if (!is_null($area_basement) && !(is_float($area_basement) || is_numeric($area_basement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_basement, true), gettype($area_basement)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_basement) && mb_strlen(mb_substr($area_basement, mb_strpos($area_basement, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_basement, true), mb_strlen(mb_substr($area_basement, mb_strpos($area_basement, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_basement) && mb_strlen(preg_replace('/(\D)/', '', $area_basement)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_basement, true), mb_strlen(preg_replace('/(\D)/', '', $area_basement))), __LINE__);
        }
        $this->area_basement = $area_basement;
        return $this;
    }
    /**
     * Get chute_type value
     * @return string|null
     */
    public function getChute_type()
    {
        return $this->chute_type;
    }
    /**
     * Set chute_type value
     * @uses \EnumType\HouseChuteTypeEnum::valueIsValid()
     * @uses \EnumType\HouseChuteTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chute_type
     * @return \StructType\HouseProfileData988
     */
    public function setChute_type($chute_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseChuteTypeEnum::valueIsValid($chute_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseChuteTypeEnum', is_array($chute_type) ? implode(', ', $chute_type) : var_export($chute_type, true), implode(', ', \EnumType\HouseChuteTypeEnum::getValidValues())), __LINE__);
        }
        $this->chute_type = $chute_type;
        return $this;
    }
    /**
     * Get chute_count value
     * @return int|null
     */
    public function getChute_count()
    {
        return $this->chute_count;
    }
    /**
     * Set chute_count value
     * @param int $chute_count
     * @return \StructType\HouseProfileData988
     */
    public function setChute_count($chute_count = null)
    {
        // validation for constraint: int
        if (!is_null($chute_count) && !(is_int($chute_count) || ctype_digit($chute_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chute_count, true), gettype($chute_count)), __LINE__);
        }
        $this->chute_count = $chute_count;
        return $this;
    }
    /**
     * Get electrical_type value
     * @return string|null
     */
    public function getElectrical_type()
    {
        return $this->electrical_type;
    }
    /**
     * Set electrical_type value
     * @uses \EnumType\HouseElectricalTypeEnum::valueIsValid()
     * @uses \EnumType\HouseElectricalTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $electrical_type
     * @return \StructType\HouseProfileData988
     */
    public function setElectrical_type($electrical_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseElectricalTypeEnum::valueIsValid($electrical_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseElectricalTypeEnum', is_array($electrical_type) ? implode(', ', $electrical_type) : var_export($electrical_type, true), implode(', ', \EnumType\HouseElectricalTypeEnum::getValidValues())), __LINE__);
        }
        $this->electrical_type = $electrical_type;
        return $this;
    }
    /**
     * Get electrical_entries_count value
     * @return int|null
     */
    public function getElectrical_entries_count()
    {
        return $this->electrical_entries_count;
    }
    /**
     * Set electrical_entries_count value
     * @param int $electrical_entries_count
     * @return \StructType\HouseProfileData988
     */
    public function setElectrical_entries_count($electrical_entries_count = null)
    {
        // validation for constraint: int
        if (!is_null($electrical_entries_count) && !(is_int($electrical_entries_count) || ctype_digit($electrical_entries_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($electrical_entries_count, true), gettype($electrical_entries_count)), __LINE__);
        }
        $this->electrical_entries_count = $electrical_entries_count;
        return $this;
    }
    /**
     * Get heating_type value
     * @return string|null
     */
    public function getHeating_type()
    {
        return $this->heating_type;
    }
    /**
     * Set heating_type value
     * @uses \EnumType\HouseHeatingTypeEnum::valueIsValid()
     * @uses \EnumType\HouseHeatingTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $heating_type
     * @return \StructType\HouseProfileData988
     */
    public function setHeating_type($heating_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseHeatingTypeEnum::valueIsValid($heating_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseHeatingTypeEnum', is_array($heating_type) ? implode(', ', $heating_type) : var_export($heating_type, true), implode(', ', \EnumType\HouseHeatingTypeEnum::getValidValues())), __LINE__);
        }
        $this->heating_type = $heating_type;
        return $this;
    }
    /**
     * Get hot_water_type value
     * @return string|null
     */
    public function getHot_water_type()
    {
        return $this->hot_water_type;
    }
    /**
     * Set hot_water_type value
     * @uses \EnumType\HouseHotWaterTypeEnum::valueIsValid()
     * @uses \EnumType\HouseHotWaterTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hot_water_type
     * @return \StructType\HouseProfileData988
     */
    public function setHot_water_type($hot_water_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseHotWaterTypeEnum::valueIsValid($hot_water_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseHotWaterTypeEnum', is_array($hot_water_type) ? implode(', ', $hot_water_type) : var_export($hot_water_type, true), implode(', ', \EnumType\HouseHotWaterTypeEnum::getValidValues())), __LINE__);
        }
        $this->hot_water_type = $hot_water_type;
        return $this;
    }
    /**
     * Get cold_water_type value
     * @return string|null
     */
    public function getCold_water_type()
    {
        return $this->cold_water_type;
    }
    /**
     * Set cold_water_type value
     * @uses \EnumType\HouseColdWaterTypeEnum::valueIsValid()
     * @uses \EnumType\HouseColdWaterTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cold_water_type
     * @return \StructType\HouseProfileData988
     */
    public function setCold_water_type($cold_water_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseColdWaterTypeEnum::valueIsValid($cold_water_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseColdWaterTypeEnum', is_array($cold_water_type) ? implode(', ', $cold_water_type) : var_export($cold_water_type, true), implode(', ', \EnumType\HouseColdWaterTypeEnum::getValidValues())), __LINE__);
        }
        $this->cold_water_type = $cold_water_type;
        return $this;
    }
    /**
     * Get sewerage_type value
     * @return string|null
     */
    public function getSewerage_type()
    {
        return $this->sewerage_type;
    }
    /**
     * Set sewerage_type value
     * @uses \EnumType\HouseSewerageTypeEnum::valueIsValid()
     * @uses \EnumType\HouseSewerageTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sewerage_type
     * @return \StructType\HouseProfileData988
     */
    public function setSewerage_type($sewerage_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseSewerageTypeEnum::valueIsValid($sewerage_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseSewerageTypeEnum', is_array($sewerage_type) ? implode(', ', $sewerage_type) : var_export($sewerage_type, true), implode(', ', \EnumType\HouseSewerageTypeEnum::getValidValues())), __LINE__);
        }
        $this->sewerage_type = $sewerage_type;
        return $this;
    }
    /**
     * Get sewerage_cesspools_volume value
     * @return float|null
     */
    public function getSewerage_cesspools_volume()
    {
        return $this->sewerage_cesspools_volume;
    }
    /**
     * Set sewerage_cesspools_volume value
     * @param float $sewerage_cesspools_volume
     * @return \StructType\HouseProfileData988
     */
    public function setSewerage_cesspools_volume($sewerage_cesspools_volume = null)
    {
        // validation for constraint: float
        if (!is_null($sewerage_cesspools_volume) && !(is_float($sewerage_cesspools_volume) || is_numeric($sewerage_cesspools_volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sewerage_cesspools_volume, true), gettype($sewerage_cesspools_volume)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($sewerage_cesspools_volume) && mb_strlen(mb_substr($sewerage_cesspools_volume, mb_strpos($sewerage_cesspools_volume, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($sewerage_cesspools_volume, true), mb_strlen(mb_substr($sewerage_cesspools_volume, mb_strpos($sewerage_cesspools_volume, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($sewerage_cesspools_volume) && mb_strlen(preg_replace('/(\D)/', '', $sewerage_cesspools_volume)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($sewerage_cesspools_volume, true), mb_strlen(preg_replace('/(\D)/', '', $sewerage_cesspools_volume))), __LINE__);
        }
        $this->sewerage_cesspools_volume = $sewerage_cesspools_volume;
        return $this;
    }
    /**
     * Get gas_type value
     * @return string|null
     */
    public function getGas_type()
    {
        return $this->gas_type;
    }
    /**
     * Set gas_type value
     * @uses \EnumType\HouseGasTypeEnum::valueIsValid()
     * @uses \EnumType\HouseGasTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gas_type
     * @return \StructType\HouseProfileData988
     */
    public function setGas_type($gas_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseGasTypeEnum::valueIsValid($gas_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseGasTypeEnum', is_array($gas_type) ? implode(', ', $gas_type) : var_export($gas_type, true), implode(', ', \EnumType\HouseGasTypeEnum::getValidValues())), __LINE__);
        }
        $this->gas_type = $gas_type;
        return $this;
    }
    /**
     * Get ventilation_type value
     * @return string|null
     */
    public function getVentilation_type()
    {
        return $this->ventilation_type;
    }
    /**
     * Set ventilation_type value
     * @uses \EnumType\HouseVentilationTypeEnum::valueIsValid()
     * @uses \EnumType\HouseVentilationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ventilation_type
     * @return \StructType\HouseProfileData988
     */
    public function setVentilation_type($ventilation_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseVentilationTypeEnum::valueIsValid($ventilation_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseVentilationTypeEnum', is_array($ventilation_type) ? implode(', ', $ventilation_type) : var_export($ventilation_type, true), implode(', ', \EnumType\HouseVentilationTypeEnum::getValidValues())), __LINE__);
        }
        $this->ventilation_type = $ventilation_type;
        return $this;
    }
    /**
     * Get firefighting_type value
     * @return string|null
     */
    public function getFirefighting_type()
    {
        return $this->firefighting_type;
    }
    /**
     * Set firefighting_type value
     * @uses \EnumType\HouseFirefightingTypeEnum::valueIsValid()
     * @uses \EnumType\HouseFirefightingTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firefighting_type
     * @return \StructType\HouseProfileData988
     */
    public function setFirefighting_type($firefighting_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseFirefightingTypeEnum::valueIsValid($firefighting_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseFirefightingTypeEnum', is_array($firefighting_type) ? implode(', ', $firefighting_type) : var_export($firefighting_type, true), implode(', ', \EnumType\HouseFirefightingTypeEnum::getValidValues())), __LINE__);
        }
        $this->firefighting_type = $firefighting_type;
        return $this;
    }
    /**
     * Get drainage_type value
     * @return string|null
     */
    public function getDrainage_type()
    {
        return $this->drainage_type;
    }
    /**
     * Set drainage_type value
     * @uses \EnumType\HouseDrainageTypeEnum::valueIsValid()
     * @uses \EnumType\HouseDrainageTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $drainage_type
     * @return \StructType\HouseProfileData988
     */
    public function setDrainage_type($drainage_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseDrainageTypeEnum::valueIsValid($drainage_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseDrainageTypeEnum', is_array($drainage_type) ? implode(', ', $drainage_type) : var_export($drainage_type, true), implode(', ', \EnumType\HouseDrainageTypeEnum::getValidValues())), __LINE__);
        }
        $this->drainage_type = $drainage_type;
        return $this;
    }
    /**
     * Get cadastral_numbers value
     * @return \ArrayType\ArrayOfHouseCadastralNumber|null
     */
    public function getCadastral_numbers()
    {
        return $this->cadastral_numbers;
    }
    /**
     * Set cadastral_numbers value
     * @param \ArrayType\ArrayOfHouseCadastralNumber $cadastral_numbers
     * @return \StructType\HouseProfileData988
     */
    public function setCadastral_numbers(\ArrayType\ArrayOfHouseCadastralNumber $cadastral_numbers = null)
    {
        $this->cadastral_numbers = $cadastral_numbers;
        return $this;
    }
    /**
     * Get facades value
     * @return \ArrayType\ArrayOfHouseFacade|null
     */
    public function getFacades()
    {
        return $this->facades;
    }
    /**
     * Set facades value
     * @param \ArrayType\ArrayOfHouseFacade $facades
     * @return \StructType\HouseProfileData988
     */
    public function setFacades(\ArrayType\ArrayOfHouseFacade $facades = null)
    {
        $this->facades = $facades;
        return $this;
    }
    /**
     * Get roofs value
     * @return \ArrayType\ArrayOfHouseRoof|null
     */
    public function getRoofs()
    {
        return $this->roofs;
    }
    /**
     * Set roofs value
     * @param \ArrayType\ArrayOfHouseRoof $roofs
     * @return \StructType\HouseProfileData988
     */
    public function setRoofs(\ArrayType\ArrayOfHouseRoof $roofs = null)
    {
        $this->roofs = $roofs;
        return $this;
    }
    /**
     * Get additional_equipments value
     * @return \ArrayType\ArrayOfHouseAdditionalEquipment|null
     */
    public function getAdditional_equipments()
    {
        return $this->additional_equipments;
    }
    /**
     * Set additional_equipments value
     * @param \ArrayType\ArrayOfHouseAdditionalEquipment $additional_equipments
     * @return \StructType\HouseProfileData988
     */
    public function setAdditional_equipments(\ArrayType\ArrayOfHouseAdditionalEquipment $additional_equipments = null)
    {
        $this->additional_equipments = $additional_equipments;
        return $this;
    }
    /**
     * Get metering_devices value
     * @return \ArrayType\ArrayOfHouseMeteringDevice|null
     */
    public function getMetering_devices()
    {
        return $this->metering_devices;
    }
    /**
     * Set metering_devices value
     * @param \ArrayType\ArrayOfHouseMeteringDevice $metering_devices
     * @return \StructType\HouseProfileData988
     */
    public function setMetering_devices(\ArrayType\ArrayOfHouseMeteringDevice $metering_devices = null)
    {
        $this->metering_devices = $metering_devices;
        return $this;
    }
    /**
     * Get lifts value
     * @return \ArrayType\ArrayOfHouseLift|null
     */
    public function getLifts()
    {
        return $this->lifts;
    }
    /**
     * Set lifts value
     * @param \ArrayType\ArrayOfHouseLift $lifts
     * @return \StructType\HouseProfileData988
     */
    public function setLifts(\ArrayType\ArrayOfHouseLift $lifts = null)
    {
        $this->lifts = $lifts;
        return $this;
    }
    /**
     * Get management_contract value
     * @return \StructType\HouseManagementContract|null
     */
    public function getManagement_contract()
    {
        return $this->management_contract;
    }
    /**
     * Set management_contract value
     * @param \StructType\HouseManagementContract $management_contract
     * @return \StructType\HouseProfileData988
     */
    public function setManagement_contract(\StructType\HouseManagementContract $management_contract = null)
    {
        $this->management_contract = $management_contract;
        return $this;
    }
    /**
     * Get services value
     * @return \ArrayType\ArrayOfHouseService|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \ArrayType\ArrayOfHouseService $services
     * @return \StructType\HouseProfileData988
     */
    public function setServices(\ArrayType\ArrayOfHouseService $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get communal_services value
     * @return \ArrayType\ArrayOfHouseCommunalService|null
     */
    public function getCommunal_services()
    {
        return $this->communal_services;
    }
    /**
     * Set communal_services value
     * @param \ArrayType\ArrayOfHouseCommunalService $communal_services
     * @return \StructType\HouseProfileData988
     */
    public function setCommunal_services(\ArrayType\ArrayOfHouseCommunalService $communal_services = null)
    {
        $this->communal_services = $communal_services;
        return $this;
    }
    /**
     * Get overhaul value
     * @return \StructType\HouseOverhaul|null
     */
    public function getOverhaul()
    {
        return $this->overhaul;
    }
    /**
     * Set overhaul value
     * @param \StructType\HouseOverhaul $overhaul
     * @return \StructType\HouseProfileData988
     */
    public function setOverhaul(\StructType\HouseOverhaul $overhaul = null)
    {
        $this->overhaul = $overhaul;
        return $this;
    }
    /**
     * Get common_meetings value
     * @return \ArrayType\ArrayOfHouseCommonMeeting|null
     */
    public function getCommon_meetings()
    {
        return $this->common_meetings;
    }
    /**
     * Set common_meetings value
     * @param \ArrayType\ArrayOfHouseCommonMeeting $common_meetings
     * @return \StructType\HouseProfileData988
     */
    public function setCommon_meetings(\ArrayType\ArrayOfHouseCommonMeeting $common_meetings = null)
    {
        $this->common_meetings = $common_meetings;
        return $this;
    }
    /**
     * Get common_properties value
     * @return \ArrayType\ArrayOfHouseCommonProperty|null
     */
    public function getCommon_properties()
    {
        return $this->common_properties;
    }
    /**
     * Set common_properties value
     * @param \ArrayType\ArrayOfHouseCommonProperty $common_properties
     * @return \StructType\HouseProfileData988
     */
    public function setCommon_properties(\ArrayType\ArrayOfHouseCommonProperty $common_properties = null)
    {
        $this->common_properties = $common_properties;
        return $this;
    }
    /**
     * Get report value
     * @return \StructType\HouseReport|null
     */
    public function getReport()
    {
        return $this->report;
    }
    /**
     * Set report value
     * @param \StructType\HouseReport $report
     * @return \StructType\HouseProfileData988
     */
    public function setReport(\StructType\HouseReport $report = null)
    {
        $this->report = $report;
        return $this;
    }
    /**
     * Get alarm_info value
     * @return \StructType\HouseAlarm|null
     */
    public function getAlarm_info()
    {
        return $this->alarm_info;
    }
    /**
     * Set alarm_info value
     * @param \StructType\HouseAlarm $alarm_info
     * @return \StructType\HouseProfileData988
     */
    public function setAlarm_info(\StructType\HouseAlarm $alarm_info = null)
    {
        $this->alarm_info = $alarm_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseProfileData988
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
