<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Provider StructType
 * @subpackage Structs
 */
class Provider extends AbstractStructBase
{
    /**
     * The is_supported
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $is_supported;
    /**
     * The supplied_via_management_organization
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $supplied_via_management_organization;
    /**
     * The inn
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $inn;
    /**
     * The alias
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $alias;
    /**
     * The additional_info
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $additional_info;
    /**
     * Constructor method for Provider
     * @uses Provider::setIs_supported()
     * @uses Provider::setSupplied_via_management_organization()
     * @uses Provider::setInn()
     * @uses Provider::setAlias()
     * @uses Provider::setAdditional_info()
     * @param bool $is_supported
     * @param bool $supplied_via_management_organization
     * @param string $inn
     * @param string $alias
     * @param string $additional_info
     */
    public function __construct($is_supported = null, $supplied_via_management_organization = null, $inn = null, $alias = null, $additional_info = null)
    {
        $this
            ->setIs_supported($is_supported)
            ->setSupplied_via_management_organization($supplied_via_management_organization)
            ->setInn($inn)
            ->setAlias($alias)
            ->setAdditional_info($additional_info);
    }
    /**
     * Get is_supported value
     * @return bool|null
     */
    public function getIs_supported()
    {
        return $this->is_supported;
    }
    /**
     * Set is_supported value
     * @param bool $is_supported
     * @return \StructType\Provider
     */
    public function setIs_supported($is_supported = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_supported) && !is_bool($is_supported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_supported, true), gettype($is_supported)), __LINE__);
        }
        $this->is_supported = $is_supported;
        return $this;
    }
    /**
     * Get supplied_via_management_organization value
     * @return bool|null
     */
    public function getSupplied_via_management_organization()
    {
        return $this->supplied_via_management_organization;
    }
    /**
     * Set supplied_via_management_organization value
     * @param bool $supplied_via_management_organization
     * @return \StructType\Provider
     */
    public function setSupplied_via_management_organization($supplied_via_management_organization = null)
    {
        // validation for constraint: boolean
        if (!is_null($supplied_via_management_organization) && !is_bool($supplied_via_management_organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supplied_via_management_organization, true), gettype($supplied_via_management_organization)), __LINE__);
        }
        $this->supplied_via_management_organization = $supplied_via_management_organization;
        return $this;
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\Provider
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get alias value
     * @return string|null
     */
    public function getAlias()
    {
        return $this->alias;
    }
    /**
     * Set alias value
     * @param string $alias
     * @return \StructType\Provider
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alias, true), gettype($alias)), __LINE__);
        }
        $this->alias = $alias;
        return $this;
    }
    /**
     * Get additional_info value
     * @return string|null
     */
    public function getAdditional_info()
    {
        return $this->additional_info;
    }
    /**
     * Set additional_info value
     * @param string $additional_info
     * @return \StructType\Provider
     */
    public function setAdditional_info($additional_info = null)
    {
        // validation for constraint: string
        if (!is_null($additional_info) && !is_string($additional_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_info, true), gettype($additional_info)), __LINE__);
        }
        $this->additional_info = $additional_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Provider
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
