<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseReportCommon StructType
 * @subpackage Structs
 */
class HouseReportCommon extends AbstractStructBase
{
    /**
     * The cash_balance_beginning_period
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $cash_balance_beginning_period;
    /**
     * The cash_balance_beginning_period_consumers_overpayment
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $cash_balance_beginning_period_consumers_overpayment;
    /**
     * The cash_balance_beginning_period_consumers_arrears
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $cash_balance_beginning_period_consumers_arrears;
    /**
     * The charged_for_services
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $charged_for_services;
    /**
     * The charged_for_maintenance_of_house
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $charged_for_maintenance_of_house;
    /**
     * The charged_for_maintenance_work
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $charged_for_maintenance_work;
    /**
     * The charged_for_management_service
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $charged_for_management_service;
    /**
     * The received_cash
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $received_cash;
    /**
     * The received_cash_from_owners
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $received_cash_from_owners;
    /**
     * The received_target_payment_from_owners
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $received_target_payment_from_owners;
    /**
     * The received_subsidies
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $received_subsidies;
    /**
     * The received_from_use_of_common_property
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $received_from_use_of_common_property;
    /**
     * The received_from_other
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $received_from_other;
    /**
     * The cash_total
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $cash_total;
    /**
     * The cash_balance_ending_period
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $cash_balance_ending_period;
    /**
     * The cash_balance_ending_period_consumers_overpayment
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $cash_balance_ending_period_consumers_overpayment;
    /**
     * The cash_balance_ending_period_consumers_arrears
     * Meta informations extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $cash_balance_ending_period_consumers_arrears;
    /**
     * Constructor method for HouseReportCommon
     * @uses HouseReportCommon::setCash_balance_beginning_period()
     * @uses HouseReportCommon::setCash_balance_beginning_period_consumers_overpayment()
     * @uses HouseReportCommon::setCash_balance_beginning_period_consumers_arrears()
     * @uses HouseReportCommon::setCharged_for_services()
     * @uses HouseReportCommon::setCharged_for_maintenance_of_house()
     * @uses HouseReportCommon::setCharged_for_maintenance_work()
     * @uses HouseReportCommon::setCharged_for_management_service()
     * @uses HouseReportCommon::setReceived_cash()
     * @uses HouseReportCommon::setReceived_cash_from_owners()
     * @uses HouseReportCommon::setReceived_target_payment_from_owners()
     * @uses HouseReportCommon::setReceived_subsidies()
     * @uses HouseReportCommon::setReceived_from_use_of_common_property()
     * @uses HouseReportCommon::setReceived_from_other()
     * @uses HouseReportCommon::setCash_total()
     * @uses HouseReportCommon::setCash_balance_ending_period()
     * @uses HouseReportCommon::setCash_balance_ending_period_consumers_overpayment()
     * @uses HouseReportCommon::setCash_balance_ending_period_consumers_arrears()
     * @param float $cash_balance_beginning_period
     * @param float $cash_balance_beginning_period_consumers_overpayment
     * @param float $cash_balance_beginning_period_consumers_arrears
     * @param float $charged_for_services
     * @param float $charged_for_maintenance_of_house
     * @param float $charged_for_maintenance_work
     * @param float $charged_for_management_service
     * @param float $received_cash
     * @param float $received_cash_from_owners
     * @param float $received_target_payment_from_owners
     * @param float $received_subsidies
     * @param float $received_from_use_of_common_property
     * @param float $received_from_other
     * @param float $cash_total
     * @param float $cash_balance_ending_period
     * @param float $cash_balance_ending_period_consumers_overpayment
     * @param float $cash_balance_ending_period_consumers_arrears
     */
    public function __construct($cash_balance_beginning_period = null, $cash_balance_beginning_period_consumers_overpayment = null, $cash_balance_beginning_period_consumers_arrears = null, $charged_for_services = null, $charged_for_maintenance_of_house = null, $charged_for_maintenance_work = null, $charged_for_management_service = null, $received_cash = null, $received_cash_from_owners = null, $received_target_payment_from_owners = null, $received_subsidies = null, $received_from_use_of_common_property = null, $received_from_other = null, $cash_total = null, $cash_balance_ending_period = null, $cash_balance_ending_period_consumers_overpayment = null, $cash_balance_ending_period_consumers_arrears = null)
    {
        $this
            ->setCash_balance_beginning_period($cash_balance_beginning_period)
            ->setCash_balance_beginning_period_consumers_overpayment($cash_balance_beginning_period_consumers_overpayment)
            ->setCash_balance_beginning_period_consumers_arrears($cash_balance_beginning_period_consumers_arrears)
            ->setCharged_for_services($charged_for_services)
            ->setCharged_for_maintenance_of_house($charged_for_maintenance_of_house)
            ->setCharged_for_maintenance_work($charged_for_maintenance_work)
            ->setCharged_for_management_service($charged_for_management_service)
            ->setReceived_cash($received_cash)
            ->setReceived_cash_from_owners($received_cash_from_owners)
            ->setReceived_target_payment_from_owners($received_target_payment_from_owners)
            ->setReceived_subsidies($received_subsidies)
            ->setReceived_from_use_of_common_property($received_from_use_of_common_property)
            ->setReceived_from_other($received_from_other)
            ->setCash_total($cash_total)
            ->setCash_balance_ending_period($cash_balance_ending_period)
            ->setCash_balance_ending_period_consumers_overpayment($cash_balance_ending_period_consumers_overpayment)
            ->setCash_balance_ending_period_consumers_arrears($cash_balance_ending_period_consumers_arrears);
    }
    /**
     * Get cash_balance_beginning_period value
     * @return float|null
     */
    public function getCash_balance_beginning_period()
    {
        return $this->cash_balance_beginning_period;
    }
    /**
     * Set cash_balance_beginning_period value
     * @param float $cash_balance_beginning_period
     * @return \StructType\HouseReportCommon
     */
    public function setCash_balance_beginning_period($cash_balance_beginning_period = null)
    {
        // validation for constraint: float
        if (!is_null($cash_balance_beginning_period) && !(is_float($cash_balance_beginning_period) || is_numeric($cash_balance_beginning_period))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_balance_beginning_period, true), gettype($cash_balance_beginning_period)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($cash_balance_beginning_period) && mb_strlen(mb_substr($cash_balance_beginning_period, mb_strpos($cash_balance_beginning_period, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($cash_balance_beginning_period, true), mb_strlen(mb_substr($cash_balance_beginning_period, mb_strpos($cash_balance_beginning_period, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($cash_balance_beginning_period) && mb_strlen(preg_replace('/(\D)/', '', $cash_balance_beginning_period)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($cash_balance_beginning_period, true), mb_strlen(preg_replace('/(\D)/', '', $cash_balance_beginning_period))), __LINE__);
        }
        $this->cash_balance_beginning_period = $cash_balance_beginning_period;
        return $this;
    }
    /**
     * Get cash_balance_beginning_period_consumers_overpayment value
     * @return float|null
     */
    public function getCash_balance_beginning_period_consumers_overpayment()
    {
        return $this->cash_balance_beginning_period_consumers_overpayment;
    }
    /**
     * Set cash_balance_beginning_period_consumers_overpayment value
     * @param float $cash_balance_beginning_period_consumers_overpayment
     * @return \StructType\HouseReportCommon
     */
    public function setCash_balance_beginning_period_consumers_overpayment($cash_balance_beginning_period_consumers_overpayment = null)
    {
        // validation for constraint: float
        if (!is_null($cash_balance_beginning_period_consumers_overpayment) && !(is_float($cash_balance_beginning_period_consumers_overpayment) || is_numeric($cash_balance_beginning_period_consumers_overpayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_balance_beginning_period_consumers_overpayment, true), gettype($cash_balance_beginning_period_consumers_overpayment)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($cash_balance_beginning_period_consumers_overpayment) && mb_strlen(mb_substr($cash_balance_beginning_period_consumers_overpayment, mb_strpos($cash_balance_beginning_period_consumers_overpayment, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($cash_balance_beginning_period_consumers_overpayment, true), mb_strlen(mb_substr($cash_balance_beginning_period_consumers_overpayment, mb_strpos($cash_balance_beginning_period_consumers_overpayment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($cash_balance_beginning_period_consumers_overpayment) && mb_strlen(preg_replace('/(\D)/', '', $cash_balance_beginning_period_consumers_overpayment)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($cash_balance_beginning_period_consumers_overpayment, true), mb_strlen(preg_replace('/(\D)/', '', $cash_balance_beginning_period_consumers_overpayment))), __LINE__);
        }
        $this->cash_balance_beginning_period_consumers_overpayment = $cash_balance_beginning_period_consumers_overpayment;
        return $this;
    }
    /**
     * Get cash_balance_beginning_period_consumers_arrears value
     * @return float|null
     */
    public function getCash_balance_beginning_period_consumers_arrears()
    {
        return $this->cash_balance_beginning_period_consumers_arrears;
    }
    /**
     * Set cash_balance_beginning_period_consumers_arrears value
     * @param float $cash_balance_beginning_period_consumers_arrears
     * @return \StructType\HouseReportCommon
     */
    public function setCash_balance_beginning_period_consumers_arrears($cash_balance_beginning_period_consumers_arrears = null)
    {
        // validation for constraint: float
        if (!is_null($cash_balance_beginning_period_consumers_arrears) && !(is_float($cash_balance_beginning_period_consumers_arrears) || is_numeric($cash_balance_beginning_period_consumers_arrears))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_balance_beginning_period_consumers_arrears, true), gettype($cash_balance_beginning_period_consumers_arrears)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($cash_balance_beginning_period_consumers_arrears) && mb_strlen(mb_substr($cash_balance_beginning_period_consumers_arrears, mb_strpos($cash_balance_beginning_period_consumers_arrears, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($cash_balance_beginning_period_consumers_arrears, true), mb_strlen(mb_substr($cash_balance_beginning_period_consumers_arrears, mb_strpos($cash_balance_beginning_period_consumers_arrears, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($cash_balance_beginning_period_consumers_arrears) && mb_strlen(preg_replace('/(\D)/', '', $cash_balance_beginning_period_consumers_arrears)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($cash_balance_beginning_period_consumers_arrears, true), mb_strlen(preg_replace('/(\D)/', '', $cash_balance_beginning_period_consumers_arrears))), __LINE__);
        }
        $this->cash_balance_beginning_period_consumers_arrears = $cash_balance_beginning_period_consumers_arrears;
        return $this;
    }
    /**
     * Get charged_for_services value
     * @return float|null
     */
    public function getCharged_for_services()
    {
        return $this->charged_for_services;
    }
    /**
     * Set charged_for_services value
     * @param float $charged_for_services
     * @return \StructType\HouseReportCommon
     */
    public function setCharged_for_services($charged_for_services = null)
    {
        // validation for constraint: float
        if (!is_null($charged_for_services) && !(is_float($charged_for_services) || is_numeric($charged_for_services))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($charged_for_services, true), gettype($charged_for_services)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($charged_for_services) && mb_strlen(mb_substr($charged_for_services, mb_strpos($charged_for_services, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($charged_for_services, true), mb_strlen(mb_substr($charged_for_services, mb_strpos($charged_for_services, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($charged_for_services) && mb_strlen(preg_replace('/(\D)/', '', $charged_for_services)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($charged_for_services, true), mb_strlen(preg_replace('/(\D)/', '', $charged_for_services))), __LINE__);
        }
        $this->charged_for_services = $charged_for_services;
        return $this;
    }
    /**
     * Get charged_for_maintenance_of_house value
     * @return float|null
     */
    public function getCharged_for_maintenance_of_house()
    {
        return $this->charged_for_maintenance_of_house;
    }
    /**
     * Set charged_for_maintenance_of_house value
     * @param float $charged_for_maintenance_of_house
     * @return \StructType\HouseReportCommon
     */
    public function setCharged_for_maintenance_of_house($charged_for_maintenance_of_house = null)
    {
        // validation for constraint: float
        if (!is_null($charged_for_maintenance_of_house) && !(is_float($charged_for_maintenance_of_house) || is_numeric($charged_for_maintenance_of_house))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($charged_for_maintenance_of_house, true), gettype($charged_for_maintenance_of_house)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($charged_for_maintenance_of_house) && mb_strlen(mb_substr($charged_for_maintenance_of_house, mb_strpos($charged_for_maintenance_of_house, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($charged_for_maintenance_of_house, true), mb_strlen(mb_substr($charged_for_maintenance_of_house, mb_strpos($charged_for_maintenance_of_house, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($charged_for_maintenance_of_house) && mb_strlen(preg_replace('/(\D)/', '', $charged_for_maintenance_of_house)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($charged_for_maintenance_of_house, true), mb_strlen(preg_replace('/(\D)/', '', $charged_for_maintenance_of_house))), __LINE__);
        }
        $this->charged_for_maintenance_of_house = $charged_for_maintenance_of_house;
        return $this;
    }
    /**
     * Get charged_for_maintenance_work value
     * @return float|null
     */
    public function getCharged_for_maintenance_work()
    {
        return $this->charged_for_maintenance_work;
    }
    /**
     * Set charged_for_maintenance_work value
     * @param float $charged_for_maintenance_work
     * @return \StructType\HouseReportCommon
     */
    public function setCharged_for_maintenance_work($charged_for_maintenance_work = null)
    {
        // validation for constraint: float
        if (!is_null($charged_for_maintenance_work) && !(is_float($charged_for_maintenance_work) || is_numeric($charged_for_maintenance_work))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($charged_for_maintenance_work, true), gettype($charged_for_maintenance_work)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($charged_for_maintenance_work) && mb_strlen(mb_substr($charged_for_maintenance_work, mb_strpos($charged_for_maintenance_work, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($charged_for_maintenance_work, true), mb_strlen(mb_substr($charged_for_maintenance_work, mb_strpos($charged_for_maintenance_work, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($charged_for_maintenance_work) && mb_strlen(preg_replace('/(\D)/', '', $charged_for_maintenance_work)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($charged_for_maintenance_work, true), mb_strlen(preg_replace('/(\D)/', '', $charged_for_maintenance_work))), __LINE__);
        }
        $this->charged_for_maintenance_work = $charged_for_maintenance_work;
        return $this;
    }
    /**
     * Get charged_for_management_service value
     * @return float|null
     */
    public function getCharged_for_management_service()
    {
        return $this->charged_for_management_service;
    }
    /**
     * Set charged_for_management_service value
     * @param float $charged_for_management_service
     * @return \StructType\HouseReportCommon
     */
    public function setCharged_for_management_service($charged_for_management_service = null)
    {
        // validation for constraint: float
        if (!is_null($charged_for_management_service) && !(is_float($charged_for_management_service) || is_numeric($charged_for_management_service))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($charged_for_management_service, true), gettype($charged_for_management_service)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($charged_for_management_service) && mb_strlen(mb_substr($charged_for_management_service, mb_strpos($charged_for_management_service, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($charged_for_management_service, true), mb_strlen(mb_substr($charged_for_management_service, mb_strpos($charged_for_management_service, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($charged_for_management_service) && mb_strlen(preg_replace('/(\D)/', '', $charged_for_management_service)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($charged_for_management_service, true), mb_strlen(preg_replace('/(\D)/', '', $charged_for_management_service))), __LINE__);
        }
        $this->charged_for_management_service = $charged_for_management_service;
        return $this;
    }
    /**
     * Get received_cash value
     * @return float|null
     */
    public function getReceived_cash()
    {
        return $this->received_cash;
    }
    /**
     * Set received_cash value
     * @param float $received_cash
     * @return \StructType\HouseReportCommon
     */
    public function setReceived_cash($received_cash = null)
    {
        // validation for constraint: float
        if (!is_null($received_cash) && !(is_float($received_cash) || is_numeric($received_cash))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($received_cash, true), gettype($received_cash)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($received_cash) && mb_strlen(mb_substr($received_cash, mb_strpos($received_cash, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($received_cash, true), mb_strlen(mb_substr($received_cash, mb_strpos($received_cash, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($received_cash) && mb_strlen(preg_replace('/(\D)/', '', $received_cash)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($received_cash, true), mb_strlen(preg_replace('/(\D)/', '', $received_cash))), __LINE__);
        }
        $this->received_cash = $received_cash;
        return $this;
    }
    /**
     * Get received_cash_from_owners value
     * @return float|null
     */
    public function getReceived_cash_from_owners()
    {
        return $this->received_cash_from_owners;
    }
    /**
     * Set received_cash_from_owners value
     * @param float $received_cash_from_owners
     * @return \StructType\HouseReportCommon
     */
    public function setReceived_cash_from_owners($received_cash_from_owners = null)
    {
        // validation for constraint: float
        if (!is_null($received_cash_from_owners) && !(is_float($received_cash_from_owners) || is_numeric($received_cash_from_owners))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($received_cash_from_owners, true), gettype($received_cash_from_owners)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($received_cash_from_owners) && mb_strlen(mb_substr($received_cash_from_owners, mb_strpos($received_cash_from_owners, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($received_cash_from_owners, true), mb_strlen(mb_substr($received_cash_from_owners, mb_strpos($received_cash_from_owners, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($received_cash_from_owners) && mb_strlen(preg_replace('/(\D)/', '', $received_cash_from_owners)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($received_cash_from_owners, true), mb_strlen(preg_replace('/(\D)/', '', $received_cash_from_owners))), __LINE__);
        }
        $this->received_cash_from_owners = $received_cash_from_owners;
        return $this;
    }
    /**
     * Get received_target_payment_from_owners value
     * @return float|null
     */
    public function getReceived_target_payment_from_owners()
    {
        return $this->received_target_payment_from_owners;
    }
    /**
     * Set received_target_payment_from_owners value
     * @param float $received_target_payment_from_owners
     * @return \StructType\HouseReportCommon
     */
    public function setReceived_target_payment_from_owners($received_target_payment_from_owners = null)
    {
        // validation for constraint: float
        if (!is_null($received_target_payment_from_owners) && !(is_float($received_target_payment_from_owners) || is_numeric($received_target_payment_from_owners))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($received_target_payment_from_owners, true), gettype($received_target_payment_from_owners)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($received_target_payment_from_owners) && mb_strlen(mb_substr($received_target_payment_from_owners, mb_strpos($received_target_payment_from_owners, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($received_target_payment_from_owners, true), mb_strlen(mb_substr($received_target_payment_from_owners, mb_strpos($received_target_payment_from_owners, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($received_target_payment_from_owners) && mb_strlen(preg_replace('/(\D)/', '', $received_target_payment_from_owners)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($received_target_payment_from_owners, true), mb_strlen(preg_replace('/(\D)/', '', $received_target_payment_from_owners))), __LINE__);
        }
        $this->received_target_payment_from_owners = $received_target_payment_from_owners;
        return $this;
    }
    /**
     * Get received_subsidies value
     * @return float|null
     */
    public function getReceived_subsidies()
    {
        return $this->received_subsidies;
    }
    /**
     * Set received_subsidies value
     * @param float $received_subsidies
     * @return \StructType\HouseReportCommon
     */
    public function setReceived_subsidies($received_subsidies = null)
    {
        // validation for constraint: float
        if (!is_null($received_subsidies) && !(is_float($received_subsidies) || is_numeric($received_subsidies))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($received_subsidies, true), gettype($received_subsidies)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($received_subsidies) && mb_strlen(mb_substr($received_subsidies, mb_strpos($received_subsidies, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($received_subsidies, true), mb_strlen(mb_substr($received_subsidies, mb_strpos($received_subsidies, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($received_subsidies) && mb_strlen(preg_replace('/(\D)/', '', $received_subsidies)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($received_subsidies, true), mb_strlen(preg_replace('/(\D)/', '', $received_subsidies))), __LINE__);
        }
        $this->received_subsidies = $received_subsidies;
        return $this;
    }
    /**
     * Get received_from_use_of_common_property value
     * @return float|null
     */
    public function getReceived_from_use_of_common_property()
    {
        return $this->received_from_use_of_common_property;
    }
    /**
     * Set received_from_use_of_common_property value
     * @param float $received_from_use_of_common_property
     * @return \StructType\HouseReportCommon
     */
    public function setReceived_from_use_of_common_property($received_from_use_of_common_property = null)
    {
        // validation for constraint: float
        if (!is_null($received_from_use_of_common_property) && !(is_float($received_from_use_of_common_property) || is_numeric($received_from_use_of_common_property))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($received_from_use_of_common_property, true), gettype($received_from_use_of_common_property)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($received_from_use_of_common_property) && mb_strlen(mb_substr($received_from_use_of_common_property, mb_strpos($received_from_use_of_common_property, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($received_from_use_of_common_property, true), mb_strlen(mb_substr($received_from_use_of_common_property, mb_strpos($received_from_use_of_common_property, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($received_from_use_of_common_property) && mb_strlen(preg_replace('/(\D)/', '', $received_from_use_of_common_property)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($received_from_use_of_common_property, true), mb_strlen(preg_replace('/(\D)/', '', $received_from_use_of_common_property))), __LINE__);
        }
        $this->received_from_use_of_common_property = $received_from_use_of_common_property;
        return $this;
    }
    /**
     * Get received_from_other value
     * @return float|null
     */
    public function getReceived_from_other()
    {
        return $this->received_from_other;
    }
    /**
     * Set received_from_other value
     * @param float $received_from_other
     * @return \StructType\HouseReportCommon
     */
    public function setReceived_from_other($received_from_other = null)
    {
        // validation for constraint: float
        if (!is_null($received_from_other) && !(is_float($received_from_other) || is_numeric($received_from_other))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($received_from_other, true), gettype($received_from_other)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($received_from_other) && mb_strlen(mb_substr($received_from_other, mb_strpos($received_from_other, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($received_from_other, true), mb_strlen(mb_substr($received_from_other, mb_strpos($received_from_other, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($received_from_other) && mb_strlen(preg_replace('/(\D)/', '', $received_from_other)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($received_from_other, true), mb_strlen(preg_replace('/(\D)/', '', $received_from_other))), __LINE__);
        }
        $this->received_from_other = $received_from_other;
        return $this;
    }
    /**
     * Get cash_total value
     * @return float|null
     */
    public function getCash_total()
    {
        return $this->cash_total;
    }
    /**
     * Set cash_total value
     * @param float $cash_total
     * @return \StructType\HouseReportCommon
     */
    public function setCash_total($cash_total = null)
    {
        // validation for constraint: float
        if (!is_null($cash_total) && !(is_float($cash_total) || is_numeric($cash_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_total, true), gettype($cash_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($cash_total) && mb_strlen(mb_substr($cash_total, mb_strpos($cash_total, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($cash_total, true), mb_strlen(mb_substr($cash_total, mb_strpos($cash_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($cash_total) && mb_strlen(preg_replace('/(\D)/', '', $cash_total)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($cash_total, true), mb_strlen(preg_replace('/(\D)/', '', $cash_total))), __LINE__);
        }
        $this->cash_total = $cash_total;
        return $this;
    }
    /**
     * Get cash_balance_ending_period value
     * @return float|null
     */
    public function getCash_balance_ending_period()
    {
        return $this->cash_balance_ending_period;
    }
    /**
     * Set cash_balance_ending_period value
     * @param float $cash_balance_ending_period
     * @return \StructType\HouseReportCommon
     */
    public function setCash_balance_ending_period($cash_balance_ending_period = null)
    {
        // validation for constraint: float
        if (!is_null($cash_balance_ending_period) && !(is_float($cash_balance_ending_period) || is_numeric($cash_balance_ending_period))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_balance_ending_period, true), gettype($cash_balance_ending_period)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($cash_balance_ending_period) && mb_strlen(mb_substr($cash_balance_ending_period, mb_strpos($cash_balance_ending_period, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($cash_balance_ending_period, true), mb_strlen(mb_substr($cash_balance_ending_period, mb_strpos($cash_balance_ending_period, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($cash_balance_ending_period) && mb_strlen(preg_replace('/(\D)/', '', $cash_balance_ending_period)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($cash_balance_ending_period, true), mb_strlen(preg_replace('/(\D)/', '', $cash_balance_ending_period))), __LINE__);
        }
        $this->cash_balance_ending_period = $cash_balance_ending_period;
        return $this;
    }
    /**
     * Get cash_balance_ending_period_consumers_overpayment value
     * @return float|null
     */
    public function getCash_balance_ending_period_consumers_overpayment()
    {
        return $this->cash_balance_ending_period_consumers_overpayment;
    }
    /**
     * Set cash_balance_ending_period_consumers_overpayment value
     * @param float $cash_balance_ending_period_consumers_overpayment
     * @return \StructType\HouseReportCommon
     */
    public function setCash_balance_ending_period_consumers_overpayment($cash_balance_ending_period_consumers_overpayment = null)
    {
        // validation for constraint: float
        if (!is_null($cash_balance_ending_period_consumers_overpayment) && !(is_float($cash_balance_ending_period_consumers_overpayment) || is_numeric($cash_balance_ending_period_consumers_overpayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_balance_ending_period_consumers_overpayment, true), gettype($cash_balance_ending_period_consumers_overpayment)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($cash_balance_ending_period_consumers_overpayment) && mb_strlen(mb_substr($cash_balance_ending_period_consumers_overpayment, mb_strpos($cash_balance_ending_period_consumers_overpayment, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($cash_balance_ending_period_consumers_overpayment, true), mb_strlen(mb_substr($cash_balance_ending_period_consumers_overpayment, mb_strpos($cash_balance_ending_period_consumers_overpayment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($cash_balance_ending_period_consumers_overpayment) && mb_strlen(preg_replace('/(\D)/', '', $cash_balance_ending_period_consumers_overpayment)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($cash_balance_ending_period_consumers_overpayment, true), mb_strlen(preg_replace('/(\D)/', '', $cash_balance_ending_period_consumers_overpayment))), __LINE__);
        }
        $this->cash_balance_ending_period_consumers_overpayment = $cash_balance_ending_period_consumers_overpayment;
        return $this;
    }
    /**
     * Get cash_balance_ending_period_consumers_arrears value
     * @return float|null
     */
    public function getCash_balance_ending_period_consumers_arrears()
    {
        return $this->cash_balance_ending_period_consumers_arrears;
    }
    /**
     * Set cash_balance_ending_period_consumers_arrears value
     * @param float $cash_balance_ending_period_consumers_arrears
     * @return \StructType\HouseReportCommon
     */
    public function setCash_balance_ending_period_consumers_arrears($cash_balance_ending_period_consumers_arrears = null)
    {
        // validation for constraint: float
        if (!is_null($cash_balance_ending_period_consumers_arrears) && !(is_float($cash_balance_ending_period_consumers_arrears) || is_numeric($cash_balance_ending_period_consumers_arrears))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_balance_ending_period_consumers_arrears, true), gettype($cash_balance_ending_period_consumers_arrears)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($cash_balance_ending_period_consumers_arrears) && mb_strlen(mb_substr($cash_balance_ending_period_consumers_arrears, mb_strpos($cash_balance_ending_period_consumers_arrears, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($cash_balance_ending_period_consumers_arrears, true), mb_strlen(mb_substr($cash_balance_ending_period_consumers_arrears, mb_strpos($cash_balance_ending_period_consumers_arrears, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($cash_balance_ending_period_consumers_arrears) && mb_strlen(preg_replace('/(\D)/', '', $cash_balance_ending_period_consumers_arrears)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($cash_balance_ending_period_consumers_arrears, true), mb_strlen(preg_replace('/(\D)/', '', $cash_balance_ending_period_consumers_arrears))), __LINE__);
        }
        $this->cash_balance_ending_period_consumers_arrears = $cash_balance_ending_period_consumers_arrears;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseReportCommon
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
