<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GasSystem StructType
 * @subpackage Structs
 */
class GasSystem extends AbstractStructBase
{
    /**
     * The system_name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $system_name;
    /**
     * The system_length
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $system_length;
    /**
     * The system_length_no_requirements
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $system_length_no_requirements;
    /**
     * The last_overhaul_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_overhaul_date;
    /**
     * The input_points_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $input_points_count;
    /**
     * The metering_devices_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $metering_devices_count;
    /**
     * The provisioning
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $provisioning;
    /**
     * Constructor method for GasSystem
     * @uses GasSystem::setSystem_name()
     * @uses GasSystem::setSystem_length()
     * @uses GasSystem::setSystem_length_no_requirements()
     * @uses GasSystem::setLast_overhaul_date()
     * @uses GasSystem::setInput_points_count()
     * @uses GasSystem::setMetering_devices_count()
     * @uses GasSystem::setProvisioning()
     * @param string $system_name
     * @param float $system_length
     * @param float $system_length_no_requirements
     * @param string $last_overhaul_date
     * @param int $input_points_count
     * @param int $metering_devices_count
     * @param string $provisioning
     */
    public function __construct($system_name = null, $system_length = null, $system_length_no_requirements = null, $last_overhaul_date = null, $input_points_count = null, $metering_devices_count = null, $provisioning = null)
    {
        $this
            ->setSystem_name($system_name)
            ->setSystem_length($system_length)
            ->setSystem_length_no_requirements($system_length_no_requirements)
            ->setLast_overhaul_date($last_overhaul_date)
            ->setInput_points_count($input_points_count)
            ->setMetering_devices_count($metering_devices_count)
            ->setProvisioning($provisioning);
    }
    /**
     * Get system_name value
     * @return string|null
     */
    public function getSystem_name()
    {
        return $this->system_name;
    }
    /**
     * Set system_name value
     * @uses \EnumType\GasSystemNameEnum::valueIsValid()
     * @uses \EnumType\GasSystemNameEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $system_name
     * @return \StructType\GasSystem
     */
    public function setSystem_name($system_name = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GasSystemNameEnum::valueIsValid($system_name)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $system_name, implode(', ', \EnumType\GasSystemNameEnum::getValidValues())), __LINE__);
        }
        $this->system_name = $system_name;
        return $this;
    }
    /**
     * Get system_length value
     * @return float|null
     */
    public function getSystem_length()
    {
        return $this->system_length;
    }
    /**
     * Set system_length value
     * @param float $system_length
     * @return \StructType\GasSystem
     */
    public function setSystem_length($system_length = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($system_length) && strlen(substr($system_length, strpos($system_length, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($system_length, strpos($system_length, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($system_length) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $system_length)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($system_length, strpos($system_length, '.')))), __LINE__);
        }
        $this->system_length = $system_length;
        return $this;
    }
    /**
     * Get system_length_no_requirements value
     * @return float|null
     */
    public function getSystem_length_no_requirements()
    {
        return $this->system_length_no_requirements;
    }
    /**
     * Set system_length_no_requirements value
     * @param float $system_length_no_requirements
     * @return \StructType\GasSystem
     */
    public function setSystem_length_no_requirements($system_length_no_requirements = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($system_length_no_requirements) && strlen(substr($system_length_no_requirements, strpos($system_length_no_requirements, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($system_length_no_requirements, strpos($system_length_no_requirements, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($system_length_no_requirements) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $system_length_no_requirements)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($system_length_no_requirements, strpos($system_length_no_requirements, '.')))), __LINE__);
        }
        $this->system_length_no_requirements = $system_length_no_requirements;
        return $this;
    }
    /**
     * Get last_overhaul_date value
     * @return string|null
     */
    public function getLast_overhaul_date()
    {
        return $this->last_overhaul_date;
    }
    /**
     * Set last_overhaul_date value
     * @param string $last_overhaul_date
     * @return \StructType\GasSystem
     */
    public function setLast_overhaul_date($last_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_overhaul_date) && !is_string($last_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_overhaul_date)), __LINE__);
        }
        $this->last_overhaul_date = $last_overhaul_date;
        return $this;
    }
    /**
     * Get input_points_count value
     * @return int|null
     */
    public function getInput_points_count()
    {
        return $this->input_points_count;
    }
    /**
     * Set input_points_count value
     * @param int $input_points_count
     * @return \StructType\GasSystem
     */
    public function setInput_points_count($input_points_count = null)
    {
        // validation for constraint: int
        if (!is_null($input_points_count) && !is_numeric($input_points_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($input_points_count)), __LINE__);
        }
        $this->input_points_count = $input_points_count;
        return $this;
    }
    /**
     * Get metering_devices_count value
     * @return int|null
     */
    public function getMetering_devices_count()
    {
        return $this->metering_devices_count;
    }
    /**
     * Set metering_devices_count value
     * @param int $metering_devices_count
     * @return \StructType\GasSystem
     */
    public function setMetering_devices_count($metering_devices_count = null)
    {
        // validation for constraint: int
        if (!is_null($metering_devices_count) && !is_numeric($metering_devices_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($metering_devices_count)), __LINE__);
        }
        $this->metering_devices_count = $metering_devices_count;
        return $this;
    }
    /**
     * Get provisioning value
     * @return string|null
     */
    public function getProvisioning()
    {
        return $this->provisioning;
    }
    /**
     * Set provisioning value
     * @uses \EnumType\ProvisioningEnum::valueIsValid()
     * @uses \EnumType\ProvisioningEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $provisioning
     * @return \StructType\GasSystem
     */
    public function setProvisioning($provisioning = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProvisioningEnum::valueIsValid($provisioning)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $provisioning, implode(', ', \EnumType\ProvisioningEnum::getValidValues())), __LINE__);
        }
        $this->provisioning = $provisioning;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GasSystem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
