<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportingPeriod StructType
 * @subpackage Structs
 */
class ReportingPeriod extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The date_start
     * @var string
     */
    public $date_start;
    /**
     * The date_end
     * @var string
     */
    public $date_end;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The state
     * @var string
     */
    public $state;
    /**
     * The is_988
     * @var bool
     */
    public $is_988;
    /**
     * Constructor method for ReportingPeriod
     * @uses ReportingPeriod::setId()
     * @uses ReportingPeriod::setDate_start()
     * @uses ReportingPeriod::setDate_end()
     * @uses ReportingPeriod::setName()
     * @uses ReportingPeriod::setState()
     * @uses ReportingPeriod::setIs_988()
     * @param int $id
     * @param string $date_start
     * @param string $date_end
     * @param string $name
     * @param string $state
     * @param bool $is_988
     */
    public function __construct($id = null, $date_start = null, $date_end = null, $name = null, $state = null, $is_988 = null)
    {
        $this
            ->setId($id)
            ->setDate_start($date_start)
            ->setDate_end($date_end)
            ->setName($name)
            ->setState($state)
            ->setIs_988($is_988);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\ReportingPeriod
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get date_start value
     * @return string|null
     */
    public function getDate_start()
    {
        return $this->date_start;
    }
    /**
     * Set date_start value
     * @param string $date_start
     * @return \StructType\ReportingPeriod
     */
    public function setDate_start($date_start = null)
    {
        // validation for constraint: string
        if (!is_null($date_start) && !is_string($date_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_start)), __LINE__);
        }
        $this->date_start = $date_start;
        return $this;
    }
    /**
     * Get date_end value
     * @return string|null
     */
    public function getDate_end()
    {
        return $this->date_end;
    }
    /**
     * Set date_end value
     * @param string $date_end
     * @return \StructType\ReportingPeriod
     */
    public function setDate_end($date_end = null)
    {
        // validation for constraint: string
        if (!is_null($date_end) && !is_string($date_end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_end)), __LINE__);
        }
        $this->date_end = $date_end;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ReportingPeriod
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\ReportingPeriodStateEnum::valueIsValid()
     * @uses \EnumType\ReportingPeriodStateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\ReportingPeriod
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportingPeriodStateEnum::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\ReportingPeriodStateEnum::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get is value
     * @return is
     */
    public function getIs_988()
    {
        return $this->is_988;
    }
    /**
     * Set is value
     * @param is $is
     * @return \StructType\ReportingPeriod
     */
    public function setIs_988($is_988 = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_988) && !is_bool($is_988)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is_988)), __LINE__);
        }
        $this->is_988 = $is_988;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportingPeriod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
