<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login StructType
 * @subpackage Structs
 */
class Login extends AbstractStructBase
{
    /**
     * The login
     * @var string
     */
    public $login;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * Constructor method for Login
     * @uses Login::setLogin()
     * @uses Login::setPassword()
     * @param string $login
     * @param string $password
     */
    public function __construct($login = null, $password = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\Login
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login_1) && !is_string($login_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login_1)), __LINE__);
        }
        $this->login = $login_1;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\Login
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Login
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
