<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseProfileSF StructType
 * @subpackage Structs
 */
class GetHouseProfileSF extends AbstractStructBase
{
    /**
     * The region_id
     * @var string
     */
    public $region_id;
    /**
     * The reporting_period_id
     * @var int
     */
    public $reporting_period_id;
    /**
     * The page_number
     * @var int
     */
    public $page_number;
    /**
     * Constructor method for GetHouseProfileSF
     * @uses GetHouseProfileSF::setRegion_id()
     * @uses GetHouseProfileSF::setReporting_period_id()
     * @uses GetHouseProfileSF::setPage_number()
     * @param string $region_id
     * @param int $reporting_period_id
     * @param int $page_number
     */
    public function __construct($region_id = null, $reporting_period_id = null, $page_number = null)
    {
        $this
            ->setRegion_id($region_id)
            ->setReporting_period_id($reporting_period_id)
            ->setPage_number($page_number);
    }
    /**
     * Get region_id value
     * @return string|null
     */
    public function getRegion_id()
    {
        return $this->region_id;
    }
    /**
     * Set region_id value
     * @param string $region_id
     * @return \StructType\GetHouseProfileSF
     */
    public function setRegion_id($region_id = null)
    {
        // validation for constraint: string
        if (!is_null($region_id) && !is_string($region_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region_id)), __LINE__);
        }
        $this->region_id = $region_id;
        return $this;
    }
    /**
     * Get reporting_period_id value
     * @return int|null
     */
    public function getReporting_period_id()
    {
        return $this->reporting_period_id;
    }
    /**
     * Set reporting_period_id value
     * @param int $reporting_period_id
     * @return \StructType\GetHouseProfileSF
     */
    public function setReporting_period_id($reporting_period_id = null)
    {
        // validation for constraint: int
        if (!is_null($reporting_period_id) && !is_numeric($reporting_period_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reporting_period_id)), __LINE__);
        }
        $this->reporting_period_id = $reporting_period_id;
        return $this;
    }
    /**
     * Get page_number value
     * @return int|null
     */
    public function getPage_number()
    {
        return $this->page_number;
    }
    /**
     * Set page_number value
     * @param int $page_number
     * @return \StructType\GetHouseProfileSF
     */
    public function setPage_number($page_number = null)
    {
        // validation for constraint: int
        if (!is_null($page_number) && !is_numeric($page_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($page_number)), __LINE__);
        }
        $this->page_number = $page_number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHouseProfileSF
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
