<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyProfileData988 StructType
 * @subpackage Structs
 */
class CompanyProfileData988 extends AbstractStructBase
{
    /**
     * The work_time
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $work_time;
    /**
     * The dispatcher_address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\FiasAddress
     */
    public $dispatcher_address;
    /**
     * The dispatcher_phone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dispatcher_phone;
    /**
     * The dispatcher_work_time
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dispatcher_work_time;
    /**
     * The fax
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fax;
    /**
     * The staff_regular_total
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $staff_regular_total;
    /**
     * The staff_regular_administrative
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $staff_regular_administrative;
    /**
     * The staff_regular_engineers
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $staff_regular_engineers;
    /**
     * The staff_regular_labor
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $staff_regular_labor;
    /**
     * The membership_information
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $membership_information;
    /**
     * The chart_file_id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $chart_file_id;
    /**
     * The income_of_mng
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $income_of_mng;
    /**
     * The spending_of_mng
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $spending_of_mng;
    /**
     * The debt_for_ku
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_ku;
    /**
     * The debt_for_thermal_energy
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_thermal_energy;
    /**
     * The debt_for_thermal_energy_by_heating
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_thermal_energy_by_heating;
    /**
     * The debt_for_thermal_energy_by_hot_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_thermal_energy_by_hot_water;
    /**
     * The debt_for_hot_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_hot_water;
    /**
     * The debt_for_cold_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_cold_water;
    /**
     * The debt_for_sewerage
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_sewerage;
    /**
     * The debt_for_gas
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_gas;
    /**
     * The debt_for_electrical_energy
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_electrical_energy;
    /**
     * The debt_for_other
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_for_other;
    /**
     * The count_mkd
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $count_mkd;
    /**
     * The area_total
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_total;
    /**
     * The annual_financial_statement_files
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $annual_financial_statement_files;
    /**
     * The revenues_expenditures_estimates_files
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $revenues_expenditures_estimates_files;
    /**
     * The performance_report_files
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $performance_report_files;
    /**
     * The disturbances
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDisturbance
     */
    public $disturbances;
    /**
     * The licenses
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfLicense
     */
    public $licenses;
    /**
     * The okopf
     * @var string
     */
    public $okopf;
    /**
     * The firstname
     * @var string
     */
    public $firstname;
    /**
     * The surname
     * @var string
     */
    public $surname;
    /**
     * The middlename
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $middlename;
    /**
     * The ogrn
     * @var string
     */
    public $ogrn;
    /**
     * The legal_address
     * @var \StructType\FiasAddress
     */
    public $legal_address;
    /**
     * The actual_address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\FiasAddress
     */
    public $actual_address;
    /**
     * The post_address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\FiasAddress
     */
    public $post_address;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $phone;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The site
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $site;
    /**
     * The proportion_sf
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $proportion_sf;
    /**
     * The proportion_mo
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $proportion_mo;
    /**
     * Constructor method for CompanyProfileData988
     * @uses CompanyProfileData988::setWork_time()
     * @uses CompanyProfileData988::setDispatcher_address()
     * @uses CompanyProfileData988::setDispatcher_phone()
     * @uses CompanyProfileData988::setDispatcher_work_time()
     * @uses CompanyProfileData988::setFax()
     * @uses CompanyProfileData988::setStaff_regular_total()
     * @uses CompanyProfileData988::setStaff_regular_administrative()
     * @uses CompanyProfileData988::setStaff_regular_engineers()
     * @uses CompanyProfileData988::setStaff_regular_labor()
     * @uses CompanyProfileData988::setMembership_information()
     * @uses CompanyProfileData988::setChart_file_id()
     * @uses CompanyProfileData988::setIncome_of_mng()
     * @uses CompanyProfileData988::setSpending_of_mng()
     * @uses CompanyProfileData988::setDebt_for_ku()
     * @uses CompanyProfileData988::setDebt_for_thermal_energy()
     * @uses CompanyProfileData988::setDebt_for_thermal_energy_by_heating()
     * @uses CompanyProfileData988::setDebt_for_thermal_energy_by_hot_water()
     * @uses CompanyProfileData988::setDebt_for_hot_water()
     * @uses CompanyProfileData988::setDebt_for_cold_water()
     * @uses CompanyProfileData988::setDebt_for_sewerage()
     * @uses CompanyProfileData988::setDebt_for_gas()
     * @uses CompanyProfileData988::setDebt_for_electrical_energy()
     * @uses CompanyProfileData988::setDebt_for_other()
     * @uses CompanyProfileData988::setCount_mkd()
     * @uses CompanyProfileData988::setArea_total()
     * @uses CompanyProfileData988::setAnnual_financial_statement_files()
     * @uses CompanyProfileData988::setRevenues_expenditures_estimates_files()
     * @uses CompanyProfileData988::setPerformance_report_files()
     * @uses CompanyProfileData988::setDisturbances()
     * @uses CompanyProfileData988::setLicenses()
     * @uses CompanyProfileData988::setOkopf()
     * @uses CompanyProfileData988::setFirstname()
     * @uses CompanyProfileData988::setSurname()
     * @uses CompanyProfileData988::setMiddlename()
     * @uses CompanyProfileData988::setOgrn()
     * @uses CompanyProfileData988::setLegal_address()
     * @uses CompanyProfileData988::setActual_address()
     * @uses CompanyProfileData988::setPost_address()
     * @uses CompanyProfileData988::setPhone()
     * @uses CompanyProfileData988::setEmail()
     * @uses CompanyProfileData988::setSite()
     * @uses CompanyProfileData988::setProportion_sf()
     * @uses CompanyProfileData988::setProportion_mo()
     * @param string $work_time
     * @param \StructType\FiasAddress $dispatcher_address
     * @param string $dispatcher_phone
     * @param string $dispatcher_work_time
     * @param string $fax
     * @param int $staff_regular_total
     * @param int $staff_regular_administrative
     * @param int $staff_regular_engineers
     * @param int $staff_regular_labor
     * @param string $membership_information
     * @param int $chart_file_id
     * @param float $income_of_mng
     * @param float $spending_of_mng
     * @param float $debt_for_ku
     * @param float $debt_for_thermal_energy
     * @param float $debt_for_thermal_energy_by_heating
     * @param float $debt_for_thermal_energy_by_hot_water
     * @param float $debt_for_hot_water
     * @param float $debt_for_cold_water
     * @param float $debt_for_sewerage
     * @param float $debt_for_gas
     * @param float $debt_for_electrical_energy
     * @param float $debt_for_other
     * @param int $count_mkd
     * @param float $area_total
     * @param \ArrayType\ArrayOfInt $annual_financial_statement_files
     * @param \ArrayType\ArrayOfInt $revenues_expenditures_estimates_files
     * @param \ArrayType\ArrayOfInt $performance_report_files
     * @param \ArrayType\ArrayOfDisturbance $disturbances
     * @param \ArrayType\ArrayOfLicense $licenses
     * @param string $okopf
     * @param string $firstname
     * @param string $surname
     * @param string $middlename
     * @param string $ogrn
     * @param \StructType\FiasAddress $legal_address
     * @param \StructType\FiasAddress $actual_address
     * @param \StructType\FiasAddress $post_address
     * @param string $phone
     * @param string $email
     * @param string $site
     * @param float $proportion_sf
     * @param float $proportion_mo
     */
    public function __construct($work_time = null, \StructType\FiasAddress $dispatcher_address = null, $dispatcher_phone = null, $dispatcher_work_time = null, $fax = null, $staff_regular_total = null, $staff_regular_administrative = null, $staff_regular_engineers = null, $staff_regular_labor = null, $membership_information = null, $chart_file_id = null, $income_of_mng = null, $spending_of_mng = null, $debt_for_ku = null, $debt_for_thermal_energy = null, $debt_for_thermal_energy_by_heating = null, $debt_for_thermal_energy_by_hot_water = null, $debt_for_hot_water = null, $debt_for_cold_water = null, $debt_for_sewerage = null, $debt_for_gas = null, $debt_for_electrical_energy = null, $debt_for_other = null, $count_mkd = null, $area_total = null, \ArrayType\ArrayOfInt $annual_financial_statement_files = null, \ArrayType\ArrayOfInt $revenues_expenditures_estimates_files = null, \ArrayType\ArrayOfInt $performance_report_files = null, \ArrayType\ArrayOfDisturbance $disturbances = null, \ArrayType\ArrayOfLicense $licenses = null, $okopf = null, $firstname = null, $surname = null, $middlename = null, $ogrn = null, \StructType\FiasAddress $legal_address = null, \StructType\FiasAddress $actual_address = null, \StructType\FiasAddress $post_address = null, $phone = null, $email = null, $site = null, $proportion_sf = null, $proportion_mo = null)
    {
        $this
            ->setWork_time($work_time)
            ->setDispatcher_address($dispatcher_address)
            ->setDispatcher_phone($dispatcher_phone)
            ->setDispatcher_work_time($dispatcher_work_time)
            ->setFax($fax)
            ->setStaff_regular_total($staff_regular_total)
            ->setStaff_regular_administrative($staff_regular_administrative)
            ->setStaff_regular_engineers($staff_regular_engineers)
            ->setStaff_regular_labor($staff_regular_labor)
            ->setMembership_information($membership_information)
            ->setChart_file_id($chart_file_id)
            ->setIncome_of_mng($income_of_mng)
            ->setSpending_of_mng($spending_of_mng)
            ->setDebt_for_ku($debt_for_ku)
            ->setDebt_for_thermal_energy($debt_for_thermal_energy)
            ->setDebt_for_thermal_energy_by_heating($debt_for_thermal_energy_by_heating)
            ->setDebt_for_thermal_energy_by_hot_water($debt_for_thermal_energy_by_hot_water)
            ->setDebt_for_hot_water($debt_for_hot_water)
            ->setDebt_for_cold_water($debt_for_cold_water)
            ->setDebt_for_sewerage($debt_for_sewerage)
            ->setDebt_for_gas($debt_for_gas)
            ->setDebt_for_electrical_energy($debt_for_electrical_energy)
            ->setDebt_for_other($debt_for_other)
            ->setCount_mkd($count_mkd)
            ->setArea_total($area_total)
            ->setAnnual_financial_statement_files($annual_financial_statement_files)
            ->setRevenues_expenditures_estimates_files($revenues_expenditures_estimates_files)
            ->setPerformance_report_files($performance_report_files)
            ->setDisturbances($disturbances)
            ->setLicenses($licenses)
            ->setOkopf($okopf)
            ->setFirstname($firstname)
            ->setSurname($surname)
            ->setMiddlename($middlename)
            ->setOgrn($ogrn)
            ->setLegal_address($legal_address)
            ->setActual_address($actual_address)
            ->setPost_address($post_address)
            ->setPhone($phone)
            ->setEmail($email)
            ->setSite($site)
            ->setProportion_sf($proportion_sf)
            ->setProportion_mo($proportion_mo);
    }
    /**
     * Get work_time value
     * @return string|null
     */
    public function getWork_time()
    {
        return $this->work_time;
    }
    /**
     * Set work_time value
     * @param string $work_time
     * @return \StructType\CompanyProfileData988
     */
    public function setWork_time($work_time = null)
    {
        // validation for constraint: string
        if (!is_null($work_time) && !is_string($work_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($work_time)), __LINE__);
        }
        $this->work_time = $work_time;
        return $this;
    }
    /**
     * Get dispatcher_address value
     * @return \StructType\FiasAddress|null
     */
    public function getDispatcher_address()
    {
        return $this->dispatcher_address;
    }
    /**
     * Set dispatcher_address value
     * @param \StructType\FiasAddress $dispatcher_address
     * @return \StructType\CompanyProfileData988
     */
    public function setDispatcher_address(\StructType\FiasAddress $dispatcher_address = null)
    {
        $this->dispatcher_address = $dispatcher_address;
        return $this;
    }
    /**
     * Get dispatcher_phone value
     * @return string|null
     */
    public function getDispatcher_phone()
    {
        return $this->dispatcher_phone;
    }
    /**
     * Set dispatcher_phone value
     * @param string $dispatcher_phone
     * @return \StructType\CompanyProfileData988
     */
    public function setDispatcher_phone($dispatcher_phone = null)
    {
        // validation for constraint: string
        if (!is_null($dispatcher_phone) && !is_string($dispatcher_phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dispatcher_phone)), __LINE__);
        }
        $this->dispatcher_phone = $dispatcher_phone;
        return $this;
    }
    /**
     * Get dispatcher_work_time value
     * @return string|null
     */
    public function getDispatcher_work_time()
    {
        return $this->dispatcher_work_time;
    }
    /**
     * Set dispatcher_work_time value
     * @param string $dispatcher_work_time
     * @return \StructType\CompanyProfileData988
     */
    public function setDispatcher_work_time($dispatcher_work_time = null)
    {
        // validation for constraint: string
        if (!is_null($dispatcher_work_time) && !is_string($dispatcher_work_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dispatcher_work_time)), __LINE__);
        }
        $this->dispatcher_work_time = $dispatcher_work_time;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\CompanyProfileData988
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get staff_regular_total value
     * @return int|null
     */
    public function getStaff_regular_total()
    {
        return $this->staff_regular_total;
    }
    /**
     * Set staff_regular_total value
     * @param int $staff_regular_total
     * @return \StructType\CompanyProfileData988
     */
    public function setStaff_regular_total($staff_regular_total = null)
    {
        // validation for constraint: int
        if (!is_null($staff_regular_total) && !is_numeric($staff_regular_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($staff_regular_total)), __LINE__);
        }
        $this->staff_regular_total = $staff_regular_total;
        return $this;
    }
    /**
     * Get staff_regular_administrative value
     * @return int|null
     */
    public function getStaff_regular_administrative()
    {
        return $this->staff_regular_administrative;
    }
    /**
     * Set staff_regular_administrative value
     * @param int $staff_regular_administrative
     * @return \StructType\CompanyProfileData988
     */
    public function setStaff_regular_administrative($staff_regular_administrative = null)
    {
        // validation for constraint: int
        if (!is_null($staff_regular_administrative) && !is_numeric($staff_regular_administrative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($staff_regular_administrative)), __LINE__);
        }
        $this->staff_regular_administrative = $staff_regular_administrative;
        return $this;
    }
    /**
     * Get staff_regular_engineers value
     * @return int|null
     */
    public function getStaff_regular_engineers()
    {
        return $this->staff_regular_engineers;
    }
    /**
     * Set staff_regular_engineers value
     * @param int $staff_regular_engineers
     * @return \StructType\CompanyProfileData988
     */
    public function setStaff_regular_engineers($staff_regular_engineers = null)
    {
        // validation for constraint: int
        if (!is_null($staff_regular_engineers) && !is_numeric($staff_regular_engineers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($staff_regular_engineers)), __LINE__);
        }
        $this->staff_regular_engineers = $staff_regular_engineers;
        return $this;
    }
    /**
     * Get staff_regular_labor value
     * @return int|null
     */
    public function getStaff_regular_labor()
    {
        return $this->staff_regular_labor;
    }
    /**
     * Set staff_regular_labor value
     * @param int $staff_regular_labor
     * @return \StructType\CompanyProfileData988
     */
    public function setStaff_regular_labor($staff_regular_labor = null)
    {
        // validation for constraint: int
        if (!is_null($staff_regular_labor) && !is_numeric($staff_regular_labor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($staff_regular_labor)), __LINE__);
        }
        $this->staff_regular_labor = $staff_regular_labor;
        return $this;
    }
    /**
     * Get membership_information value
     * @return string|null
     */
    public function getMembership_information()
    {
        return $this->membership_information;
    }
    /**
     * Set membership_information value
     * @param string $membership_information
     * @return \StructType\CompanyProfileData988
     */
    public function setMembership_information($membership_information = null)
    {
        // validation for constraint: string
        if (!is_null($membership_information) && !is_string($membership_information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($membership_information)), __LINE__);
        }
        $this->membership_information = $membership_information;
        return $this;
    }
    /**
     * Get chart_file_id value
     * @return int|null
     */
    public function getChart_file_id()
    {
        return $this->chart_file_id;
    }
    /**
     * Set chart_file_id value
     * @param int $chart_file_id
     * @return \StructType\CompanyProfileData988
     */
    public function setChart_file_id($chart_file_id = null)
    {
        // validation for constraint: int
        if (!is_null($chart_file_id) && !is_numeric($chart_file_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chart_file_id)), __LINE__);
        }
        $this->chart_file_id = $chart_file_id;
        return $this;
    }
    /**
     * Get income_of_mng value
     * @return float|null
     */
    public function getIncome_of_mng()
    {
        return $this->income_of_mng;
    }
    /**
     * Set income_of_mng value
     * @param float $income_of_mng
     * @return \StructType\CompanyProfileData988
     */
    public function setIncome_of_mng($income_of_mng = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($income_of_mng) && strlen(substr($income_of_mng, strpos($income_of_mng, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($income_of_mng, strpos($income_of_mng, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($income_of_mng) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $income_of_mng)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($income_of_mng, strpos($income_of_mng, '.')))), __LINE__);
        }
        $this->income_of_mng = $income_of_mng;
        return $this;
    }
    /**
     * Get spending_of_mng value
     * @return float|null
     */
    public function getSpending_of_mng()
    {
        return $this->spending_of_mng;
    }
    /**
     * Set spending_of_mng value
     * @param float $spending_of_mng
     * @return \StructType\CompanyProfileData988
     */
    public function setSpending_of_mng($spending_of_mng = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($spending_of_mng) && strlen(substr($spending_of_mng, strpos($spending_of_mng, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($spending_of_mng, strpos($spending_of_mng, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($spending_of_mng) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $spending_of_mng)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($spending_of_mng, strpos($spending_of_mng, '.')))), __LINE__);
        }
        $this->spending_of_mng = $spending_of_mng;
        return $this;
    }
    /**
     * Get debt_for_ku value
     * @return float|null
     */
    public function getDebt_for_ku()
    {
        return $this->debt_for_ku;
    }
    /**
     * Set debt_for_ku value
     * @param float $debt_for_ku
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_ku($debt_for_ku = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_ku) && strlen(substr($debt_for_ku, strpos($debt_for_ku, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_ku, strpos($debt_for_ku, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_ku) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_ku)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_ku, strpos($debt_for_ku, '.')))), __LINE__);
        }
        $this->debt_for_ku = $debt_for_ku;
        return $this;
    }
    /**
     * Get debt_for_thermal_energy value
     * @return float|null
     */
    public function getDebt_for_thermal_energy()
    {
        return $this->debt_for_thermal_energy;
    }
    /**
     * Set debt_for_thermal_energy value
     * @param float $debt_for_thermal_energy
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_thermal_energy($debt_for_thermal_energy = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_thermal_energy) && strlen(substr($debt_for_thermal_energy, strpos($debt_for_thermal_energy, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_thermal_energy, strpos($debt_for_thermal_energy, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_thermal_energy) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_thermal_energy)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_thermal_energy, strpos($debt_for_thermal_energy, '.')))), __LINE__);
        }
        $this->debt_for_thermal_energy = $debt_for_thermal_energy;
        return $this;
    }
    /**
     * Get debt_for_thermal_energy_by_heating value
     * @return float|null
     */
    public function getDebt_for_thermal_energy_by_heating()
    {
        return $this->debt_for_thermal_energy_by_heating;
    }
    /**
     * Set debt_for_thermal_energy_by_heating value
     * @param float $debt_for_thermal_energy_by_heating
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_thermal_energy_by_heating($debt_for_thermal_energy_by_heating = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_thermal_energy_by_heating) && strlen(substr($debt_for_thermal_energy_by_heating, strpos($debt_for_thermal_energy_by_heating, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_thermal_energy_by_heating, strpos($debt_for_thermal_energy_by_heating, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_thermal_energy_by_heating) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_thermal_energy_by_heating)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_thermal_energy_by_heating, strpos($debt_for_thermal_energy_by_heating, '.')))), __LINE__);
        }
        $this->debt_for_thermal_energy_by_heating = $debt_for_thermal_energy_by_heating;
        return $this;
    }
    /**
     * Get debt_for_thermal_energy_by_hot_water value
     * @return float|null
     */
    public function getDebt_for_thermal_energy_by_hot_water()
    {
        return $this->debt_for_thermal_energy_by_hot_water;
    }
    /**
     * Set debt_for_thermal_energy_by_hot_water value
     * @param float $debt_for_thermal_energy_by_hot_water
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_thermal_energy_by_hot_water($debt_for_thermal_energy_by_hot_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_thermal_energy_by_hot_water) && strlen(substr($debt_for_thermal_energy_by_hot_water, strpos($debt_for_thermal_energy_by_hot_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_thermal_energy_by_hot_water, strpos($debt_for_thermal_energy_by_hot_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_thermal_energy_by_hot_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_thermal_energy_by_hot_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_thermal_energy_by_hot_water, strpos($debt_for_thermal_energy_by_hot_water, '.')))), __LINE__);
        }
        $this->debt_for_thermal_energy_by_hot_water = $debt_for_thermal_energy_by_hot_water;
        return $this;
    }
    /**
     * Get debt_for_hot_water value
     * @return float|null
     */
    public function getDebt_for_hot_water()
    {
        return $this->debt_for_hot_water;
    }
    /**
     * Set debt_for_hot_water value
     * @param float $debt_for_hot_water
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_hot_water($debt_for_hot_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_hot_water) && strlen(substr($debt_for_hot_water, strpos($debt_for_hot_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_hot_water, strpos($debt_for_hot_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_hot_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_hot_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_hot_water, strpos($debt_for_hot_water, '.')))), __LINE__);
        }
        $this->debt_for_hot_water = $debt_for_hot_water;
        return $this;
    }
    /**
     * Get debt_for_cold_water value
     * @return float|null
     */
    public function getDebt_for_cold_water()
    {
        return $this->debt_for_cold_water;
    }
    /**
     * Set debt_for_cold_water value
     * @param float $debt_for_cold_water
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_cold_water($debt_for_cold_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_cold_water) && strlen(substr($debt_for_cold_water, strpos($debt_for_cold_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_cold_water, strpos($debt_for_cold_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_cold_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_cold_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_cold_water, strpos($debt_for_cold_water, '.')))), __LINE__);
        }
        $this->debt_for_cold_water = $debt_for_cold_water;
        return $this;
    }
    /**
     * Get debt_for_sewerage value
     * @return float|null
     */
    public function getDebt_for_sewerage()
    {
        return $this->debt_for_sewerage;
    }
    /**
     * Set debt_for_sewerage value
     * @param float $debt_for_sewerage
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_sewerage($debt_for_sewerage = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_sewerage) && strlen(substr($debt_for_sewerage, strpos($debt_for_sewerage, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_sewerage, strpos($debt_for_sewerage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_sewerage) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_sewerage)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_sewerage, strpos($debt_for_sewerage, '.')))), __LINE__);
        }
        $this->debt_for_sewerage = $debt_for_sewerage;
        return $this;
    }
    /**
     * Get debt_for_gas value
     * @return float|null
     */
    public function getDebt_for_gas()
    {
        return $this->debt_for_gas;
    }
    /**
     * Set debt_for_gas value
     * @param float $debt_for_gas
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_gas($debt_for_gas = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_gas) && strlen(substr($debt_for_gas, strpos($debt_for_gas, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_gas, strpos($debt_for_gas, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_gas) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_gas)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_gas, strpos($debt_for_gas, '.')))), __LINE__);
        }
        $this->debt_for_gas = $debt_for_gas;
        return $this;
    }
    /**
     * Get debt_for_electrical_energy value
     * @return float|null
     */
    public function getDebt_for_electrical_energy()
    {
        return $this->debt_for_electrical_energy;
    }
    /**
     * Set debt_for_electrical_energy value
     * @param float $debt_for_electrical_energy
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_electrical_energy($debt_for_electrical_energy = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_electrical_energy) && strlen(substr($debt_for_electrical_energy, strpos($debt_for_electrical_energy, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_electrical_energy, strpos($debt_for_electrical_energy, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_electrical_energy) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_electrical_energy)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_electrical_energy, strpos($debt_for_electrical_energy, '.')))), __LINE__);
        }
        $this->debt_for_electrical_energy = $debt_for_electrical_energy;
        return $this;
    }
    /**
     * Get debt_for_other value
     * @return float|null
     */
    public function getDebt_for_other()
    {
        return $this->debt_for_other;
    }
    /**
     * Set debt_for_other value
     * @param float $debt_for_other
     * @return \StructType\CompanyProfileData988
     */
    public function setDebt_for_other($debt_for_other = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_for_other) && strlen(substr($debt_for_other, strpos($debt_for_other, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_for_other, strpos($debt_for_other, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_for_other) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_for_other)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_for_other, strpos($debt_for_other, '.')))), __LINE__);
        }
        $this->debt_for_other = $debt_for_other;
        return $this;
    }
    /**
     * Get count_mkd value
     * @return int|null
     */
    public function getCount_mkd()
    {
        return $this->count_mkd;
    }
    /**
     * Set count_mkd value
     * @param int $count_mkd
     * @return \StructType\CompanyProfileData988
     */
    public function setCount_mkd($count_mkd = null)
    {
        // validation for constraint: int
        if (!is_null($count_mkd) && !is_numeric($count_mkd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count_mkd)), __LINE__);
        }
        $this->count_mkd = $count_mkd;
        return $this;
    }
    /**
     * Get area_total value
     * @return float|null
     */
    public function getArea_total()
    {
        return $this->area_total;
    }
    /**
     * Set area_total value
     * @param float $area_total
     * @return \StructType\CompanyProfileData988
     */
    public function setArea_total($area_total = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_total) && strlen(substr($area_total, strpos($area_total, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_total, strpos($area_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_total) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_total)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_total, strpos($area_total, '.')))), __LINE__);
        }
        $this->area_total = $area_total;
        return $this;
    }
    /**
     * Get annual_financial_statement_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getAnnual_financial_statement_files()
    {
        return $this->annual_financial_statement_files;
    }
    /**
     * Set annual_financial_statement_files value
     * @param \ArrayType\ArrayOfInt $annual_financial_statement_files
     * @return \StructType\CompanyProfileData988
     */
    public function setAnnual_financial_statement_files(\ArrayType\ArrayOfInt $annual_financial_statement_files = null)
    {
        $this->annual_financial_statement_files = $annual_financial_statement_files;
        return $this;
    }
    /**
     * Get revenues_expenditures_estimates_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getRevenues_expenditures_estimates_files()
    {
        return $this->revenues_expenditures_estimates_files;
    }
    /**
     * Set revenues_expenditures_estimates_files value
     * @param \ArrayType\ArrayOfInt $revenues_expenditures_estimates_files
     * @return \StructType\CompanyProfileData988
     */
    public function setRevenues_expenditures_estimates_files(\ArrayType\ArrayOfInt $revenues_expenditures_estimates_files = null)
    {
        $this->revenues_expenditures_estimates_files = $revenues_expenditures_estimates_files;
        return $this;
    }
    /**
     * Get performance_report_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getPerformance_report_files()
    {
        return $this->performance_report_files;
    }
    /**
     * Set performance_report_files value
     * @param \ArrayType\ArrayOfInt $performance_report_files
     * @return \StructType\CompanyProfileData988
     */
    public function setPerformance_report_files(\ArrayType\ArrayOfInt $performance_report_files = null)
    {
        $this->performance_report_files = $performance_report_files;
        return $this;
    }
    /**
     * Get disturbances value
     * @return \ArrayType\ArrayOfDisturbance|null
     */
    public function getDisturbances()
    {
        return $this->disturbances;
    }
    /**
     * Set disturbances value
     * @param \ArrayType\ArrayOfDisturbance $disturbances
     * @return \StructType\CompanyProfileData988
     */
    public function setDisturbances(\ArrayType\ArrayOfDisturbance $disturbances = null)
    {
        $this->disturbances = $disturbances;
        return $this;
    }
    /**
     * Get licenses value
     * @return \ArrayType\ArrayOfLicense|null
     */
    public function getLicenses()
    {
        return $this->licenses;
    }
    /**
     * Set licenses value
     * @param \ArrayType\ArrayOfLicense $licenses
     * @return \StructType\CompanyProfileData988
     */
    public function setLicenses(\ArrayType\ArrayOfLicense $licenses = null)
    {
        $this->licenses = $licenses;
        return $this;
    }
    /**
     * Get okopf value
     * @return string|null
     */
    public function getOkopf()
    {
        return $this->okopf;
    }
    /**
     * Set okopf value
     * @uses \EnumType\Okopf::valueIsValid()
     * @uses \EnumType\Okopf::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $okopf
     * @return \StructType\CompanyProfileData988
     */
    public function setOkopf($okopf = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Okopf::valueIsValid($okopf)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $okopf, implode(', ', \EnumType\Okopf::getValidValues())), __LINE__);
        }
        $this->okopf = $okopf;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\CompanyProfileData988
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \StructType\CompanyProfileData988
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get middlename value
     * @return string|null
     */
    public function getMiddlename()
    {
        return $this->middlename;
    }
    /**
     * Set middlename value
     * @param string $middlename
     * @return \StructType\CompanyProfileData988
     */
    public function setMiddlename($middlename = null)
    {
        // validation for constraint: string
        if (!is_null($middlename) && !is_string($middlename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middlename)), __LINE__);
        }
        $this->middlename = $middlename;
        return $this;
    }
    /**
     * Get ogrn value
     * @return string|null
     */
    public function getOgrn()
    {
        return $this->ogrn;
    }
    /**
     * Set ogrn value
     * @param string $ogrn
     * @return \StructType\CompanyProfileData988
     */
    public function setOgrn($ogrn = null)
    {
        // validation for constraint: string
        if (!is_null($ogrn) && !is_string($ogrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ogrn)), __LINE__);
        }
        $this->ogrn = $ogrn;
        return $this;
    }
    /**
     * Get legal_address value
     * @return \StructType\FiasAddress|null
     */
    public function getLegal_address()
    {
        return $this->legal_address;
    }
    /**
     * Set legal_address value
     * @param \StructType\FiasAddress $legal_address
     * @return \StructType\CompanyProfileData988
     */
    public function setLegal_address(\StructType\FiasAddress $legal_address = null)
    {
        $this->legal_address = $legal_address;
        return $this;
    }
    /**
     * Get actual_address value
     * @return \StructType\FiasAddress|null
     */
    public function getActual_address()
    {
        return $this->actual_address;
    }
    /**
     * Set actual_address value
     * @param \StructType\FiasAddress $actual_address
     * @return \StructType\CompanyProfileData988
     */
    public function setActual_address(\StructType\FiasAddress $actual_address = null)
    {
        $this->actual_address = $actual_address;
        return $this;
    }
    /**
     * Get post_address value
     * @return \StructType\FiasAddress|null
     */
    public function getPost_address()
    {
        return $this->post_address;
    }
    /**
     * Set post_address value
     * @param \StructType\FiasAddress $post_address
     * @return \StructType\CompanyProfileData988
     */
    public function setPost_address(\StructType\FiasAddress $post_address = null)
    {
        $this->post_address = $post_address;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\CompanyProfileData988
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CompanyProfileData988
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get site value
     * @return string|null
     */
    public function getSite()
    {
        return $this->site;
    }
    /**
     * Set site value
     * @param string $site
     * @return \StructType\CompanyProfileData988
     */
    public function setSite($site = null)
    {
        // validation for constraint: string
        if (!is_null($site) && !is_string($site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($site)), __LINE__);
        }
        $this->site = $site;
        return $this;
    }
    /**
     * Get proportion_sf value
     * @return float|null
     */
    public function getProportion_sf()
    {
        return $this->proportion_sf;
    }
    /**
     * Set proportion_sf value
     * @param float $proportion_sf
     * @return \StructType\CompanyProfileData988
     */
    public function setProportion_sf($proportion_sf = null)
    {
        $this->proportion_sf = $proportion_sf;
        return $this;
    }
    /**
     * Get proportion_mo value
     * @return float|null
     */
    public function getProportion_mo()
    {
        return $this->proportion_mo;
    }
    /**
     * Set proportion_mo value
     * @param float $proportion_mo
     * @return \StructType\CompanyProfileData988
     */
    public function setProportion_mo($proportion_mo = null)
    {
        $this->proportion_mo = $proportion_mo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyProfileData988
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
