<?php

namespace EnumType;

/**
 * This class stands for ContractTypeEnum EnumType
 * @subpackage Enumerations
 */
class ContractTypeEnum
{
    /**
     * Constant for value '1'
     * Meta informations extracted from the WSDL
     * - description: обслуживаемых ТСЖ
     * @return string '1'
     */
    const VALUE_1 = '1';
    /**
     * Constant for value '2'
     * Meta informations extracted from the WSDL
     * - description: обслуживаемых по договору между ТСЖ и управляющей организацией
     * @return string '2'
     */
    const VALUE_2 = '2';
    /**
     * Constant for value '3'
     * Meta informations extracted from the WSDL
     * - description: обслуживаемых по договору между собственниками и управляющей организацией
     * @return string '3'
     */
    const VALUE_3 = '3';
    /**
     * Constant for value '4'
     * Meta informations extracted from the WSDL
     * - description: обслуживаемых по результатам открытого конкурса органов местного самоуправления
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '5'
     * Meta informations extracted from the WSDL
     * - description: обслуживаемых по договору управления между застройщиком и управляющей организацией, отобранной по результатам открытого
     * конкурса органом местного самоуправления
     * @return string '5'
     */
    const VALUE_5 = '5';
    /**
     * Constant for value '6'
     * Meta informations extracted from the WSDL
     * - description: обслуживаемых по договору управления специализированным жилищным фондом военных городков Минобороны РФ
     * @return string '6'
     */
    const VALUE_6 = '6';
    /**
     * Constant for value '7'
     * Meta informations extracted from the WSDL
     * - description: обслуживаемых по договору управления между застройщиком и управляющей организацией
     * @return string '7'
     */
    const VALUE_7 = '7';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_1
     * @uses self::VALUE_2
     * @uses self::VALUE_3
     * @uses self::VALUE_4
     * @uses self::VALUE_5
     * @uses self::VALUE_6
     * @uses self::VALUE_7
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_1,
            self::VALUE_2,
            self::VALUE_3,
            self::VALUE_4,
            self::VALUE_5,
            self::VALUE_6,
            self::VALUE_7,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
