<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFileByID StructType
 * @subpackage Structs
 */
class GetFileByID extends AbstractStructBase
{
    /**
     * The file_id
     * @var int
     */
    public $file_id;
    /**
     * Constructor method for GetFileByID
     * @uses GetFileByID::setFile_id()
     * @param int $file_id
     */
    public function __construct($file_id = null)
    {
        $this
            ->setFile_id($file_id);
    }
    /**
     * Get file_id value
     * @return int|null
     */
    public function getFile_id()
    {
        return $this->file_id;
    }
    /**
     * Set file_id value
     * @param int $file_id
     * @return \StructType\GetFileByID
     */
    public function setFile_id($file_id = null)
    {
        // validation for constraint: int
        if (!is_null($file_id) && !is_numeric($file_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($file_id)), __LINE__);
        }
        $this->file_id = $file_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetFileByID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
