<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseServiceReportVolume StructType
 * @subpackage Structs
 */
class HouseServiceReportVolume extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The periodicity
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $periodicity;
    /**
     * The unit_of_measurement
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $unit_of_measurement;
    /**
     * The cost_per_unit
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $cost_per_unit;
    /**
     * Constructor method for HouseServiceReportVolume
     * @uses HouseServiceReportVolume::setId()
     * @uses HouseServiceReportVolume::setName()
     * @uses HouseServiceReportVolume::setPeriodicity()
     * @uses HouseServiceReportVolume::setUnit_of_measurement()
     * @uses HouseServiceReportVolume::setCost_per_unit()
     * @param int $id
     * @param string $name
     * @param string $periodicity
     * @param string $unit_of_measurement
     * @param float $cost_per_unit
     */
    public function __construct($id = null, $name = null, $periodicity = null, $unit_of_measurement = null, $cost_per_unit = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setPeriodicity($periodicity)
            ->setUnit_of_measurement($unit_of_measurement)
            ->setCost_per_unit($cost_per_unit);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseServiceReportVolume
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\HouseServiceReportVolume
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get periodicity value
     * @return string|null
     */
    public function getPeriodicity()
    {
        return $this->periodicity;
    }
    /**
     * Set periodicity value
     * @uses \EnumType\HouseReportServicesVolumesPeriodicityEnum::valueIsValid()
     * @uses \EnumType\HouseReportServicesVolumesPeriodicityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicity
     * @return \StructType\HouseServiceReportVolume
     */
    public function setPeriodicity($periodicity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseReportServicesVolumesPeriodicityEnum::valueIsValid($periodicity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $periodicity, implode(', ', \EnumType\HouseReportServicesVolumesPeriodicityEnum::getValidValues())), __LINE__);
        }
        $this->periodicity = $periodicity;
        return $this;
    }
    /**
     * Get unit_of_measurement value
     * @return string|null
     */
    public function getUnit_of_measurement()
    {
        return $this->unit_of_measurement;
    }
    /**
     * Set unit_of_measurement value
     * @uses \EnumType\UnitOfMeasureEnum::valueIsValid()
     * @uses \EnumType\UnitOfMeasureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit_of_measurement
     * @return \StructType\HouseServiceReportVolume
     */
    public function setUnit_of_measurement($unit_of_measurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasureEnum::valueIsValid($unit_of_measurement)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unit_of_measurement, implode(', ', \EnumType\UnitOfMeasureEnum::getValidValues())), __LINE__);
        }
        $this->unit_of_measurement = $unit_of_measurement;
        return $this;
    }
    /**
     * Get cost_per_unit value
     * @return float|null
     */
    public function getCost_per_unit()
    {
        return $this->cost_per_unit;
    }
    /**
     * Set cost_per_unit value
     * @param float $cost_per_unit
     * @return \StructType\HouseServiceReportVolume
     */
    public function setCost_per_unit($cost_per_unit = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($cost_per_unit) && strlen(substr($cost_per_unit, strpos($cost_per_unit, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($cost_per_unit, strpos($cost_per_unit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($cost_per_unit) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $cost_per_unit)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($cost_per_unit, strpos($cost_per_unit, '.')))), __LINE__);
        }
        $this->cost_per_unit = $cost_per_unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseServiceReportVolume
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
