<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseCommunalServiceVolumesReport StructType
 * @subpackage Structs
 */
class HouseCommunalServiceVolumesReport extends AbstractStructBase
{
    /**
     * The unit_of_measurement
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $unit_of_measurement;
    /**
     * The total_volume
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $total_volume;
    /**
     * The accrued_consumer
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $accrued_consumer;
    /**
     * The paid_by_consumers_amount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_by_consumers_amount;
    /**
     * The consumer_arrears
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $consumer_arrears;
    /**
     * The cash_to_provider_payment
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $cash_to_provider_payment;
    /**
     * The paid_to_supplier_amount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_to_supplier_amount;
    /**
     * The arrear_to_supplier_amount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $arrear_to_supplier_amount;
    /**
     * The total_penalties
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $total_penalties;
    /**
     * Constructor method for HouseCommunalServiceVolumesReport
     * @uses HouseCommunalServiceVolumesReport::setUnit_of_measurement()
     * @uses HouseCommunalServiceVolumesReport::setTotal_volume()
     * @uses HouseCommunalServiceVolumesReport::setAccrued_consumer()
     * @uses HouseCommunalServiceVolumesReport::setPaid_by_consumers_amount()
     * @uses HouseCommunalServiceVolumesReport::setConsumer_arrears()
     * @uses HouseCommunalServiceVolumesReport::setCash_to_provider_payment()
     * @uses HouseCommunalServiceVolumesReport::setPaid_to_supplier_amount()
     * @uses HouseCommunalServiceVolumesReport::setArrear_to_supplier_amount()
     * @uses HouseCommunalServiceVolumesReport::setTotal_penalties()
     * @param string $unit_of_measurement
     * @param float $total_volume
     * @param float $accrued_consumer
     * @param float $paid_by_consumers_amount
     * @param float $consumer_arrears
     * @param float $cash_to_provider_payment
     * @param float $paid_to_supplier_amount
     * @param float $arrear_to_supplier_amount
     * @param float $total_penalties
     */
    public function __construct($unit_of_measurement = null, $total_volume = null, $accrued_consumer = null, $paid_by_consumers_amount = null, $consumer_arrears = null, $cash_to_provider_payment = null, $paid_to_supplier_amount = null, $arrear_to_supplier_amount = null, $total_penalties = null)
    {
        $this
            ->setUnit_of_measurement($unit_of_measurement)
            ->setTotal_volume($total_volume)
            ->setAccrued_consumer($accrued_consumer)
            ->setPaid_by_consumers_amount($paid_by_consumers_amount)
            ->setConsumer_arrears($consumer_arrears)
            ->setCash_to_provider_payment($cash_to_provider_payment)
            ->setPaid_to_supplier_amount($paid_to_supplier_amount)
            ->setArrear_to_supplier_amount($arrear_to_supplier_amount)
            ->setTotal_penalties($total_penalties);
    }
    /**
     * Get unit_of_measurement value
     * @return string|null
     */
    public function getUnit_of_measurement()
    {
        return $this->unit_of_measurement;
    }
    /**
     * Set unit_of_measurement value
     * @uses \EnumType\UnitOfMeasureEnum::valueIsValid()
     * @uses \EnumType\UnitOfMeasureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit_of_measurement
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setUnit_of_measurement($unit_of_measurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasureEnum::valueIsValid($unit_of_measurement)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unit_of_measurement, implode(', ', \EnumType\UnitOfMeasureEnum::getValidValues())), __LINE__);
        }
        $this->unit_of_measurement = $unit_of_measurement;
        return $this;
    }
    /**
     * Get total_volume value
     * @return float|null
     */
    public function getTotal_volume()
    {
        return $this->total_volume;
    }
    /**
     * Set total_volume value
     * @param float $total_volume
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setTotal_volume($total_volume = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($total_volume) && strlen(substr($total_volume, strpos($total_volume, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($total_volume, strpos($total_volume, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($total_volume) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $total_volume)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($total_volume, strpos($total_volume, '.')))), __LINE__);
        }
        $this->total_volume = $total_volume;
        return $this;
    }
    /**
     * Get accrued_consumer value
     * @return float|null
     */
    public function getAccrued_consumer()
    {
        return $this->accrued_consumer;
    }
    /**
     * Set accrued_consumer value
     * @param float $accrued_consumer
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setAccrued_consumer($accrued_consumer = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($accrued_consumer) && strlen(substr($accrued_consumer, strpos($accrued_consumer, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($accrued_consumer, strpos($accrued_consumer, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($accrued_consumer) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $accrued_consumer)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($accrued_consumer, strpos($accrued_consumer, '.')))), __LINE__);
        }
        $this->accrued_consumer = $accrued_consumer;
        return $this;
    }
    /**
     * Get paid_by_consumers_amount value
     * @return float|null
     */
    public function getPaid_by_consumers_amount()
    {
        return $this->paid_by_consumers_amount;
    }
    /**
     * Set paid_by_consumers_amount value
     * @param float $paid_by_consumers_amount
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setPaid_by_consumers_amount($paid_by_consumers_amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_by_consumers_amount) && strlen(substr($paid_by_consumers_amount, strpos($paid_by_consumers_amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_by_consumers_amount, strpos($paid_by_consumers_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_by_consumers_amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_by_consumers_amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_by_consumers_amount, strpos($paid_by_consumers_amount, '.')))), __LINE__);
        }
        $this->paid_by_consumers_amount = $paid_by_consumers_amount;
        return $this;
    }
    /**
     * Get consumer_arrears value
     * @return float|null
     */
    public function getConsumer_arrears()
    {
        return $this->consumer_arrears;
    }
    /**
     * Set consumer_arrears value
     * @param float $consumer_arrears
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setConsumer_arrears($consumer_arrears = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($consumer_arrears) && strlen(substr($consumer_arrears, strpos($consumer_arrears, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($consumer_arrears, strpos($consumer_arrears, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($consumer_arrears) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $consumer_arrears)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($consumer_arrears, strpos($consumer_arrears, '.')))), __LINE__);
        }
        $this->consumer_arrears = $consumer_arrears;
        return $this;
    }
    /**
     * Get cash_to_provider_payment value
     * @return float|null
     */
    public function getCash_to_provider_payment()
    {
        return $this->cash_to_provider_payment;
    }
    /**
     * Set cash_to_provider_payment value
     * @param float $cash_to_provider_payment
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setCash_to_provider_payment($cash_to_provider_payment = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($cash_to_provider_payment) && strlen(substr($cash_to_provider_payment, strpos($cash_to_provider_payment, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($cash_to_provider_payment, strpos($cash_to_provider_payment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($cash_to_provider_payment) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $cash_to_provider_payment)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($cash_to_provider_payment, strpos($cash_to_provider_payment, '.')))), __LINE__);
        }
        $this->cash_to_provider_payment = $cash_to_provider_payment;
        return $this;
    }
    /**
     * Get paid_to_supplier_amount value
     * @return float|null
     */
    public function getPaid_to_supplier_amount()
    {
        return $this->paid_to_supplier_amount;
    }
    /**
     * Set paid_to_supplier_amount value
     * @param float $paid_to_supplier_amount
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setPaid_to_supplier_amount($paid_to_supplier_amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_to_supplier_amount) && strlen(substr($paid_to_supplier_amount, strpos($paid_to_supplier_amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_to_supplier_amount, strpos($paid_to_supplier_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_to_supplier_amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_to_supplier_amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_to_supplier_amount, strpos($paid_to_supplier_amount, '.')))), __LINE__);
        }
        $this->paid_to_supplier_amount = $paid_to_supplier_amount;
        return $this;
    }
    /**
     * Get arrear_to_supplier_amount value
     * @return float|null
     */
    public function getArrear_to_supplier_amount()
    {
        return $this->arrear_to_supplier_amount;
    }
    /**
     * Set arrear_to_supplier_amount value
     * @param float $arrear_to_supplier_amount
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setArrear_to_supplier_amount($arrear_to_supplier_amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($arrear_to_supplier_amount) && strlen(substr($arrear_to_supplier_amount, strpos($arrear_to_supplier_amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($arrear_to_supplier_amount, strpos($arrear_to_supplier_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($arrear_to_supplier_amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $arrear_to_supplier_amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($arrear_to_supplier_amount, strpos($arrear_to_supplier_amount, '.')))), __LINE__);
        }
        $this->arrear_to_supplier_amount = $arrear_to_supplier_amount;
        return $this;
    }
    /**
     * Get total_penalties value
     * @return float|null
     */
    public function getTotal_penalties()
    {
        return $this->total_penalties;
    }
    /**
     * Set total_penalties value
     * @param float $total_penalties
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public function setTotal_penalties($total_penalties = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($total_penalties) && strlen(substr($total_penalties, strpos($total_penalties, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($total_penalties, strpos($total_penalties, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($total_penalties) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $total_penalties)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($total_penalties, strpos($total_penalties, '.')))), __LINE__);
        }
        $this->total_penalties = $total_penalties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseCommunalServiceVolumesReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
