<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseCommunalServiceCost StructType
 * @subpackage Structs
 */
class HouseCommunalServiceCost extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The tariff_start_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tariff_start_date;
    /**
     * The unit_of_measurement
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $unit_of_measurement;
    /**
     * The tariff
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $tariff;
    /**
     * Constructor method for HouseCommunalServiceCost
     * @uses HouseCommunalServiceCost::setId()
     * @uses HouseCommunalServiceCost::setTariff_start_date()
     * @uses HouseCommunalServiceCost::setUnit_of_measurement()
     * @uses HouseCommunalServiceCost::setTariff()
     * @param int $id
     * @param string $tariff_start_date
     * @param string $unit_of_measurement
     * @param float $tariff
     */
    public function __construct($id = null, $tariff_start_date = null, $unit_of_measurement = null, $tariff = null)
    {
        $this
            ->setId($id)
            ->setTariff_start_date($tariff_start_date)
            ->setUnit_of_measurement($unit_of_measurement)
            ->setTariff($tariff);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseCommunalServiceCost
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get tariff_start_date value
     * @return string|null
     */
    public function getTariff_start_date()
    {
        return $this->tariff_start_date;
    }
    /**
     * Set tariff_start_date value
     * @param string $tariff_start_date
     * @return \StructType\HouseCommunalServiceCost
     */
    public function setTariff_start_date($tariff_start_date = null)
    {
        // validation for constraint: string
        if (!is_null($tariff_start_date) && !is_string($tariff_start_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariff_start_date)), __LINE__);
        }
        $this->tariff_start_date = $tariff_start_date;
        return $this;
    }
    /**
     * Get unit_of_measurement value
     * @return string|null
     */
    public function getUnit_of_measurement()
    {
        return $this->unit_of_measurement;
    }
    /**
     * Set unit_of_measurement value
     * @uses \EnumType\UnitOfMeasureEnum::valueIsValid()
     * @uses \EnumType\UnitOfMeasureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit_of_measurement
     * @return \StructType\HouseCommunalServiceCost
     */
    public function setUnit_of_measurement($unit_of_measurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasureEnum::valueIsValid($unit_of_measurement)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unit_of_measurement, implode(', ', \EnumType\UnitOfMeasureEnum::getValidValues())), __LINE__);
        }
        $this->unit_of_measurement = $unit_of_measurement;
        return $this;
    }
    /**
     * Get tariff value
     * @return float|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param float $tariff
     * @return \StructType\HouseCommunalServiceCost
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($tariff) && strlen(substr($tariff, strpos($tariff, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($tariff, strpos($tariff, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($tariff) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $tariff)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($tariff, strpos($tariff, '.')))), __LINE__);
        }
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseCommunalServiceCost
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
