<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseCommonPropertyRent StructType
 * @subpackage Structs
 */
class HouseCommonPropertyRent extends AbstractStructBase
{
    /**
     * The provider_name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $provider_name;
    /**
     * The provider_inn
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $provider_inn;
    /**
     * The contract_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $contract_number;
    /**
     * The contract_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $contract_date;
    /**
     * The contract_start_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $contract_start_date;
    /**
     * The cost_per_month
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $cost_per_month;
    /**
     * The common_meeting_protocol_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $common_meeting_protocol_date;
    /**
     * The common_meeting_protocol_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $common_meeting_protocol_number;
    /**
     * Constructor method for HouseCommonPropertyRent
     * @uses HouseCommonPropertyRent::setProvider_name()
     * @uses HouseCommonPropertyRent::setProvider_inn()
     * @uses HouseCommonPropertyRent::setContract_number()
     * @uses HouseCommonPropertyRent::setContract_date()
     * @uses HouseCommonPropertyRent::setContract_start_date()
     * @uses HouseCommonPropertyRent::setCost_per_month()
     * @uses HouseCommonPropertyRent::setCommon_meeting_protocol_date()
     * @uses HouseCommonPropertyRent::setCommon_meeting_protocol_number()
     * @param string $provider_name
     * @param string $provider_inn
     * @param string $contract_number
     * @param string $contract_date
     * @param string $contract_start_date
     * @param float $cost_per_month
     * @param string $common_meeting_protocol_date
     * @param string $common_meeting_protocol_number
     */
    public function __construct($provider_name = null, $provider_inn = null, $contract_number = null, $contract_date = null, $contract_start_date = null, $cost_per_month = null, $common_meeting_protocol_date = null, $common_meeting_protocol_number = null)
    {
        $this
            ->setProvider_name($provider_name)
            ->setProvider_inn($provider_inn)
            ->setContract_number($contract_number)
            ->setContract_date($contract_date)
            ->setContract_start_date($contract_start_date)
            ->setCost_per_month($cost_per_month)
            ->setCommon_meeting_protocol_date($common_meeting_protocol_date)
            ->setCommon_meeting_protocol_number($common_meeting_protocol_number);
    }
    /**
     * Get provider_name value
     * @return string|null
     */
    public function getProvider_name()
    {
        return $this->provider_name;
    }
    /**
     * Set provider_name value
     * @param string $provider_name
     * @return \StructType\HouseCommonPropertyRent
     */
    public function setProvider_name($provider_name = null)
    {
        // validation for constraint: string
        if (!is_null($provider_name) && !is_string($provider_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provider_name)), __LINE__);
        }
        $this->provider_name = $provider_name;
        return $this;
    }
    /**
     * Get provider_inn value
     * @return string|null
     */
    public function getProvider_inn()
    {
        return $this->provider_inn;
    }
    /**
     * Set provider_inn value
     * @param string $provider_inn
     * @return \StructType\HouseCommonPropertyRent
     */
    public function setProvider_inn($provider_inn = null)
    {
        // validation for constraint: string
        if (!is_null($provider_inn) && !is_string($provider_inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provider_inn)), __LINE__);
        }
        $this->provider_inn = $provider_inn;
        return $this;
    }
    /**
     * Get contract_number value
     * @return string|null
     */
    public function getContract_number()
    {
        return $this->contract_number;
    }
    /**
     * Set contract_number value
     * @param string $contract_number
     * @return \StructType\HouseCommonPropertyRent
     */
    public function setContract_number($contract_number = null)
    {
        // validation for constraint: string
        if (!is_null($contract_number) && !is_string($contract_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contract_number)), __LINE__);
        }
        $this->contract_number = $contract_number;
        return $this;
    }
    /**
     * Get contract_date value
     * @return string|null
     */
    public function getContract_date()
    {
        return $this->contract_date;
    }
    /**
     * Set contract_date value
     * @param string $contract_date
     * @return \StructType\HouseCommonPropertyRent
     */
    public function setContract_date($contract_date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_date) && !is_string($contract_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contract_date)), __LINE__);
        }
        $this->contract_date = $contract_date;
        return $this;
    }
    /**
     * Get contract_start_date value
     * @return string|null
     */
    public function getContract_start_date()
    {
        return $this->contract_start_date;
    }
    /**
     * Set contract_start_date value
     * @param string $contract_start_date
     * @return \StructType\HouseCommonPropertyRent
     */
    public function setContract_start_date($contract_start_date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_start_date) && !is_string($contract_start_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contract_start_date)), __LINE__);
        }
        $this->contract_start_date = $contract_start_date;
        return $this;
    }
    /**
     * Get cost_per_month value
     * @return float|null
     */
    public function getCost_per_month()
    {
        return $this->cost_per_month;
    }
    /**
     * Set cost_per_month value
     * @param float $cost_per_month
     * @return \StructType\HouseCommonPropertyRent
     */
    public function setCost_per_month($cost_per_month = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($cost_per_month) && strlen(substr($cost_per_month, strpos($cost_per_month, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($cost_per_month, strpos($cost_per_month, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($cost_per_month) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $cost_per_month)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($cost_per_month, strpos($cost_per_month, '.')))), __LINE__);
        }
        $this->cost_per_month = $cost_per_month;
        return $this;
    }
    /**
     * Get common_meeting_protocol_date value
     * @return string|null
     */
    public function getCommon_meeting_protocol_date()
    {
        return $this->common_meeting_protocol_date;
    }
    /**
     * Set common_meeting_protocol_date value
     * @param string $common_meeting_protocol_date
     * @return \StructType\HouseCommonPropertyRent
     */
    public function setCommon_meeting_protocol_date($common_meeting_protocol_date = null)
    {
        // validation for constraint: string
        if (!is_null($common_meeting_protocol_date) && !is_string($common_meeting_protocol_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($common_meeting_protocol_date)), __LINE__);
        }
        $this->common_meeting_protocol_date = $common_meeting_protocol_date;
        return $this;
    }
    /**
     * Get common_meeting_protocol_number value
     * @return string|null
     */
    public function getCommon_meeting_protocol_number()
    {
        return $this->common_meeting_protocol_number;
    }
    /**
     * Set common_meeting_protocol_number value
     * @param string $common_meeting_protocol_number
     * @return \StructType\HouseCommonPropertyRent
     */
    public function setCommon_meeting_protocol_number($common_meeting_protocol_number = null)
    {
        // validation for constraint: string
        if (!is_null($common_meeting_protocol_number) && !is_string($common_meeting_protocol_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($common_meeting_protocol_number)), __LINE__);
        }
        $this->common_meeting_protocol_number = $common_meeting_protocol_number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseCommonPropertyRent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
