<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Chute StructType
 * @subpackage Structs
 */
class Chute extends AbstractStructBase
{
    /**
     * The chute_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $chute_count;
    /**
     * The chute_last_overhaul_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $chute_last_overhaul_date;
    /**
     * Constructor method for Chute
     * @uses Chute::setChute_count()
     * @uses Chute::setChute_last_overhaul_date()
     * @param int $chute_count
     * @param string $chute_last_overhaul_date
     */
    public function __construct($chute_count = null, $chute_last_overhaul_date = null)
    {
        $this
            ->setChute_count($chute_count)
            ->setChute_last_overhaul_date($chute_last_overhaul_date);
    }
    /**
     * Get chute_count value
     * @return int|null
     */
    public function getChute_count()
    {
        return $this->chute_count;
    }
    /**
     * Set chute_count value
     * @param int $chute_count
     * @return \StructType\Chute
     */
    public function setChute_count($chute_count = null)
    {
        // validation for constraint: int
        if (!is_null($chute_count) && !is_numeric($chute_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chute_count)), __LINE__);
        }
        $this->chute_count = $chute_count;
        return $this;
    }
    /**
     * Get chute_last_overhaul_date value
     * @return string|null
     */
    public function getChute_last_overhaul_date()
    {
        return $this->chute_last_overhaul_date;
    }
    /**
     * Set chute_last_overhaul_date value
     * @param string $chute_last_overhaul_date
     * @return \StructType\Chute
     */
    public function setChute_last_overhaul_date($chute_last_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($chute_last_overhaul_date) && !is_string($chute_last_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chute_last_overhaul_date)), __LINE__);
        }
        $this->chute_last_overhaul_date = $chute_last_overhaul_date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Chute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
