<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SewerageSystem StructType
 * @subpackage Structs
 */
class SewerageSystem extends AbstractStructBase
{
    /**
     * The system_name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $system_name;
    /**
     * The system_length
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $system_length;
    /**
     * The last_overhaul_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_overhaul_date;
    /**
     * Constructor method for SewerageSystem
     * @uses SewerageSystem::setSystem_name()
     * @uses SewerageSystem::setSystem_length()
     * @uses SewerageSystem::setLast_overhaul_date()
     * @param string $system_name
     * @param float $system_length
     * @param string $last_overhaul_date
     */
    public function __construct($system_name = null, $system_length = null, $last_overhaul_date = null)
    {
        $this
            ->setSystem_name($system_name)
            ->setSystem_length($system_length)
            ->setLast_overhaul_date($last_overhaul_date);
    }
    /**
     * Get system_name value
     * @return string|null
     */
    public function getSystem_name()
    {
        return $this->system_name;
    }
    /**
     * Set system_name value
     * @uses \EnumType\SewerageSystemNameEnum::valueIsValid()
     * @uses \EnumType\SewerageSystemNameEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $system_name
     * @return \StructType\SewerageSystem
     */
    public function setSystem_name($system_name = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SewerageSystemNameEnum::valueIsValid($system_name)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $system_name, implode(', ', \EnumType\SewerageSystemNameEnum::getValidValues())), __LINE__);
        }
        $this->system_name = $system_name;
        return $this;
    }
    /**
     * Get system_length value
     * @return float|null
     */
    public function getSystem_length()
    {
        return $this->system_length;
    }
    /**
     * Set system_length value
     * @param float $system_length
     * @return \StructType\SewerageSystem
     */
    public function setSystem_length($system_length = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($system_length) && strlen(substr($system_length, strpos($system_length, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($system_length, strpos($system_length, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($system_length) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $system_length)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($system_length, strpos($system_length, '.')))), __LINE__);
        }
        $this->system_length = $system_length;
        return $this;
    }
    /**
     * Get last_overhaul_date value
     * @return string|null
     */
    public function getLast_overhaul_date()
    {
        return $this->last_overhaul_date;
    }
    /**
     * Set last_overhaul_date value
     * @param string $last_overhaul_date
     * @return \StructType\SewerageSystem
     */
    public function setLast_overhaul_date($last_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_overhaul_date) && !is_string($last_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_overhaul_date)), __LINE__);
        }
        $this->last_overhaul_date = $last_overhaul_date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SewerageSystem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
