<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Roof StructType
 * @subpackage Structs
 */
class Roof extends AbstractStructBase
{
    /**
     * The area_total
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_total;
    /**
     * The area_pitched_slate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_pitched_slate;
    /**
     * The area_pitched_metal
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_pitched_metal;
    /**
     * The area_pitched_others
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_pitched_others;
    /**
     * The area_flat
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_flat;
    /**
     * The last_overhaul_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_overhaul_date;
    /**
     * Constructor method for Roof
     * @uses Roof::setArea_total()
     * @uses Roof::setArea_pitched_slate()
     * @uses Roof::setArea_pitched_metal()
     * @uses Roof::setArea_pitched_others()
     * @uses Roof::setArea_flat()
     * @uses Roof::setLast_overhaul_date()
     * @param float $area_total
     * @param float $area_pitched_slate
     * @param float $area_pitched_metal
     * @param float $area_pitched_others
     * @param float $area_flat
     * @param string $last_overhaul_date
     */
    public function __construct($area_total = null, $area_pitched_slate = null, $area_pitched_metal = null, $area_pitched_others = null, $area_flat = null, $last_overhaul_date = null)
    {
        $this
            ->setArea_total($area_total)
            ->setArea_pitched_slate($area_pitched_slate)
            ->setArea_pitched_metal($area_pitched_metal)
            ->setArea_pitched_others($area_pitched_others)
            ->setArea_flat($area_flat)
            ->setLast_overhaul_date($last_overhaul_date);
    }
    /**
     * Get area_total value
     * @return float|null
     */
    public function getArea_total()
    {
        return $this->area_total;
    }
    /**
     * Set area_total value
     * @param float $area_total
     * @return \StructType\Roof
     */
    public function setArea_total($area_total = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_total) && strlen(substr($area_total, strpos($area_total, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_total, strpos($area_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_total) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_total)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_total, strpos($area_total, '.')))), __LINE__);
        }
        $this->area_total = $area_total;
        return $this;
    }
    /**
     * Get area_pitched_slate value
     * @return float|null
     */
    public function getArea_pitched_slate()
    {
        return $this->area_pitched_slate;
    }
    /**
     * Set area_pitched_slate value
     * @param float $area_pitched_slate
     * @return \StructType\Roof
     */
    public function setArea_pitched_slate($area_pitched_slate = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_pitched_slate) && strlen(substr($area_pitched_slate, strpos($area_pitched_slate, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_pitched_slate, strpos($area_pitched_slate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_pitched_slate) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_pitched_slate)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_pitched_slate, strpos($area_pitched_slate, '.')))), __LINE__);
        }
        $this->area_pitched_slate = $area_pitched_slate;
        return $this;
    }
    /**
     * Get area_pitched_metal value
     * @return float|null
     */
    public function getArea_pitched_metal()
    {
        return $this->area_pitched_metal;
    }
    /**
     * Set area_pitched_metal value
     * @param float $area_pitched_metal
     * @return \StructType\Roof
     */
    public function setArea_pitched_metal($area_pitched_metal = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_pitched_metal) && strlen(substr($area_pitched_metal, strpos($area_pitched_metal, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_pitched_metal, strpos($area_pitched_metal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_pitched_metal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_pitched_metal)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_pitched_metal, strpos($area_pitched_metal, '.')))), __LINE__);
        }
        $this->area_pitched_metal = $area_pitched_metal;
        return $this;
    }
    /**
     * Get area_pitched_others value
     * @return float|null
     */
    public function getArea_pitched_others()
    {
        return $this->area_pitched_others;
    }
    /**
     * Set area_pitched_others value
     * @param float $area_pitched_others
     * @return \StructType\Roof
     */
    public function setArea_pitched_others($area_pitched_others = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_pitched_others) && strlen(substr($area_pitched_others, strpos($area_pitched_others, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_pitched_others, strpos($area_pitched_others, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_pitched_others) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_pitched_others)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_pitched_others, strpos($area_pitched_others, '.')))), __LINE__);
        }
        $this->area_pitched_others = $area_pitched_others;
        return $this;
    }
    /**
     * Get area_flat value
     * @return float|null
     */
    public function getArea_flat()
    {
        return $this->area_flat;
    }
    /**
     * Set area_flat value
     * @param float $area_flat
     * @return \StructType\Roof
     */
    public function setArea_flat($area_flat = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_flat) && strlen(substr($area_flat, strpos($area_flat, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_flat, strpos($area_flat, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_flat) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_flat)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_flat, strpos($area_flat, '.')))), __LINE__);
        }
        $this->area_flat = $area_flat;
        return $this;
    }
    /**
     * Get last_overhaul_date value
     * @return string|null
     */
    public function getLast_overhaul_date()
    {
        return $this->last_overhaul_date;
    }
    /**
     * Set last_overhaul_date value
     * @param string $last_overhaul_date
     * @return \StructType\Roof
     */
    public function setLast_overhaul_date($last_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_overhaul_date) && !is_string($last_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_overhaul_date)), __LINE__);
        }
        $this->last_overhaul_date = $last_overhaul_date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Roof
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
