<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseLift StructType
 * @subpackage Structs
 */
class HouseLift extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The porch_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $porch_number;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $type;
    /**
     * The commissioning_year
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $commissioning_year;
    /**
     * Constructor method for HouseLift
     * @uses HouseLift::setId()
     * @uses HouseLift::setPorch_number()
     * @uses HouseLift::setType()
     * @uses HouseLift::setCommissioning_year()
     * @param int $id
     * @param string $porch_number
     * @param string $type
     * @param int $commissioning_year
     */
    public function __construct($id = null, $porch_number = null, $type = null, $commissioning_year = null)
    {
        $this
            ->setId($id)
            ->setPorch_number($porch_number)
            ->setType($type)
            ->setCommissioning_year($commissioning_year);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseLift
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get porch_number value
     * @return string|null
     */
    public function getPorch_number()
    {
        return $this->porch_number;
    }
    /**
     * Set porch_number value
     * @param string $porch_number
     * @return \StructType\HouseLift
     */
    public function setPorch_number($porch_number = null)
    {
        // validation for constraint: string
        if (!is_null($porch_number) && !is_string($porch_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($porch_number)), __LINE__);
        }
        $this->porch_number = $porch_number;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\HouseLiftTypeEnum::valueIsValid()
     * @uses \EnumType\HouseLiftTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\HouseLift
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseLiftTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\HouseLiftTypeEnum::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get commissioning_year value
     * @return int|null
     */
    public function getCommissioning_year()
    {
        return $this->commissioning_year;
    }
    /**
     * Set commissioning_year value
     * @param int $commissioning_year
     * @return \StructType\HouseLift
     */
    public function setCommissioning_year($commissioning_year = null)
    {
        // validation for constraint: int
        if (!is_null($commissioning_year) && !is_numeric($commissioning_year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($commissioning_year)), __LINE__);
        }
        $this->commissioning_year = $commissioning_year;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseLift
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
