<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseCommunalService StructType
 * @subpackage Structs
 */
class HouseCommunalService extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $type;
    /**
     * The filling_fact
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $filling_fact;
    /**
     * The service_method
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $service_method;
    /**
     * The tariff_description
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tariff_description;
    /**
     * The tariff_description_file_id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $tariff_description_file_id;
    /**
     * The supplied_via_management_organization
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $supplied_via_management_organization;
    /**
     * The provider_inn
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $provider_inn;
    /**
     * The provider_name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $provider_name;
    /**
     * The provider_additional_info
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $provider_additional_info;
    /**
     * The supply_contract_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $supply_contract_date;
    /**
     * The supply_contract_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $supply_contract_number;
    /**
     * The costs
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseCommunalServiceCost
     */
    public $costs;
    /**
     * The legal_act_of_tariff_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $legal_act_of_tariff_date;
    /**
     * The legal_act_of_tariff_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $legal_act_of_tariff_number;
    /**
     * The legal_act_of_tariff_org_name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $legal_act_of_tariff_org_name;
    /**
     * The consumption_norm
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 5
     * - totalDigits: 17
     * @var float
     */
    public $consumption_norm;
    /**
     * The consumption_norm_unit_of_measurement
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consumption_norm_unit_of_measurement;
    /**
     * The consumption_norm_additional_info
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consumption_norm_additional_info;
    /**
     * The consumption_norm_on_common_needs
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 5
     * - totalDigits: 17
     * @var float
     */
    public $consumption_norm_on_common_needs;
    /**
     * The consumption_norm_on_common_needs_unit_of_measurement
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consumption_norm_on_common_needs_unit_of_measurement;
    /**
     * The consumption_norm_on_common_needs_additional_info
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $consumption_norm_on_common_needs_additional_info;
    /**
     * The normative_acts
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfHouseCommunalServiceNormativeAct
     */
    public $normative_acts;
    /**
     * The stop_reason_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stop_reason_type;
    /**
     * The stop_reason
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stop_reason;
    /**
     * The date_stop
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date_stop;
    /**
     * The volumes_report
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\HouseCommunalServiceVolumesReport
     */
    public $volumes_report;
    /**
     * The is_default
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $is_default;
    /**
     * Constructor method for HouseCommunalService
     * @uses HouseCommunalService::setId()
     * @uses HouseCommunalService::setType()
     * @uses HouseCommunalService::setFilling_fact()
     * @uses HouseCommunalService::setService_method()
     * @uses HouseCommunalService::setTariff_description()
     * @uses HouseCommunalService::setTariff_description_file_id()
     * @uses HouseCommunalService::setSupplied_via_management_organization()
     * @uses HouseCommunalService::setProvider_inn()
     * @uses HouseCommunalService::setProvider_name()
     * @uses HouseCommunalService::setProvider_additional_info()
     * @uses HouseCommunalService::setSupply_contract_date()
     * @uses HouseCommunalService::setSupply_contract_number()
     * @uses HouseCommunalService::setCosts()
     * @uses HouseCommunalService::setLegal_act_of_tariff_date()
     * @uses HouseCommunalService::setLegal_act_of_tariff_number()
     * @uses HouseCommunalService::setLegal_act_of_tariff_org_name()
     * @uses HouseCommunalService::setConsumption_norm()
     * @uses HouseCommunalService::setConsumption_norm_unit_of_measurement()
     * @uses HouseCommunalService::setConsumption_norm_additional_info()
     * @uses HouseCommunalService::setConsumption_norm_on_common_needs()
     * @uses HouseCommunalService::setConsumption_norm_on_common_needs_unit_of_measurement()
     * @uses HouseCommunalService::setConsumption_norm_on_common_needs_additional_info()
     * @uses HouseCommunalService::setNormative_acts()
     * @uses HouseCommunalService::setStop_reason_type()
     * @uses HouseCommunalService::setStop_reason()
     * @uses HouseCommunalService::setDate_stop()
     * @uses HouseCommunalService::setVolumes_report()
     * @uses HouseCommunalService::setIs_default()
     * @param int $id
     * @param string $type
     * @param string $filling_fact
     * @param string $service_method
     * @param string $tariff_description
     * @param int $tariff_description_file_id
     * @param bool $supplied_via_management_organization
     * @param string $provider_inn
     * @param string $provider_name
     * @param string $provider_additional_info
     * @param string $supply_contract_date
     * @param string $supply_contract_number
     * @param \ArrayType\ArrayOfHouseCommunalServiceCost $costs
     * @param string $legal_act_of_tariff_date
     * @param string $legal_act_of_tariff_number
     * @param string $legal_act_of_tariff_org_name
     * @param float $consumption_norm
     * @param string $consumption_norm_unit_of_measurement
     * @param string $consumption_norm_additional_info
     * @param float $consumption_norm_on_common_needs
     * @param string $consumption_norm_on_common_needs_unit_of_measurement
     * @param string $consumption_norm_on_common_needs_additional_info
     * @param \ArrayType\ArrayOfHouseCommunalServiceNormativeAct $normative_acts
     * @param string $stop_reason_type
     * @param string $stop_reason
     * @param string $date_stop
     * @param \StructType\HouseCommunalServiceVolumesReport $volumes_report
     * @param bool $is_default
     */
    public function __construct($id = null, $type = null, $filling_fact = null, $service_method = null, $tariff_description = null, $tariff_description_file_id = null, $supplied_via_management_organization = null, $provider_inn = null, $provider_name = null, $provider_additional_info = null, $supply_contract_date = null, $supply_contract_number = null, \ArrayType\ArrayOfHouseCommunalServiceCost $costs = null, $legal_act_of_tariff_date = null, $legal_act_of_tariff_number = null, $legal_act_of_tariff_org_name = null, $consumption_norm = null, $consumption_norm_unit_of_measurement = null, $consumption_norm_additional_info = null, $consumption_norm_on_common_needs = null, $consumption_norm_on_common_needs_unit_of_measurement = null, $consumption_norm_on_common_needs_additional_info = null, \ArrayType\ArrayOfHouseCommunalServiceNormativeAct $normative_acts = null, $stop_reason_type = null, $stop_reason = null, $date_stop = null, \StructType\HouseCommunalServiceVolumesReport $volumes_report = null, $is_default = null)
    {
        $this
            ->setId($id)
            ->setType($type)
            ->setFilling_fact($filling_fact)
            ->setService_method($service_method)
            ->setTariff_description($tariff_description)
            ->setTariff_description_file_id($tariff_description_file_id)
            ->setSupplied_via_management_organization($supplied_via_management_organization)
            ->setProvider_inn($provider_inn)
            ->setProvider_name($provider_name)
            ->setProvider_additional_info($provider_additional_info)
            ->setSupply_contract_date($supply_contract_date)
            ->setSupply_contract_number($supply_contract_number)
            ->setCosts($costs)
            ->setLegal_act_of_tariff_date($legal_act_of_tariff_date)
            ->setLegal_act_of_tariff_number($legal_act_of_tariff_number)
            ->setLegal_act_of_tariff_org_name($legal_act_of_tariff_org_name)
            ->setConsumption_norm($consumption_norm)
            ->setConsumption_norm_unit_of_measurement($consumption_norm_unit_of_measurement)
            ->setConsumption_norm_additional_info($consumption_norm_additional_info)
            ->setConsumption_norm_on_common_needs($consumption_norm_on_common_needs)
            ->setConsumption_norm_on_common_needs_unit_of_measurement($consumption_norm_on_common_needs_unit_of_measurement)
            ->setConsumption_norm_on_common_needs_additional_info($consumption_norm_on_common_needs_additional_info)
            ->setNormative_acts($normative_acts)
            ->setStop_reason_type($stop_reason_type)
            ->setStop_reason($stop_reason)
            ->setDate_stop($date_stop)
            ->setVolumes_report($volumes_report)
            ->setIs_default($is_default);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseCommunalService
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\HouseCommunalServiceTypeEnum::valueIsValid()
     * @uses \EnumType\HouseCommunalServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\HouseCommunalService
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseCommunalServiceTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\HouseCommunalServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get filling_fact value
     * @return string|null
     */
    public function getFilling_fact()
    {
        return $this->filling_fact;
    }
    /**
     * Set filling_fact value
     * @uses \EnumType\CommunalServiceFillingFactEnum::valueIsValid()
     * @uses \EnumType\CommunalServiceFillingFactEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $filling_fact
     * @return \StructType\HouseCommunalService
     */
    public function setFilling_fact($filling_fact = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CommunalServiceFillingFactEnum::valueIsValid($filling_fact)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $filling_fact, implode(', ', \EnumType\CommunalServiceFillingFactEnum::getValidValues())), __LINE__);
        }
        $this->filling_fact = $filling_fact;
        return $this;
    }
    /**
     * Get service_method value
     * @return string|null
     */
    public function getService_method()
    {
        return $this->service_method;
    }
    /**
     * Set service_method value
     * @uses \EnumType\CommunalServiceMethodEnum::valueIsValid()
     * @uses \EnumType\CommunalServiceMethodEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service_method
     * @return \StructType\HouseCommunalService
     */
    public function setService_method($service_method = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CommunalServiceMethodEnum::valueIsValid($service_method)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $service_method, implode(', ', \EnumType\CommunalServiceMethodEnum::getValidValues())), __LINE__);
        }
        $this->service_method = $service_method;
        return $this;
    }
    /**
     * Get tariff_description value
     * @return string|null
     */
    public function getTariff_description()
    {
        return $this->tariff_description;
    }
    /**
     * Set tariff_description value
     * @param string $tariff_description
     * @return \StructType\HouseCommunalService
     */
    public function setTariff_description($tariff_description = null)
    {
        // validation for constraint: string
        if (!is_null($tariff_description) && !is_string($tariff_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariff_description)), __LINE__);
        }
        $this->tariff_description = $tariff_description;
        return $this;
    }
    /**
     * Get tariff_description_file_id value
     * @return int|null
     */
    public function getTariff_description_file_id()
    {
        return $this->tariff_description_file_id;
    }
    /**
     * Set tariff_description_file_id value
     * @param int $tariff_description_file_id
     * @return \StructType\HouseCommunalService
     */
    public function setTariff_description_file_id($tariff_description_file_id = null)
    {
        // validation for constraint: int
        if (!is_null($tariff_description_file_id) && !is_numeric($tariff_description_file_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tariff_description_file_id)), __LINE__);
        }
        $this->tariff_description_file_id = $tariff_description_file_id;
        return $this;
    }
    /**
     * Get supplied_via_management_organization value
     * @return bool|null
     */
    public function getSupplied_via_management_organization()
    {
        return $this->supplied_via_management_organization;
    }
    /**
     * Set supplied_via_management_organization value
     * @param bool $supplied_via_management_organization
     * @return \StructType\HouseCommunalService
     */
    public function setSupplied_via_management_organization($supplied_via_management_organization = null)
    {
        // validation for constraint: boolean
        if (!is_null($supplied_via_management_organization) && !is_bool($supplied_via_management_organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($supplied_via_management_organization)), __LINE__);
        }
        $this->supplied_via_management_organization = $supplied_via_management_organization;
        return $this;
    }
    /**
     * Get provider_inn value
     * @return string|null
     */
    public function getProvider_inn()
    {
        return $this->provider_inn;
    }
    /**
     * Set provider_inn value
     * @param string $provider_inn
     * @return \StructType\HouseCommunalService
     */
    public function setProvider_inn($provider_inn = null)
    {
        // validation for constraint: string
        if (!is_null($provider_inn) && !is_string($provider_inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provider_inn)), __LINE__);
        }
        $this->provider_inn = $provider_inn;
        return $this;
    }
    /**
     * Get provider_name value
     * @return string|null
     */
    public function getProvider_name()
    {
        return $this->provider_name;
    }
    /**
     * Set provider_name value
     * @param string $provider_name
     * @return \StructType\HouseCommunalService
     */
    public function setProvider_name($provider_name = null)
    {
        // validation for constraint: string
        if (!is_null($provider_name) && !is_string($provider_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provider_name)), __LINE__);
        }
        $this->provider_name = $provider_name;
        return $this;
    }
    /**
     * Get provider_additional_info value
     * @return string|null
     */
    public function getProvider_additional_info()
    {
        return $this->provider_additional_info;
    }
    /**
     * Set provider_additional_info value
     * @param string $provider_additional_info
     * @return \StructType\HouseCommunalService
     */
    public function setProvider_additional_info($provider_additional_info = null)
    {
        // validation for constraint: string
        if (!is_null($provider_additional_info) && !is_string($provider_additional_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($provider_additional_info)), __LINE__);
        }
        $this->provider_additional_info = $provider_additional_info;
        return $this;
    }
    /**
     * Get supply_contract_date value
     * @return string|null
     */
    public function getSupply_contract_date()
    {
        return $this->supply_contract_date;
    }
    /**
     * Set supply_contract_date value
     * @param string $supply_contract_date
     * @return \StructType\HouseCommunalService
     */
    public function setSupply_contract_date($supply_contract_date = null)
    {
        // validation for constraint: string
        if (!is_null($supply_contract_date) && !is_string($supply_contract_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supply_contract_date)), __LINE__);
        }
        $this->supply_contract_date = $supply_contract_date;
        return $this;
    }
    /**
     * Get supply_contract_number value
     * @return string|null
     */
    public function getSupply_contract_number()
    {
        return $this->supply_contract_number;
    }
    /**
     * Set supply_contract_number value
     * @param string $supply_contract_number
     * @return \StructType\HouseCommunalService
     */
    public function setSupply_contract_number($supply_contract_number = null)
    {
        // validation for constraint: string
        if (!is_null($supply_contract_number) && !is_string($supply_contract_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supply_contract_number)), __LINE__);
        }
        $this->supply_contract_number = $supply_contract_number;
        return $this;
    }
    /**
     * Get costs value
     * @return \ArrayType\ArrayOfHouseCommunalServiceCost|null
     */
    public function getCosts()
    {
        return $this->costs;
    }
    /**
     * Set costs value
     * @param \ArrayType\ArrayOfHouseCommunalServiceCost $costs
     * @return \StructType\HouseCommunalService
     */
    public function setCosts(\ArrayType\ArrayOfHouseCommunalServiceCost $costs = null)
    {
        $this->costs = $costs;
        return $this;
    }
    /**
     * Get legal_act_of_tariff_date value
     * @return string|null
     */
    public function getLegal_act_of_tariff_date()
    {
        return $this->legal_act_of_tariff_date;
    }
    /**
     * Set legal_act_of_tariff_date value
     * @param string $legal_act_of_tariff_date
     * @return \StructType\HouseCommunalService
     */
    public function setLegal_act_of_tariff_date($legal_act_of_tariff_date = null)
    {
        // validation for constraint: string
        if (!is_null($legal_act_of_tariff_date) && !is_string($legal_act_of_tariff_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legal_act_of_tariff_date)), __LINE__);
        }
        $this->legal_act_of_tariff_date = $legal_act_of_tariff_date;
        return $this;
    }
    /**
     * Get legal_act_of_tariff_number value
     * @return string|null
     */
    public function getLegal_act_of_tariff_number()
    {
        return $this->legal_act_of_tariff_number;
    }
    /**
     * Set legal_act_of_tariff_number value
     * @param string $legal_act_of_tariff_number
     * @return \StructType\HouseCommunalService
     */
    public function setLegal_act_of_tariff_number($legal_act_of_tariff_number = null)
    {
        // validation for constraint: string
        if (!is_null($legal_act_of_tariff_number) && !is_string($legal_act_of_tariff_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legal_act_of_tariff_number)), __LINE__);
        }
        $this->legal_act_of_tariff_number = $legal_act_of_tariff_number;
        return $this;
    }
    /**
     * Get legal_act_of_tariff_org_name value
     * @return string|null
     */
    public function getLegal_act_of_tariff_org_name()
    {
        return $this->legal_act_of_tariff_org_name;
    }
    /**
     * Set legal_act_of_tariff_org_name value
     * @param string $legal_act_of_tariff_org_name
     * @return \StructType\HouseCommunalService
     */
    public function setLegal_act_of_tariff_org_name($legal_act_of_tariff_org_name = null)
    {
        // validation for constraint: string
        if (!is_null($legal_act_of_tariff_org_name) && !is_string($legal_act_of_tariff_org_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legal_act_of_tariff_org_name)), __LINE__);
        }
        $this->legal_act_of_tariff_org_name = $legal_act_of_tariff_org_name;
        return $this;
    }
    /**
     * Get consumption_norm value
     * @return float|null
     */
    public function getConsumption_norm()
    {
        return $this->consumption_norm;
    }
    /**
     * Set consumption_norm value
     * @param float $consumption_norm
     * @return \StructType\HouseCommunalService
     */
    public function setConsumption_norm($consumption_norm = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($consumption_norm) && strlen(substr($consumption_norm, strpos($consumption_norm, '.') + 1)) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 5 fraction digits, "%d" given', strlen(substr($consumption_norm, strpos($consumption_norm, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($consumption_norm) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $consumption_norm)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($consumption_norm, strpos($consumption_norm, '.')))), __LINE__);
        }
        $this->consumption_norm = $consumption_norm;
        return $this;
    }
    /**
     * Get consumption_norm_unit_of_measurement value
     * @return string|null
     */
    public function getConsumption_norm_unit_of_measurement()
    {
        return $this->consumption_norm_unit_of_measurement;
    }
    /**
     * Set consumption_norm_unit_of_measurement value
     * @uses \EnumType\UnitOfMeasureEnum::valueIsValid()
     * @uses \EnumType\UnitOfMeasureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $consumption_norm_unit_of_measurement
     * @return \StructType\HouseCommunalService
     */
    public function setConsumption_norm_unit_of_measurement($consumption_norm_unit_of_measurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasureEnum::valueIsValid($consumption_norm_unit_of_measurement)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $consumption_norm_unit_of_measurement, implode(', ', \EnumType\UnitOfMeasureEnum::getValidValues())), __LINE__);
        }
        $this->consumption_norm_unit_of_measurement = $consumption_norm_unit_of_measurement;
        return $this;
    }
    /**
     * Get consumption_norm_additional_info value
     * @return string|null
     */
    public function getConsumption_norm_additional_info()
    {
        return $this->consumption_norm_additional_info;
    }
    /**
     * Set consumption_norm_additional_info value
     * @param string $consumption_norm_additional_info
     * @return \StructType\HouseCommunalService
     */
    public function setConsumption_norm_additional_info($consumption_norm_additional_info = null)
    {
        // validation for constraint: string
        if (!is_null($consumption_norm_additional_info) && !is_string($consumption_norm_additional_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consumption_norm_additional_info)), __LINE__);
        }
        $this->consumption_norm_additional_info = $consumption_norm_additional_info;
        return $this;
    }
    /**
     * Get consumption_norm_on_common_needs value
     * @return float|null
     */
    public function getConsumption_norm_on_common_needs()
    {
        return $this->consumption_norm_on_common_needs;
    }
    /**
     * Set consumption_norm_on_common_needs value
     * @param float $consumption_norm_on_common_needs
     * @return \StructType\HouseCommunalService
     */
    public function setConsumption_norm_on_common_needs($consumption_norm_on_common_needs = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($consumption_norm_on_common_needs) && strlen(substr($consumption_norm_on_common_needs, strpos($consumption_norm_on_common_needs, '.') + 1)) !== 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 5 fraction digits, "%d" given', strlen(substr($consumption_norm_on_common_needs, strpos($consumption_norm_on_common_needs, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($consumption_norm_on_common_needs) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $consumption_norm_on_common_needs)) !== 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 17 digits, "%d" given', strlen(substr($consumption_norm_on_common_needs, strpos($consumption_norm_on_common_needs, '.')))), __LINE__);
        }
        $this->consumption_norm_on_common_needs = $consumption_norm_on_common_needs;
        return $this;
    }
    /**
     * Get consumption_norm_on_common_needs_unit_of_measurement value
     * @return string|null
     */
    public function getConsumption_norm_on_common_needs_unit_of_measurement()
    {
        return $this->consumption_norm_on_common_needs_unit_of_measurement;
    }
    /**
     * Set consumption_norm_on_common_needs_unit_of_measurement value
     * @uses \EnumType\UnitOfMeasureEnum::valueIsValid()
     * @uses \EnumType\UnitOfMeasureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $consumption_norm_on_common_needs_unit_of_measurement
     * @return \StructType\HouseCommunalService
     */
    public function setConsumption_norm_on_common_needs_unit_of_measurement($consumption_norm_on_common_needs_unit_of_measurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasureEnum::valueIsValid($consumption_norm_on_common_needs_unit_of_measurement)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $consumption_norm_on_common_needs_unit_of_measurement, implode(', ', \EnumType\UnitOfMeasureEnum::getValidValues())), __LINE__);
        }
        $this->consumption_norm_on_common_needs_unit_of_measurement = $consumption_norm_on_common_needs_unit_of_measurement;
        return $this;
    }
    /**
     * Get consumption_norm_on_common_needs_additional_info value
     * @return string|null
     */
    public function getConsumption_norm_on_common_needs_additional_info()
    {
        return $this->consumption_norm_on_common_needs_additional_info;
    }
    /**
     * Set consumption_norm_on_common_needs_additional_info value
     * @param string $consumption_norm_on_common_needs_additional_info
     * @return \StructType\HouseCommunalService
     */
    public function setConsumption_norm_on_common_needs_additional_info($consumption_norm_on_common_needs_additional_info = null)
    {
        // validation for constraint: string
        if (!is_null($consumption_norm_on_common_needs_additional_info) && !is_string($consumption_norm_on_common_needs_additional_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consumption_norm_on_common_needs_additional_info)), __LINE__);
        }
        $this->consumption_norm_on_common_needs_additional_info = $consumption_norm_on_common_needs_additional_info;
        return $this;
    }
    /**
     * Get normative_acts value
     * @return \ArrayType\ArrayOfHouseCommunalServiceNormativeAct|null
     */
    public function getNormative_acts()
    {
        return $this->normative_acts;
    }
    /**
     * Set normative_acts value
     * @param \ArrayType\ArrayOfHouseCommunalServiceNormativeAct $normative_acts
     * @return \StructType\HouseCommunalService
     */
    public function setNormative_acts(\ArrayType\ArrayOfHouseCommunalServiceNormativeAct $normative_acts = null)
    {
        $this->normative_acts = $normative_acts;
        return $this;
    }
    /**
     * Get stop_reason_type value
     * @return string|null
     */
    public function getStop_reason_type()
    {
        return $this->stop_reason_type;
    }
    /**
     * Set stop_reason_type value
     * @uses \EnumType\ServiceStopReasonTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceStopReasonTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stop_reason_type
     * @return \StructType\HouseCommunalService
     */
    public function setStop_reason_type($stop_reason_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceStopReasonTypeEnum::valueIsValid($stop_reason_type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stop_reason_type, implode(', ', \EnumType\ServiceStopReasonTypeEnum::getValidValues())), __LINE__);
        }
        $this->stop_reason_type = $stop_reason_type;
        return $this;
    }
    /**
     * Get stop_reason value
     * @return string|null
     */
    public function getStop_reason()
    {
        return $this->stop_reason;
    }
    /**
     * Set stop_reason value
     * @param string $stop_reason
     * @return \StructType\HouseCommunalService
     */
    public function setStop_reason($stop_reason = null)
    {
        // validation for constraint: string
        if (!is_null($stop_reason) && !is_string($stop_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stop_reason)), __LINE__);
        }
        $this->stop_reason = $stop_reason;
        return $this;
    }
    /**
     * Get date_stop value
     * @return string|null
     */
    public function getDate_stop()
    {
        return $this->date_stop;
    }
    /**
     * Set date_stop value
     * @param string $date_stop
     * @return \StructType\HouseCommunalService
     */
    public function setDate_stop($date_stop = null)
    {
        // validation for constraint: string
        if (!is_null($date_stop) && !is_string($date_stop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_stop)), __LINE__);
        }
        $this->date_stop = $date_stop;
        return $this;
    }
    /**
     * Get volumes_report value
     * @return \StructType\HouseCommunalServiceVolumesReport|null
     */
    public function getVolumes_report()
    {
        return $this->volumes_report;
    }
    /**
     * Set volumes_report value
     * @param \StructType\HouseCommunalServiceVolumesReport $volumes_report
     * @return \StructType\HouseCommunalService
     */
    public function setVolumes_report(\StructType\HouseCommunalServiceVolumesReport $volumes_report = null)
    {
        $this->volumes_report = $volumes_report;
        return $this;
    }
    /**
     * Get is_default value
     * @return bool|null
     */
    public function getIs_default()
    {
        return $this->is_default;
    }
    /**
     * Set is_default value
     * @param bool $is_default
     * @return \StructType\HouseCommunalService
     */
    public function setIs_default($is_default = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_default) && !is_bool($is_default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($is_default)), __LINE__);
        }
        $this->is_default = $is_default;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseCommunalService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
