<?php

namespace App\Lib\Unifaun\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named save
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\Save $parameters
     * @return \App\Lib\Unifaun\StructType\SaveResponse|bool
     */
    public function save(\App\Lib\Unifaun\StructType\Save $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->save($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Lib\Unifaun\StructType\SaveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
