<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Note StructType
 * @subpackage Structs
 */
class Note extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - ref: tns:value
     * @var string
     */
    public $value;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * Constructor method for Note
     * @uses Note::setValue()
     * @uses Note::setType()
     * @param string $value
     * @param string $type
     */
    public function __construct($value = null, $type = null)
    {
        $this
            ->setValue($value)
            ->setType($type);
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \App\Lib\Unifaun\StructType\Note
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \App\Lib\Unifaun\StructType\Note
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
