<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notification StructType
 * @subpackage Structs
 */
class Notification extends AbstractStructBase
{
    /**
     * The method
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $method;
    /**
     * The role
     * Meta information extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $role;
    /**
     * Constructor method for Notification
     * @uses Notification::setMethod()
     * @uses Notification::setRole()
     * @param string $method
     * @param string $role
     */
    public function __construct($method = null, $role = null)
    {
        $this
            ->setMethod($method)
            ->setRole($role);
    }
    /**
     * Get method value
     * @return string|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @param string $method
     * @return \App\Lib\Unifaun\StructType\Notification
     */
    public function setMethod($method = null)
    {
        // validation for constraint: string
        if (!is_null($method) && !is_string($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($method, true), gettype($method)), __LINE__);
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \App\Lib\Unifaun\StructType\Notification
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
}
