<?php

namespace App\Lib\Unifaun\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named delete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\Delete $parameters
     * @return \App\Lib\Unifaun\StructType\DeleteResponse|bool
     */
    public function delete(\App\Lib\Unifaun\StructType\Delete $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->delete($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deletePackageId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\DeletePackageId $parameters
     * @return \App\Lib\Unifaun\StructType\DeletePackageIdResponse|bool
     */
    public function deletePackageId(\App\Lib\Unifaun\StructType\DeletePackageId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deletePackageId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Lib\Unifaun\StructType\DeletePackageIdResponse|\App\Lib\Unifaun\StructType\DeleteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
