<?php

namespace App\Lib\Unifaun\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consolidate ServiceType
 * @subpackage Services
 */
class Consolidate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named consolidate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\Consolidate $parameters
     * @return \App\Lib\Unifaun\StructType\ConsolidateResponse|bool
     */
    public function consolidate(\App\Lib\Unifaun\StructType\Consolidate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->consolidate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Lib\Unifaun\StructType\ConsolidateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
