<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contents StructType
 * @subpackage Structs
 */
class Contents extends AbstractStructBase
{
    /**
     * The ContentItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \App\Lib\Unifaun\StructType\ContentItem[]
     */
    public $ContentItem;
    /**
     * Constructor method for Contents
     * @uses Contents::setContentItem()
     * @param \App\Lib\Unifaun\StructType\ContentItem[] $contentItem
     */
    public function __construct(array $contentItem = array())
    {
        $this
            ->setContentItem($contentItem);
    }
    /**
     * Get ContentItem value
     * @return \App\Lib\Unifaun\StructType\ContentItem[]|null
     */
    public function getContentItem()
    {
        return $this->ContentItem;
    }
    /**
     * This method is responsible for validating the values passed to the setContentItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentItemForArrayConstraintsFromSetContentItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contentsContentItemItem) {
            // validation for constraint: itemType
            if (!$contentsContentItemItem instanceof \App\Lib\Unifaun\StructType\ContentItem) {
                $invalidValues[] = is_object($contentsContentItemItem) ? get_class($contentsContentItemItem) : sprintf('%s(%s)', gettype($contentsContentItemItem), var_export($contentsContentItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContentItem property can only contain items of type \App\Lib\Unifaun\StructType\ContentItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContentItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ContentItem[] $contentItem
     * @return \App\Lib\Unifaun\StructType\Contents
     */
    public function setContentItem(array $contentItem = array())
    {
        // validation for constraint: array
        if ('' !== ($contentItemArrayErrorMessage = self::validateContentItemForArrayConstraintsFromSetContentItem($contentItem))) {
            throw new \InvalidArgumentException($contentItemArrayErrorMessage, __LINE__);
        }
        $this->ContentItem = $contentItem;
        return $this;
    }
    /**
     * Add item to ContentItem value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\ContentItem $item
     * @return \App\Lib\Unifaun\StructType\Contents
     */
    public function addToContentItem(\App\Lib\Unifaun\StructType\ContentItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\ContentItem) {
            throw new \InvalidArgumentException(sprintf('The ContentItem property can only contain items of type \App\Lib\Unifaun\StructType\ContentItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContentItem[] = $item;
        return $this;
    }
}
