<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomsClearance StructType
 * @subpackage Structs
 */
class CustomsClearance extends AbstractStructBase
{
    /**
     * The customsDeclarationNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:customsDeclarationNo
     * @var string
     */
    public $customsDeclarationNo;
    /**
     * The customsDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:customsDescription
     * @var string
     */
    public $customsDescription;
    /**
     * The customsReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:customsReference
     * @var string
     */
    public $customsReference;
    /**
     * The countryOfOrigin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:countryOfOrigin
     * @var string
     */
    public $countryOfOrigin;
    /**
     * The invoiceNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:invoiceNo
     * @var string
     */
    public $invoiceNo;
    /**
     * The invoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:invoiceDate
     * @var string
     */
    public $invoiceDate;
    /**
     * The goodsValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:goodsValue
     * @var float
     */
    public $goodsValue;
    /**
     * The goodsValueCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:goodsValueCurrency
     * @var string
     */
    public $goodsValueCurrency;
    /**
     * The statisticalNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:statisticalNo
     * @var string
     */
    public $statisticalNo;
    /**
     * The dutiable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:dutiable
     * @var bool
     */
    public $dutiable;
    /**
     * The documentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:documentType
     * @var string
     */
    public $documentType;
    /**
     * The goodsType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:goodsType
     * @var string
     */
    public $goodsType;
    /**
     * The goodsDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:goodsDescription
     * @var string
     */
    public $goodsDescription;
    /**
     * The netWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:netWeight
     * @var float
     */
    public $netWeight;
    /**
     * The numberOfGoodsItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:numberOfGoodsItems
     * @var int
     */
    public $numberOfGoodsItems;
    /**
     * The positionInCompany
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:positionInCompany
     * @var string
     */
    public $positionInCompany;
    /**
     * The priceRemarks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:priceRemarks
     * @var string
     */
    public $priceRemarks;
    /**
     * The weightUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:weightUnit
     * @var string
     */
    public $weightUnit;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:reason
     * @var string
     */
    public $reason;
    /**
     * The unitOfMeasureCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:unitOfMeasureCode
     * @var string
     */
    public $unitOfMeasureCode;
    /**
     * Constructor method for CustomsClearance
     * @uses CustomsClearance::setCustomsDeclarationNo()
     * @uses CustomsClearance::setCustomsDescription()
     * @uses CustomsClearance::setCustomsReference()
     * @uses CustomsClearance::setCountryOfOrigin()
     * @uses CustomsClearance::setInvoiceNo()
     * @uses CustomsClearance::setInvoiceDate()
     * @uses CustomsClearance::setGoodsValue()
     * @uses CustomsClearance::setGoodsValueCurrency()
     * @uses CustomsClearance::setStatisticalNo()
     * @uses CustomsClearance::setDutiable()
     * @uses CustomsClearance::setDocumentType()
     * @uses CustomsClearance::setGoodsType()
     * @uses CustomsClearance::setGoodsDescription()
     * @uses CustomsClearance::setNetWeight()
     * @uses CustomsClearance::setNumberOfGoodsItems()
     * @uses CustomsClearance::setPositionInCompany()
     * @uses CustomsClearance::setPriceRemarks()
     * @uses CustomsClearance::setWeightUnit()
     * @uses CustomsClearance::setReason()
     * @uses CustomsClearance::setUnitOfMeasureCode()
     * @param string $customsDeclarationNo
     * @param string $customsDescription
     * @param string $customsReference
     * @param string $countryOfOrigin
     * @param string $invoiceNo
     * @param string $invoiceDate
     * @param float $goodsValue
     * @param string $goodsValueCurrency
     * @param string $statisticalNo
     * @param bool $dutiable
     * @param string $documentType
     * @param string $goodsType
     * @param string $goodsDescription
     * @param float $netWeight
     * @param int $numberOfGoodsItems
     * @param string $positionInCompany
     * @param string $priceRemarks
     * @param string $weightUnit
     * @param string $reason
     * @param string $unitOfMeasureCode
     */
    public function __construct($customsDeclarationNo = null, $customsDescription = null, $customsReference = null, $countryOfOrigin = null, $invoiceNo = null, $invoiceDate = null, $goodsValue = null, $goodsValueCurrency = null, $statisticalNo = null, $dutiable = null, $documentType = null, $goodsType = null, $goodsDescription = null, $netWeight = null, $numberOfGoodsItems = null, $positionInCompany = null, $priceRemarks = null, $weightUnit = null, $reason = null, $unitOfMeasureCode = null)
    {
        $this
            ->setCustomsDeclarationNo($customsDeclarationNo)
            ->setCustomsDescription($customsDescription)
            ->setCustomsReference($customsReference)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setInvoiceNo($invoiceNo)
            ->setInvoiceDate($invoiceDate)
            ->setGoodsValue($goodsValue)
            ->setGoodsValueCurrency($goodsValueCurrency)
            ->setStatisticalNo($statisticalNo)
            ->setDutiable($dutiable)
            ->setDocumentType($documentType)
            ->setGoodsType($goodsType)
            ->setGoodsDescription($goodsDescription)
            ->setNetWeight($netWeight)
            ->setNumberOfGoodsItems($numberOfGoodsItems)
            ->setPositionInCompany($positionInCompany)
            ->setPriceRemarks($priceRemarks)
            ->setWeightUnit($weightUnit)
            ->setReason($reason)
            ->setUnitOfMeasureCode($unitOfMeasureCode);
    }
    /**
     * Get customsDeclarationNo value
     * @return string|null
     */
    public function getCustomsDeclarationNo()
    {
        return $this->customsDeclarationNo;
    }
    /**
     * Set customsDeclarationNo value
     * @param string $customsDeclarationNo
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setCustomsDeclarationNo($customsDeclarationNo = null)
    {
        // validation for constraint: string
        if (!is_null($customsDeclarationNo) && !is_string($customsDeclarationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsDeclarationNo, true), gettype($customsDeclarationNo)), __LINE__);
        }
        $this->customsDeclarationNo = $customsDeclarationNo;
        return $this;
    }
    /**
     * Get customsDescription value
     * @return string|null
     */
    public function getCustomsDescription()
    {
        return $this->customsDescription;
    }
    /**
     * Set customsDescription value
     * @param string $customsDescription
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setCustomsDescription($customsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($customsDescription) && !is_string($customsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsDescription, true), gettype($customsDescription)), __LINE__);
        }
        $this->customsDescription = $customsDescription;
        return $this;
    }
    /**
     * Get customsReference value
     * @return string|null
     */
    public function getCustomsReference()
    {
        return $this->customsReference;
    }
    /**
     * Set customsReference value
     * @param string $customsReference
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setCustomsReference($customsReference = null)
    {
        // validation for constraint: string
        if (!is_null($customsReference) && !is_string($customsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsReference, true), gettype($customsReference)), __LINE__);
        }
        $this->customsReference = $customsReference;
        return $this;
    }
    /**
     * Get countryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->countryOfOrigin;
    }
    /**
     * Set countryOfOrigin value
     * @param string $countryOfOrigin
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfOrigin, true), gettype($countryOfOrigin)), __LINE__);
        }
        $this->countryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get invoiceNo value
     * @return string|null
     */
    public function getInvoiceNo()
    {
        return $this->invoiceNo;
    }
    /**
     * Set invoiceNo value
     * @param string $invoiceNo
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setInvoiceNo($invoiceNo = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNo) && !is_string($invoiceNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNo, true), gettype($invoiceNo)), __LINE__);
        }
        $this->invoiceNo = $invoiceNo;
        return $this;
    }
    /**
     * Get invoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }
    /**
     * Set invoiceDate value
     * @param string $invoiceDate
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->invoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get goodsValue value
     * @return float|null
     */
    public function getGoodsValue()
    {
        return $this->goodsValue;
    }
    /**
     * Set goodsValue value
     * @param float $goodsValue
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setGoodsValue($goodsValue = null)
    {
        // validation for constraint: float
        if (!is_null($goodsValue) && !(is_float($goodsValue) || is_numeric($goodsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($goodsValue, true), gettype($goodsValue)), __LINE__);
        }
        $this->goodsValue = $goodsValue;
        return $this;
    }
    /**
     * Get goodsValueCurrency value
     * @return string|null
     */
    public function getGoodsValueCurrency()
    {
        return $this->goodsValueCurrency;
    }
    /**
     * Set goodsValueCurrency value
     * @param string $goodsValueCurrency
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setGoodsValueCurrency($goodsValueCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($goodsValueCurrency) && !is_string($goodsValueCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsValueCurrency, true), gettype($goodsValueCurrency)), __LINE__);
        }
        $this->goodsValueCurrency = $goodsValueCurrency;
        return $this;
    }
    /**
     * Get statisticalNo value
     * @return string|null
     */
    public function getStatisticalNo()
    {
        return $this->statisticalNo;
    }
    /**
     * Set statisticalNo value
     * @param string $statisticalNo
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setStatisticalNo($statisticalNo = null)
    {
        // validation for constraint: string
        if (!is_null($statisticalNo) && !is_string($statisticalNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statisticalNo, true), gettype($statisticalNo)), __LINE__);
        }
        $this->statisticalNo = $statisticalNo;
        return $this;
    }
    /**
     * Get dutiable value
     * @return bool|null
     */
    public function getDutiable()
    {
        return $this->dutiable;
    }
    /**
     * Set dutiable value
     * @param bool $dutiable
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setDutiable($dutiable = null)
    {
        // validation for constraint: boolean
        if (!is_null($dutiable) && !is_bool($dutiable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dutiable, true), gettype($dutiable)), __LINE__);
        }
        $this->dutiable = $dutiable;
        return $this;
    }
    /**
     * Get documentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->documentType;
    }
    /**
     * Set documentType value
     * @param string $documentType
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->documentType = $documentType;
        return $this;
    }
    /**
     * Get goodsType value
     * @return string|null
     */
    public function getGoodsType()
    {
        return $this->goodsType;
    }
    /**
     * Set goodsType value
     * @param string $goodsType
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setGoodsType($goodsType = null)
    {
        // validation for constraint: string
        if (!is_null($goodsType) && !is_string($goodsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsType, true), gettype($goodsType)), __LINE__);
        }
        $this->goodsType = $goodsType;
        return $this;
    }
    /**
     * Get goodsDescription value
     * @return string|null
     */
    public function getGoodsDescription()
    {
        return $this->goodsDescription;
    }
    /**
     * Set goodsDescription value
     * @param string $goodsDescription
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setGoodsDescription($goodsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($goodsDescription) && !is_string($goodsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsDescription, true), gettype($goodsDescription)), __LINE__);
        }
        $this->goodsDescription = $goodsDescription;
        return $this;
    }
    /**
     * Get netWeight value
     * @return float|null
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param float $netWeight
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setNetWeight($netWeight = null)
    {
        // validation for constraint: float
        if (!is_null($netWeight) && !(is_float($netWeight) || is_numeric($netWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeight, true), gettype($netWeight)), __LINE__);
        }
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get numberOfGoodsItems value
     * @return int|null
     */
    public function getNumberOfGoodsItems()
    {
        return $this->numberOfGoodsItems;
    }
    /**
     * Set numberOfGoodsItems value
     * @param int $numberOfGoodsItems
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setNumberOfGoodsItems($numberOfGoodsItems = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGoodsItems) && !(is_int($numberOfGoodsItems) || ctype_digit($numberOfGoodsItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGoodsItems, true), gettype($numberOfGoodsItems)), __LINE__);
        }
        $this->numberOfGoodsItems = $numberOfGoodsItems;
        return $this;
    }
    /**
     * Get positionInCompany value
     * @return string|null
     */
    public function getPositionInCompany()
    {
        return $this->positionInCompany;
    }
    /**
     * Set positionInCompany value
     * @param string $positionInCompany
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setPositionInCompany($positionInCompany = null)
    {
        // validation for constraint: string
        if (!is_null($positionInCompany) && !is_string($positionInCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($positionInCompany, true), gettype($positionInCompany)), __LINE__);
        }
        $this->positionInCompany = $positionInCompany;
        return $this;
    }
    /**
     * Get priceRemarks value
     * @return string|null
     */
    public function getPriceRemarks()
    {
        return $this->priceRemarks;
    }
    /**
     * Set priceRemarks value
     * @param string $priceRemarks
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setPriceRemarks($priceRemarks = null)
    {
        // validation for constraint: string
        if (!is_null($priceRemarks) && !is_string($priceRemarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceRemarks, true), gettype($priceRemarks)), __LINE__);
        }
        $this->priceRemarks = $priceRemarks;
        return $this;
    }
    /**
     * Get weightUnit value
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->weightUnit;
    }
    /**
     * Set weightUnit value
     * @param string $weightUnit
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setWeightUnit($weightUnit = null)
    {
        // validation for constraint: string
        if (!is_null($weightUnit) && !is_string($weightUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightUnit, true), gettype($weightUnit)), __LINE__);
        }
        $this->weightUnit = $weightUnit;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get unitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->unitOfMeasureCode;
    }
    /**
     * Set unitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \App\Lib\Unifaun\StructType\CustomsClearance
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasureCode, true), gettype($unitOfMeasureCode)), __LINE__);
        }
        $this->unitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
}
