<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculatedPrice StructType
 * @subpackage Structs
 */
class CalculatedPrice extends AbstractStructBase
{
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $price;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $currency;
    /**
     * The priceDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\PriceDetail[]
     */
    public $priceDetail;
    /**
     * Constructor method for CalculatedPrice
     * @uses CalculatedPrice::setPrice()
     * @uses CalculatedPrice::setCurrency()
     * @uses CalculatedPrice::setPriceDetail()
     * @param float $price
     * @param string $currency
     * @param \App\Lib\Unifaun\StructType\PriceDetail[] $priceDetail
     */
    public function __construct($price = null, $currency = null, array $priceDetail = array())
    {
        $this
            ->setPrice($price)
            ->setCurrency($currency)
            ->setPriceDetail($priceDetail);
    }
    /**
     * Get price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice()
    {
        return isset($this->price) ? $this->price : null;
    }
    /**
     * Set price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->price);
        } else {
            $this->price = $price;
        }
        return $this;
    }
    /**
     * Get currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->currency) ? $this->currency : null;
    }
    /**
     * Set currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->currency);
        } else {
            $this->currency = $currency;
        }
        return $this;
    }
    /**
     * Get priceDetail value
     * @return \App\Lib\Unifaun\StructType\PriceDetail[]|null
     */
    public function getPriceDetail()
    {
        return $this->priceDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceDetailForArrayConstraintsFromSetPriceDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calculatedPricePriceDetailItem) {
            // validation for constraint: itemType
            if (!$calculatedPricePriceDetailItem instanceof \App\Lib\Unifaun\StructType\PriceDetail) {
                $invalidValues[] = is_object($calculatedPricePriceDetailItem) ? get_class($calculatedPricePriceDetailItem) : sprintf('%s(%s)', gettype($calculatedPricePriceDetailItem), var_export($calculatedPricePriceDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The priceDetail property can only contain items of type \App\Lib\Unifaun\StructType\PriceDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set priceDetail value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\PriceDetail[] $priceDetail
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public function setPriceDetail(array $priceDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($priceDetailArrayErrorMessage = self::validatePriceDetailForArrayConstraintsFromSetPriceDetail($priceDetail))) {
            throw new \InvalidArgumentException($priceDetailArrayErrorMessage, __LINE__);
        }
        $this->priceDetail = $priceDetail;
        return $this;
    }
    /**
     * Add item to priceDetail value
     * @throws \InvalidArgumentException
     * @param \App\Lib\Unifaun\StructType\PriceDetail $item
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public function addToPriceDetail(\App\Lib\Unifaun\StructType\PriceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Lib\Unifaun\StructType\PriceDetail) {
            throw new \InvalidArgumentException(sprintf('The priceDetail property can only contain items of type \App\Lib\Unifaun\StructType\PriceDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->priceDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\CalculatedPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
