<?php

namespace App\Lib\Unifaun\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsItem StructType
 * @subpackage Structs
 */
class GoodsItem extends AbstractStructBase
{
    /**
     * The noOfPackages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:noOfPackages
     * @var int
     */
    public $noOfPackages;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:weight
     * @var float
     */
    public $weight;
    /**
     * The volume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:volume
     * @var float
     */
    public $volume;
    /**
     * The length
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:length
     * @var float
     */
    public $length;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:width
     * @var float
     */
    public $width;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:height
     * @var float
     */
    public $height;
    /**
     * The loadingMetres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:loadingMetres
     * @var float
     */
    public $loadingMetres;
    /**
     * The palletSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:palletSpace
     * @var int
     */
    public $palletSpace;
    /**
     * The packageType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:packageType
     * @var string
     */
    public $packageType;
    /**
     * The tag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:tag
     * @var string
     */
    public $tag;
    /**
     * The goodsType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:goodsType
     * @var string
     */
    public $goodsType;
    /**
     * The netWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:netWeight
     * @var float
     */
    public $netWeight;
    /**
     * The weightUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:weightUnit
     * @var string
     */
    public $weightUnit;
    /**
     * The volumeUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:volumeUnit
     * @var string
     */
    public $volumeUnit;
    /**
     * The lengthUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:lengthUnit
     * @var string
     */
    public $lengthUnit;
    /**
     * The stackable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:stackable
     * @var bool
     */
    public $stackable;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: tns:notes
     * @var string
     */
    public $notes;
    /**
     * The PackageIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\PackageIds
     */
    public $PackageIds;
    /**
     * The DangerousGoods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Lib\Unifaun\StructType\DangerousGoods
     */
    public $DangerousGoods;
    /**
     * Constructor method for GoodsItem
     * @uses GoodsItem::setNoOfPackages()
     * @uses GoodsItem::setWeight()
     * @uses GoodsItem::setVolume()
     * @uses GoodsItem::setLength()
     * @uses GoodsItem::setWidth()
     * @uses GoodsItem::setHeight()
     * @uses GoodsItem::setLoadingMetres()
     * @uses GoodsItem::setPalletSpace()
     * @uses GoodsItem::setPackageType()
     * @uses GoodsItem::setTag()
     * @uses GoodsItem::setGoodsType()
     * @uses GoodsItem::setNetWeight()
     * @uses GoodsItem::setWeightUnit()
     * @uses GoodsItem::setVolumeUnit()
     * @uses GoodsItem::setLengthUnit()
     * @uses GoodsItem::setStackable()
     * @uses GoodsItem::setNotes()
     * @uses GoodsItem::setPackageIds()
     * @uses GoodsItem::setDangerousGoods()
     * @param int $noOfPackages
     * @param float $weight
     * @param float $volume
     * @param float $length
     * @param float $width
     * @param float $height
     * @param float $loadingMetres
     * @param int $palletSpace
     * @param string $packageType
     * @param string $tag
     * @param string $goodsType
     * @param float $netWeight
     * @param string $weightUnit
     * @param string $volumeUnit
     * @param string $lengthUnit
     * @param bool $stackable
     * @param string $notes
     * @param \App\Lib\Unifaun\StructType\PackageIds $packageIds
     * @param \App\Lib\Unifaun\StructType\DangerousGoods $dangerousGoods
     */
    public function __construct($noOfPackages = null, $weight = null, $volume = null, $length = null, $width = null, $height = null, $loadingMetres = null, $palletSpace = null, $packageType = null, $tag = null, $goodsType = null, $netWeight = null, $weightUnit = null, $volumeUnit = null, $lengthUnit = null, $stackable = null, $notes = null, \App\Lib\Unifaun\StructType\PackageIds $packageIds = null, \App\Lib\Unifaun\StructType\DangerousGoods $dangerousGoods = null)
    {
        $this
            ->setNoOfPackages($noOfPackages)
            ->setWeight($weight)
            ->setVolume($volume)
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setLoadingMetres($loadingMetres)
            ->setPalletSpace($palletSpace)
            ->setPackageType($packageType)
            ->setTag($tag)
            ->setGoodsType($goodsType)
            ->setNetWeight($netWeight)
            ->setWeightUnit($weightUnit)
            ->setVolumeUnit($volumeUnit)
            ->setLengthUnit($lengthUnit)
            ->setStackable($stackable)
            ->setNotes($notes)
            ->setPackageIds($packageIds)
            ->setDangerousGoods($dangerousGoods);
    }
    /**
     * Get noOfPackages value
     * @return int|null
     */
    public function getNoOfPackages()
    {
        return $this->noOfPackages;
    }
    /**
     * Set noOfPackages value
     * @param int $noOfPackages
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setNoOfPackages($noOfPackages = null)
    {
        // validation for constraint: int
        if (!is_null($noOfPackages) && !(is_int($noOfPackages) || ctype_digit($noOfPackages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($noOfPackages, true), gettype($noOfPackages)), __LINE__);
        }
        $this->noOfPackages = $noOfPackages;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param float $length
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get loadingMetres value
     * @return float|null
     */
    public function getLoadingMetres()
    {
        return $this->loadingMetres;
    }
    /**
     * Set loadingMetres value
     * @param float $loadingMetres
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setLoadingMetres($loadingMetres = null)
    {
        // validation for constraint: float
        if (!is_null($loadingMetres) && !(is_float($loadingMetres) || is_numeric($loadingMetres))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loadingMetres, true), gettype($loadingMetres)), __LINE__);
        }
        $this->loadingMetres = $loadingMetres;
        return $this;
    }
    /**
     * Get palletSpace value
     * @return int|null
     */
    public function getPalletSpace()
    {
        return $this->palletSpace;
    }
    /**
     * Set palletSpace value
     * @param int $palletSpace
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setPalletSpace($palletSpace = null)
    {
        // validation for constraint: int
        if (!is_null($palletSpace) && !(is_int($palletSpace) || ctype_digit($palletSpace))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($palletSpace, true), gettype($palletSpace)), __LINE__);
        }
        $this->palletSpace = $palletSpace;
        return $this;
    }
    /**
     * Get packageType value
     * @return string|null
     */
    public function getPackageType()
    {
        return $this->packageType;
    }
    /**
     * Set packageType value
     * @param string $packageType
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setPackageType($packageType = null)
    {
        // validation for constraint: string
        if (!is_null($packageType) && !is_string($packageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageType, true), gettype($packageType)), __LINE__);
        }
        $this->packageType = $packageType;
        return $this;
    }
    /**
     * Get tag value
     * @return string|null
     */
    public function getTag()
    {
        return $this->tag;
    }
    /**
     * Set tag value
     * @param string $tag
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tag, true), gettype($tag)), __LINE__);
        }
        $this->tag = $tag;
        return $this;
    }
    /**
     * Get goodsType value
     * @return string|null
     */
    public function getGoodsType()
    {
        return $this->goodsType;
    }
    /**
     * Set goodsType value
     * @param string $goodsType
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setGoodsType($goodsType = null)
    {
        // validation for constraint: string
        if (!is_null($goodsType) && !is_string($goodsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsType, true), gettype($goodsType)), __LINE__);
        }
        $this->goodsType = $goodsType;
        return $this;
    }
    /**
     * Get netWeight value
     * @return float|null
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param float $netWeight
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setNetWeight($netWeight = null)
    {
        // validation for constraint: float
        if (!is_null($netWeight) && !(is_float($netWeight) || is_numeric($netWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeight, true), gettype($netWeight)), __LINE__);
        }
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get weightUnit value
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->weightUnit;
    }
    /**
     * Set weightUnit value
     * @param string $weightUnit
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setWeightUnit($weightUnit = null)
    {
        // validation for constraint: string
        if (!is_null($weightUnit) && !is_string($weightUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weightUnit, true), gettype($weightUnit)), __LINE__);
        }
        $this->weightUnit = $weightUnit;
        return $this;
    }
    /**
     * Get volumeUnit value
     * @return string|null
     */
    public function getVolumeUnit()
    {
        return $this->volumeUnit;
    }
    /**
     * Set volumeUnit value
     * @param string $volumeUnit
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setVolumeUnit($volumeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($volumeUnit) && !is_string($volumeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($volumeUnit, true), gettype($volumeUnit)), __LINE__);
        }
        $this->volumeUnit = $volumeUnit;
        return $this;
    }
    /**
     * Get lengthUnit value
     * @return string|null
     */
    public function getLengthUnit()
    {
        return $this->lengthUnit;
    }
    /**
     * Set lengthUnit value
     * @param string $lengthUnit
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setLengthUnit($lengthUnit = null)
    {
        // validation for constraint: string
        if (!is_null($lengthUnit) && !is_string($lengthUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lengthUnit, true), gettype($lengthUnit)), __LINE__);
        }
        $this->lengthUnit = $lengthUnit;
        return $this;
    }
    /**
     * Get stackable value
     * @return bool|null
     */
    public function getStackable()
    {
        return $this->stackable;
    }
    /**
     * Set stackable value
     * @param bool $stackable
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setStackable($stackable = null)
    {
        // validation for constraint: boolean
        if (!is_null($stackable) && !is_bool($stackable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stackable, true), gettype($stackable)), __LINE__);
        }
        $this->stackable = $stackable;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get PackageIds value
     * @return \App\Lib\Unifaun\StructType\PackageIds|null
     */
    public function getPackageIds()
    {
        return $this->PackageIds;
    }
    /**
     * Set PackageIds value
     * @param \App\Lib\Unifaun\StructType\PackageIds $packageIds
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setPackageIds(\App\Lib\Unifaun\StructType\PackageIds $packageIds = null)
    {
        $this->PackageIds = $packageIds;
        return $this;
    }
    /**
     * Get DangerousGoods value
     * @return \App\Lib\Unifaun\StructType\DangerousGoods|null
     */
    public function getDangerousGoods()
    {
        return $this->DangerousGoods;
    }
    /**
     * Set DangerousGoods value
     * @param \App\Lib\Unifaun\StructType\DangerousGoods $dangerousGoods
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public function setDangerousGoods(\App\Lib\Unifaun\StructType\DangerousGoods $dangerousGoods = null)
    {
        $this->DangerousGoods = $dangerousGoods;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Lib\Unifaun\StructType\GoodsItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
