<?php

namespace App\Lib\Unifaun\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Split ServiceType
 * @subpackage Services
 */
class Split extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named split
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Lib\Unifaun\StructType\Split $parameters
     * @return \App\Lib\Unifaun\StructType\SplitResponse|bool
     */
    public function split(\App\Lib\Unifaun\StructType\Split $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->split($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Lib\Unifaun\StructType\SplitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
